

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetLastSeenMAForArchFile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetLastSeenMAForArchFile.sp,v $ $Id: GetLastSeenMAForArchFile.sp,v 1.1.2.4 2018/03/27 09:12:58 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetLastSeenMAForArchFile()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetLastSeenMAForArchFile <<<'

IF EXISTS (select * from sysobjects where name='GetLastSeenMAForArchFile')
	drop procedure GetLastSeenMAForArchFile
IF EXISTS (select * from GxQscripts where name='GetLastSeenMAForArchFile')
	delete from GxQscripts where name = 'GetLastSeenMAForArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLastSeenMAForArchFile')
	delete from GXDBVersions where aliasname = 'GetLastSeenMAForArchFile'
GO
print '... Creating Procedure: GetLastSeenMAForArchFile'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetLastSeenMAForArchFile
  @i_archFileId integer,
  @i_commCellid integer,
  @i_copyPrecedence integer,
  @o_lastSeenMAId integer OUTPUT,
  @o_lastSeenDrivePoolId integer OUTPUT
AS
	DECLARE @l_archCopyId int = 0
	DECLARE @l_VolumeId int = 0
	DECLARE @l_errorCode int = 0
	DECLARE @drivePoolId int = 0
	DECLARE @hostId int = 0
	--Try to fetch the drivepoolid from ArchFileCopy
	SELECT top 1 @drivePoolId = AFC.drivePoolId, @l_archCopyId = AFC.archCopyId
	FROM ArchFileCopy AFC WITH(NOLOCK) INNER JOIN ArchFile AF WITH(NOLOCK) ON AFC.ArchFileId = AF.id AND AFC.CommcellId = AF.CommcellId
	INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON AFC.ArchCopyId = AGC.id
	WHERE AF.id = @i_archFileId AND AF.commCellId = @i_commCellid
	AND ((AGC.copy = @i_copyPrecedence AND @i_copyPrecedence > 0) OR @i_copyPrecedence = 0)
AND AF.isValid = 1 AND AFC.isValid = 1 AND AGC.type <> 5
	ORDER BY AGC.copy ASC, AF.cTime DESC
	IF(@drivePoolId > 0)
		GOTO CX_EXIT
	SELECT top 1 @l_VolumeId = AC.VolumeId
	FROM ArchChunkMapping ACM WITH(NOLOCK) INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.ArchChunkId = AC.id
	AND ACM.ChunkCommcellId = AC.CommcellId
	WHERE ACM.ArchFileId = @i_archFileId AND ACM.CommcellId = @i_commCellid AND ACM.ArchCopyId = @l_archCopyId AND ACM.ChunkNumber = 1
	IF(@l_VolumeId > 0)
	BEGIN
		IF object_id('tempdb.dbo.#tmpMA_DP') IS NOT NULL DROP TABLE #tmpMA_DP
		CREATE TABLE #tmpMA_DP (
		mmErrorCode         integer,
mediaAgentName      varchar(1024),
		clientId            integer,
		nasClientId         integer,
		clientReleaseId     integer,
filerName           varchar(1024),
		hostId              integer,
		drivepoolId         integer,
		drivepoolType       integer,
		libraryId           integer,
		libraryTypeId       integer,
		libraryAttribute    integer,
libraryName         varchar(128),
libraryAliasName    varchar(128),
barCode             varchar(256),
		volumeId            integer,
		mediaLocation       integer,
		jobOpType           integer,
		failureType         integer)
		EXEC    @l_errorCode = MMS2GetMAAndDPForVolume @l_volumeId, 0, 0, 0, 0, 0
		IF (@l_errorCode <> 0)
		GOTO CX_EXIT
		SELECT @drivePoolId = ISNULL(drivePoolId, 0) FROM #tmpMA_DP
		IF (@drivePoolId > 0)
			GOTO CX_EXIT
	END
	IF(@drivePoolId = 0)
		SELECT @drivePoolId = ISNULL(CAST(value AS int),0) FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'BrowseMediaAgentDPArchMgr'
CX_EXIT:
	IF (@drivePoolId > 0)
		SELECT @o_lastSeenMAId = ClientId, @o_lastSeenDrivePoolId = drivePoolId FROM MMDrivePool WITH (NOLOCK) WHERE DrivePoolId = @drivePoolId
	ELSE
	BEGIN
		SET @o_lastSeenMAId = -1
		SET @o_lastSeenDrivePoolId = 0
	END
	IF object_id('tempdb.dbo.#tmpMA_DP') IS NOT NULL DROP TABLE #tmpMA_DP
	RETURN @l_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'GetLastSeenMAForArchFile')
	delete from GxQscripts where name = 'GetLastSeenMAForArchFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLastSeenMAForArchFile')
	delete from GXDBVersions where aliasname = 'GetLastSeenMAForArchFile'
GO

insert into GXDBVersions values(2, 'GetLastSeenMAForArchFile',  '00010001000200040000', 'GetLastSeenMAForArchFile', '00010001000200040000')
GO

