

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetLMUploadedFileStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetLMUploadedFileStatus.sp,v $ $Id: GetLMUploadedFileStatus.sp,v 1.5.40.3 2016/12/05 23:58:07 rbadraraju Exp $"
--
--  +========================================================================+
--  | Stored Precedure: GetLMUploadedFileStatus()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Mrityunjay upadhyay GetLMUploadedFileStatus to fetch uploaded file status
--	|   message
--	|	Message LMUploadedFileStatusReq
--	|	{
--	|		wstring requestId
--	|		wstring uploadTag
--	|		int userId
--	|	}
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetLMUploadedFileStatus <<<'

IF EXISTS (select * from sysobjects where name='GetLMUploadedFileStatus')
	drop procedure GetLMUploadedFileStatus
IF EXISTS (select * from GxQscripts where name='GetLMUploadedFileStatus')
	delete from GxQscripts where name = 'GetLMUploadedFileStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMUploadedFileStatus')
	delete from GXDBVersions where aliasname = 'GetLMUploadedFileStatus'
GO
print '... Creating Procedure: GetLMUploadedFileStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetLMUploadedFileStatus
  @i_xml XML,
  @o_xml XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @requestId NVARCHAR(1024)
DECLARE @uploadTag  NVARCHAR(1024)
DECLARE @userId int
DECLARE @pageOffset int
DECLARE @rowsPerPage int
DECLARE @totalTags int
DECLARE @activeUploadsFlag int
--Set @i_xml = '<LogMonitoring_LMUploadedFileStatusReq requestId="" uploadTag="xyz" userId="1"/>'
SELECT @requestId = ISNULL(N.details.value('@requestId','varchar(20)'),'')
FROM @i_xml.nodes('LogMonitoring_LMUploadedFileStatusReq')  as N(details)
SELECT @uploadTag = ISNULL(N.details.value('@uploadTag','varchar(20)'),'')
FROM @i_xml.nodes('LogMonitoring_LMUploadedFileStatusReq')  as N(details)
SELECT @userId = ISNULL(N.details.value('@userId','varchar(20)'),0)
FROM @i_xml.nodes('LogMonitoring_LMUploadedFileStatusReq')  as N(details)
SELECT @pageOffset = ISNULL(N.details.value('@pageOffset','varchar(20)'),0)
FROM @i_xml.nodes('LogMonitoring_LMUploadedFileStatusReq')  as N(details)
SELECT @rowsPerPage = ISNULL(N.details.value('@tagsPerPage','varchar(20)'),0)
FROM @i_xml.nodes('LogMonitoring_LMUploadedFileStatusReq')  as N(details)
SELECT @activeUploadsFlag = ISNULL(N.details.value('@activeUploadsFlag','varchar(20)'),0)
FROM @i_xml.nodes('LogMonitoring_LMUploadedFileStatusReq')  as N(details)
declare @t table
( RowId int NOT NULL identity(1,1),
  userid int,
  uploadTag nvarchar(MAX),
  m_created bigint
  )
DECLARE @ut table
(
  uploadTag nvarchar(MAX)
)
-- active upload tags
INSERT into @ut
SELECT uploadTag
FROM LMUploadInfo
WHERE flag NOT IN (3,4,6,7)
INSERT into @t
SELECT userid, uploadTbl.uploadTag, MAX(created) as m_created
FROM LMUploadInfo uploadTbl LEFT JOIN @ut uploadTagTbl ON uploadTbl.uploadTag = uploadTagTbl.uploadTag
WHERE uploadTbl.userId = @userId AND ((@activeUploadsFlag=0 AND uploadTagTbl.uploadTag IS NULL) OR (@activeUploadsFlag<>0 AND uploadTagTbl.uploadTag IS NOT NULL))
GROUP BY userId, uploadTbl.uploadTag ORDER BY m_created DESC
SET @totalTags = (SELECT COUNT(DISTINCT uploadTag) FROM @t)
DELETE FROM @t
WHERE RowId <=  (@pageOffset * @rowsPerPage) OR RowId > ((@pageOffset * @rowsPerPage) + @rowsPerPage)
SET @o_xml = (select @totalTags as "@totalTags",(
	  SELECT uploadTag AS "@uploadTag",
	  T2.RowId AS "@RowNum",
	  (
      SELECT
      requestId as "@requestId",
      uploadTag as "@uploadTag",
      userId as "@userId",
      flag as "@status",
      destPath as "@filePath",
	  failureReason as "@errorCode"
      FROM LMUploadInfo T1
	  where T1.userId = T2.userId and T1.uploadTag = T2.uploadTag
      order by T2.m_created desc
      FOR
      XML PATH('uploadedFileStatus'),
      TYPE
	)
	from @t as T2
	order by T2.m_created desc
FOR XML PATH ('uploadTagStatus'), TYPE)
FOR XML PATH('LogMonitoring_LMUploadedFileStatusResp'))
SET @o_xml =  ISNULL(@o_xml,'<LogMonitoring_LMUploadedFileStatusResp/>')
GO
GO

IF EXISTS (select * from GxQscripts where name = 'GetLMUploadedFileStatus')
	delete from GxQscripts where name = 'GetLMUploadedFileStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMUploadedFileStatus')
	delete from GXDBVersions where aliasname = 'GetLMUploadedFileStatus'
GO

insert into GXDBVersions values(2, 'GetLMUploadedFileStatus',  '00010005004000030000', 'GetLMUploadedFileStatus', '00010005004000030000')
GO

