

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetLMNamesFromSolrFieldNames.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetLMNamesFromSolrFieldNames.sp,v $ $Id: GetLMNamesFromSolrFieldNames.sp,v 1.13.12.12 2017/12/28 06:16:05 syadav Exp $"
--
--  +========================================================================+
--  | Stored Precedure: GetLMNamesFromSolrFieldNames()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Mrityunjay upadhyay GetLMNamesFromSolrFieldNames to fetch display name for solr fields and type of fields
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetLMNamesFromSolrFieldNames <<<'

IF EXISTS (select * from sysobjects where name='GetLMNamesFromSolrFieldNames')
	drop procedure GetLMNamesFromSolrFieldNames
IF EXISTS (select * from GxQscripts where name='GetLMNamesFromSolrFieldNames')
	delete from GxQscripts where name = 'GetLMNamesFromSolrFieldNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMNamesFromSolrFieldNames')
	delete from GXDBVersions where aliasname = 'GetLMNamesFromSolrFieldNames'
GO
print '... Creating Procedure: GetLMNamesFromSolrFieldNames'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetLMNamesFromSolrFieldNames
  @i_xml XML,
  @o_xml XML OUTPUT
AS
SET NOCOUNT ON
Declare   @tmp table
(
id int NOT NULL identity(1,1),
templateId int,
solrFieldName nvarchar(1024),
solrFieldNameWithoutFieldTypeIdentifier nvarchar(1024),
displayName nvarchar(1024),
descriptionOfField nvarchar(1024),
type int,
datatype int,
formatType int,
policyName nvarchar(1024),
templateType INT
);
Declare   @tmp2 table
(
id int NOT NULL identity(1,1),
templateId int,
solrFieldName nvarchar(1024),
solrFieldNameWithoutFieldTypeIdentifier nvarchar(1024),
displayName nvarchar(1024),
descriptionOfField nvarchar(1024),
type int,
datatype int,
formatType int,
policyName nvarchar(1024),
templateType INT
);
declare @templateids table (templateId int)
declare @errorCode int = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
insert into @templateids
select N.template.value('@val','varchar(20)') as templateId
from @i_xml.nodes('LogMonitoring_GetDisplayNameForFieldNamesReq/templateId')  as N(template)
if not exists (select * from @templateids) -- all template request
begin
	delete from @templateids
	insert into @templateids
	select templateId from APP_Template
end
declare @templateid int = 0
--Close and deallocate the cursor if it is already open
IF ( CURSOR_STATUS(N'global', N'templateid_cursor_lm') >= 0  /* cursor is open */
OR CURSOR_STATUS(N'local', 'templateid_cursor_lm') >= 0 )
	CLOSE templateid_cursor_lm
IF ( CURSOR_STATUS('global','templateid_cursor_lm') = -1  /* cursor is closed */
OR CURSOR_STATUS('local','templateid_cursor_lm') = -1 )
	DEALLOCATE templateid_cursor_lm
DECLARE templateid_cursor_lm CURSOR FOR
select templateId from @templateids
insert into @tmp
values(0,'TemplateName','TemplateName','Template','',7,1,0,'', 0)
insert into @tmp
values(0,'MonitoringPolicyName','MonitoringPolicyName','Policy','',7,1,0,'', 0)
insert into @tmp
values(0,'ClientName','ClientName','Client','',7,1,0,'', 0)
--insert into @tmp
--values(@templateid,'MonitoringCriteriaName','Criteria','',3, 0)
insert into @tmp
values(0,'FileName','FileName','File','',7,1,0,'', 0)
insert into @tmp
values(0,'tag_ss','tag','Tags','',7,1,0,'', 0)
insert into @tmp
values(0,'parentfolder_sf','parentfolder','Parent Folder','',7,1,0,'', 0)
--insert into @tmp
--values(0,'FolderName','Folder Name','',7,1,0)
--fields from templates
insert into @tmp
values(@templateid,'keys','keys','Discovered Events','',7,1,0,'', 0)
IF EXISTS ( SELECT 1
			FROM APP_MonitoringPolicy A WITH (NOLOCK), APP_MonitoringPolicyProp AP WITH (NOLOCK)
			WHERE A.monitorPolicyId = AP.monitorPolicyId
			AND A.status <> 3
			AND AP.attrName = 'Monitoring Type'
			AND AP.attrVal = '7' )
BEGIN
	insert into @tmp
	values(0, 'serialno_sf', 'serialno', 'Client Serial No','',7,1,0,'', 0)
  insert into @tmp
  values(0, 'regcode_sf', 'regcode', 'Client Registration Code','',7,1,0,'', 0)
END
UPDATE @tmp
SET type = type + 8
OPEN templateid_cursor_lm
SELECT @errorCode = @@ERROR
IF(@errorCode != 0) GOTO PROC_EXIT
FETCH NEXT FROM templateid_cursor_lm INTO @templateid
WHILE @@FETCH_STATUS = 0
BEGIN
	declare @xmlinput xml
	declare @templateType INT= 0
    SET @xmlinput = (select CONVERT(XML,CONVERT(varchar(MAX),templateXML)) from APP_Template where    templateId = @templateid )
	SET @templateType = (SELECT status FROM APP_template WITH (NOLOCK) WHERE templateId = @templateId)
	SELECT @errorCode = @@ERROR
	IF(@errorCode != 0) GOTO PROC_EXIT
	--common fields
	insert into @tmp
    select  @templateid, (CASE WHEN @templateType = 4  AND LEN(N.tableInfoList.value('(dataExtractionOption/@regexPattern)[1]', 'NVARCHAR(1024)')) > 0
						THEN
							LOWER(N.tableInfoList.value('@solrFieldName', 'Nvarchar(1024)')) + LOWER(N.tableInfoList.value('@index', 'Nvarchar(1024)'))
						ELSE
							LOWER(N.tableInfoList.value('@solrFieldName', 'NVARCHAR(1024)'))
						END) as solrFieldName ,
						(CASE WHEN @templateType = 4  AND LEN(N.tableInfoList.value('(dataExtractionOption/@regexPattern)[1]', 'NVARCHAR(1024)')) > 0
						THEN
							LOWER(N.tableInfoList.value('@solrFieldName', 'Nvarchar(1024)')) + LOWER(N.tableInfoList.value('@index', 'Nvarchar(1024)'))
						ELSE
							LOWER(N.tableInfoList.value('@solrFieldName', 'NVARCHAR(1024)'))
						END) as solrFieldNameWithoutFieldTypeIdentifier,
	ISNULL(N.tableInfoList.value('@aliasName', 'NVARCHAR(1024)'), N.tableInfoList.value(('(column/@columnName)[1]'), 'NVARCHAR(1024)')) as displayName,
    '',
    N.tableInfoList.value('@isFacet', 'int')*1+ N.tableInfoList.value('@isIndexed', 'int')*2+4 + ISNULL(N.tableInfoList.value('@showAsColumn', 'int'),1) * 8 + ISNULL(N.tableInfoList.value('@isMultiValued', 'int'),0) * 16 + ISNULL(N.tableInfoList.value('@isTokenized', 'int'),0) * 32 + ISNULL(N.tableInfoList.value('@convertInUTC', 'INT'),0) * 64,
    N.tableInfoList.value(('@primaryDataType'),'int') as datatype,
    N.tableInfoList.value(('@primaryTypeFormat'),'int') as formatType,
    '' as policyName,
	@templateType
	from  @xmlinput.nodes('LogMonitoring_TemplateXML/columns')as N(tableInfoList) where ISNULL(N.tableInfoList.value('@isStored','int'),1)<>0
	FETCH NEXT FROM templateid_cursor_lm INTO @templateid
END
PROC_EXIT:
delete from @tmp
where solrFieldName IS NULL
-- we maintain two sets ok keys for facet type columns. one for display another is for search.
-- display one is of type string and search is of type lowercase
--first take out keys which are of string type and are faceted. and add field of type lower non faceted.
insert into @tmp2
select templateId,(case when type&16 = 16 then solrFieldName+'_ls' else solrFieldName+'_lf' end),solrFieldNameWithoutFieldTypeIdentifier,displayName,descriptionOfField,type - 1, datatype, formatType, policyName, templateType
from @tmp
where datatype in (1) and  ((type & 1) <> 0) and templateId >0 and not(solrFieldName in ('threadid','jobid') and templateId = 1) --special case for simpana
-- for non faceted string type fields we have lower case indexed.
update @tmp
set solrFieldName = solrFieldName+ '_'+ (case
when datatype=0 then (case when formatType = 1 OR formatType = 2 then 's' --hex, binary
						   when formatType = 26 then 'd' -- float
						   else 'i' end)
when datatype=1 then 'l'
WHEN datatype=2
THEN (	CASE WHEN templateType = 4
		THEN CASE WHEN type & 64 <> 0
			THEN 'u_t'
			ELSE 't'
			END
         ELSE 's'
    END )
WHEN datatype = 3
THEN (	CASE WHEN templateType = 4
		 THEN
				CASE WHEN type &64 <> 0
				THEN  'u_t_i'
				ELSE 't_i'
				END
		 ELSE 's'
    END )
END)
 +(case  when type&16 = 16 then 's' when type&1 = 1 then 'f' when type&2 = 2 then (case when type&32 = 32 then 't' else 'f' end) else 'n' end) --+ (case when type&2=2 then 'i' else 'N' end)+ '_LMDF' --+(case when type&4 = 4 then 'S' else 'N' end) +
where ((type & 1) = 0) and templateId >0
-- faceted of type string.
update @tmp
set solrFieldName = solrFieldName+ '_'+ (case
when datatype=0 then (case when formatType = 1 OR formatType = 2 then 's' --hex, binary
						   when formatType = 26 then 'd' -- float
						   else 'i' end)
when datatype=1 then 's'
WHEN datatype=2
	THEN (	CASE WHEN templateType = 4
			THEN CASE WHEN type & 64 <> 0
				THEN 'u_t'
				ELSE 't'
				END
             ELSE 's'
        END )
WHEN datatype = 3
	THEN (	CASE WHEN templateType = 4
			 THEN
					CASE WHEN type &64 <> 0
					THEN  'u_t_i'
					ELSE 't_i'
					END
			 ELSE 's'
        END )
END)
 +(case when type&16 = 16 then 's' when type&1 = 1 then 'f' when type&2 = 2 then 'f' else 'n' end) --+ (case when type&2=2 then 'i' else 'N' end)+ '_LMDF' --+(case when type&4 = 4 then 'S' else 'N' end) +
where ((type & 1) <> 0) and templateId >0
--add lower case keys
insert into @tmp
select templateId,solrFieldName,solrFieldNameWithoutFieldTypeIdentifier,displayName,descriptionOfField,type, datatype, formatType, policyName, templateType
from @tmp2
--special case
update @tmp
set solrFieldName = 'jobid_if'
where solrFieldName = 'jobid_sf' and (templateId = 1 OR templateId IN (SELECT templateId FROM APP_Template WITH(NOLOCK) WHERE templateForMonitoringType = 5))
update @tmp
set solrFieldName = 'threadid_sf'
where solrFieldName = 'threadid_if' and templateId = 1
UPDATE T
SET solrFieldName = 'date_sf'
FROM @tmp T, APP_Template AT WITH (NOLOCK)
WHERE T.templateId = AT.templateId AND AT.status <> 4 AND  solrFieldName = 'date_tf'
UPDATE T
SET solrFieldName = 'time_sf'
FROM @tmp T, APP_Template AT WITH (NOLOCK)
WHERE T.templateId = AT.templateId AND AT.status <> 4 AND solrFieldName = 'time_tf'
Declare   @tmp_mon table
(
id int NOT NULL identity(1,1),
templateId int,
solrFieldName nvarchar(1024),
solrFieldNameWithoutFieldTypeIdentifier nvarchar(1024),
displayName nvarchar(1024),
descriptionOfField nvarchar(1024),
type int,
datatype int,
formatType int,
policyId int,
policyName nvarchar(1024)
);
declare @policy int
declare @policyName nvarchar(1024)
declare @template int
declare @xmlinput1 xml
declare @varchar varchar(MAX)
IF ( CURSOR_STATUS(N'global', N'MP_Extraction_Option_cur') >= 0  /* cursor is open */
OR CURSOR_STATUS(N'local', 'MP_Extraction_Option_cur') >= 0 )
	CLOSE MP_Extraction_Option_cur
IF ( CURSOR_STATUS('global','MP_Extraction_Option_cur') = -1  /* cursor is closed */
OR CURSOR_STATUS('local','MP_Extraction_Option_cur') = -1 )
	DEALLOCATE MP_Extraction_Option_cur
DECLARE MP_Extraction_Option_cur CURSOR FOR
select MP.monitorPolicyId,MP.MonitorPolicyName,MPT.templateId,MPP.attrVal from APP_MonitoringPolicy MP join APP_MonitorTemplateAssoc MPT on MP.monitorPolicyId = MPT.monitorPolicyId Join APP_MonitoringPolicyProp MPP on MP.monitorPolicyId = MPP.monitorPolicyId
where MP.status <>3 and MPP.attrName = 'extraction options'
OPEN MP_Extraction_Option_cur
SELECT @errorCode = @@ERROR
IF(@errorCode != 0) GOTO PROC_EXIT
FETCH NEXT FROM MP_Extraction_Option_cur INTO @policy,@policyName,@template,@varchar
WHILE @@FETCH_STATUS = 0
BEGIN
	set @xmlinput1 = (select CONVERT(XML,CONVERT(varchar(MAX),@varchar)))
    insert into @tmp_mon
    select  @template,
      LOWER(N.tableInfoList.value(('(@solrFieldNameToIndexMatchedPattern)[1]'), 'Nvarchar(1024)')) as solrFieldName,
      LOWER(N.tableInfoList.value(('(@solrFieldNameToIndexMatchedPattern)[1]'), 'Nvarchar(1024)')) as solrFieldNameWithoutFieldTypeIdentifier,
      N.tableInfoList.value(('(@eventDisplayName)[1]'), 'Nvarchar(1024)') as displayName,
      '',
      7,
    N.tableInfoList.value(('(@dataType)'), 'Nvarchar(1024)') as datatype,
    0,
    @policy,
    @policyName
    from  @xmlinput1.nodes('LogMonitoring_LMDataExtractionPatterns/patterns')as N(tableInfoList)
FETCH NEXT FROM MP_Extraction_Option_cur INTO @policy,@policyName,@template,@varchar
END
	delete from @tmp_mon where solrFieldName = ''
   update @tmp_mon
	set solrFieldName = solrFieldName+ '_'+ (case
	when datatype=0 then 'is'
	when datatype=1 then 'ds'
	when datatype=2 then 'ss'
	END)
insert into @tmp
select templateId,solrFieldName,solrFieldNameWithoutFieldTypeIdentifier,displayName,descriptionOfField
,type,datatype,formatType,policyName, 0 from @tmp_mon
where templateId in (select templateId from @templateids)
IF EXISTS (select top 1 templateId  from @tmp where templateId=1)
insert into @tmp
values(1,'commserver_sf','commserver','Commserver','',7,1,0,'', 0)
UPDATE @tmp
SET datatype = CASE
				WHEN solrFieldName LIKE '%_sf'
				THEN  0
				WHEN solrFieldName LIKE '%_sn'
				THEN  1
				WHEN solrFieldName LIKE '%_xf'
				THEN  2
				WHEN solrFieldName LIKE '%_xn'
				THEN  3
				WHEN solrFieldName LIKE '%_if'
				THEN  4
				WHEN solrFieldName LIKE '%_in'
				THEN  5
				WHEN solrFieldName LIKE '%_df'
				THEN  6
				WHEN solrFieldName LIKE '%_dn'
				THEN  7
				WHEN solrFieldName LIKE '%_DEC_OF_HEX'
				THEN  8
				WHEN solrFieldName LIKE '%_DEC_OF_BIN'
				THEN  9
				WHEN solrFieldName LIKE '%_FLOAT_OF_HEX'
				THEN  10
				WHEN solrFieldName LIKE '%_FLOAT_OF_BIN'
				THEN  11
				WHEN solrFieldName LIKE '%_lf'
				THEN  12
				WHEN solrFieldName LIKE '%_ln'
				THEN  13
				WHEN solrFieldName LIKE '%_tf'
				THEN  14
				WHEN solrFieldName LIKE '%_tn'
				THEN  15
				ELSE
				datatype
				END
set @o_xml = (SELECT 0 AS "@errorcode",'' AS "@errorMessage", (
SELECT templateId AS "@templateId",
solrFieldName AS "@solrFieldName",
solrFieldNameWithoutFieldTypeIdentifier AS "@solrFieldNameWithoutFieldTypeIdentifier",
displayName AS "@displayName",
descriptionOfField AS "@descriptioOfField",
type AS "@type",
dataType AS "@dataType",
policyName as "@policyName"
FROM @tmp  order by templateId
FOR
XML PATH('displayNames'),
TYPE
)
FOR XML PATH('LogMonitoring_GetDisplayNameForFieldNamesResp'))
SET NOCOUNT OFF
GO
GO

IF EXISTS (select * from GxQscripts where name = 'GetLMNamesFromSolrFieldNames')
	delete from GxQscripts where name = 'GetLMNamesFromSolrFieldNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMNamesFromSolrFieldNames')
	delete from GXDBVersions where aliasname = 'GetLMNamesFromSolrFieldNames'
GO

insert into GXDBVersions values(2, 'GetLMNamesFromSolrFieldNames',  '00010013001200120000', 'GetLMNamesFromSolrFieldNames', '00010013001200120000')
GO

