

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetLMListOfTemplate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetLMListOfTemplate.sp,v $ $Id: GetLMListOfTemplate.sp,v 1.4.60.1 2017/05/26 10:31:07 syadav Exp $"
--
--  +========================================================================+
--  | Stored Precedure: GetLMListOfTemplate()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Mrityunjay upadhyay GetLMListOfTemplate to fetch list of templates based on input
--	|   message
--	|	Message GetListOfTemplatesByTemplateId
--	|	{
--	|		list<int> templateId
--	|		boolean includeTemplateXML
--	|	}
--	|	set includeTemplateXML to true to gext template column list else it will return only name id and description
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetLMListOfTemplate <<<'

IF EXISTS (select * from sysobjects where name='GetLMListOfTemplate')
	drop procedure GetLMListOfTemplate
IF EXISTS (select * from GxQscripts where name='GetLMListOfTemplate')
	delete from GxQscripts where name = 'GetLMListOfTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMListOfTemplate')
	delete from GXDBVersions where aliasname = 'GetLMListOfTemplate'
GO
print '... Creating Procedure: GetLMListOfTemplate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetLMListOfTemplate
  @i_xml XML,
  @o_xml XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE   @templateTbl table
(
	id int NOT NULL identity(1,1),
	templateId int
);
DECLARE @includeDetail INT
DECLARE @OemBramdId int
SET @OemBramdId = 1
DECLARE @flag INT = 0       -- 0 means all, 1 means for upload policy
--DECLARE @x XML
--SET @x = '<LogMonitoring_GetListOfTemplatesByTemplateId includeTemplateXML="1"><templateId val="1"></templateId></LogMonitoring_GetListOfTemplatesByTemplateId>'
SELECT @flag =  ISNULL(N.details.value('@flag', 'INT'),0)
FROM @i_xml.nodes('LogMonitoring_GetListOfTemplatesByTemplateId')  as N(details)
INSERT INTO @templateTbl
SELECT N.templateId.value('@val','varchar(20)') AS templateId
FROM @i_xml.nodes('LogMonitoring_GetListOfTemplatesByTemplateId/templateId')  AS N(templateId)
SELECT @includeDetail = ISNULL(N.details.value('@includeTemplateXML','varchar(20)'),0)
FROM @i_xml.nodes('LogMonitoring_GetListOfTemplatesByTemplateId')  as N(details)
IF NOT EXISTS (SELECT * FROM @templateTbl) -- all template request
BEGIN
	DELETE FROM @templateTbl
	IF(@flag = 1)
	BEGIN
		INSERT INTO @templateTbl
		SELECT templateId
		FROM APP_Template WITH (NOLOCK)
		WHERE status <> 4
	END
	ELSE
	BEGIN
		INSERT INTO @templateTbl
		SELECT templateId
		FROM APP_Template WITH (NOLOCK)
	END
END
IF EXISTS (SELECT value FROM GXGlobalParam WHERE name = 'MiniBrandId')
BEGIN
        SET @OemBramdId = (SELECT TOP 1 CONVERT(INT, CONVERT(NVARCHAR, value)) FROM GXGlobalParam WHERE name = 'MiniBrandId')
END
SET @o_xml = (SELECT (
				SELECT
				"@LMTemplateXML" = CASE
					WHEN @includeDetail = 1 THEN
						templateXML
					ELSE
						''
					END,
					case when T.templateId = 1 then
					(select top 1 OEMName from simOEM where OEMId in (select OEMId from SimMiniBrand where MiniBrandId = @OemBramdId)) + ' Logs'
					else
					templateDescription
					end
					AS "@description",
				templateForMonitoringType AS "@templateForMonitoringType", AT.status AS "@status",
				(
					SELECT 86 AS "@_type_",
					T.templateId AS "@templateId",
					case when T.templateId = 1 then
					(select top 1 OEMName from simOEM where OEMId in (select OEMId from SimMiniBrand where MiniBrandId = @OemBramdId)) + ' Logs'
					else
					templateName
					end
					AS "@templateName"
					FOR XML PATH('LMTemplateEntity'), type
				)
				FROM APP_Template AT Join @templateTbl T ON AT.templateId = T.templateId
				where AT.status <>3 order by T.templateId
				FOR
				XML PATH('LMTemplates'),
				TYPE
			)
			FOR XML PATH('LogMonitoring_GetListOfTemplatesResp'))
GO
GO

IF EXISTS (select * from GxQscripts where name = 'GetLMListOfTemplate')
	delete from GxQscripts where name = 'GetLMListOfTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMListOfTemplate')
	delete from GXDBVersions where aliasname = 'GetLMListOfTemplate'
GO

insert into GXDBVersions values(2, 'GetLMListOfTemplate',  '00010004006000010000', 'GetLMListOfTemplate', '00010004006000010000')
GO

