

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetLMGetListOfPolicyAssociatedToCloudClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetLMGetListOfPolicyAssociatedToCloudClient.sp,v $ $Id: GetLMGetListOfPolicyAssociatedToCloudClient.sp,v 1.4.60.8 2017/03/17 16:21:57 pankajkumar Exp $"
--
--  +========================================================================+
--  | Stored Precedure: GetLMGetListOfPolicyAssociatedToCloudClient()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Mrityunjay upadhyay GetLMGetListOfPolicyAssociatedToCloudClient to fetch monitoring policies associated to a given cloud node
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetLMGetListOfPolicyAssociatedToCloudClient <<<'

IF EXISTS (select * from sysobjects where name='GetLMGetListOfPolicyAssociatedToCloudClient')
	drop procedure GetLMGetListOfPolicyAssociatedToCloudClient
IF EXISTS (select * from GxQscripts where name='GetLMGetListOfPolicyAssociatedToCloudClient')
	delete from GxQscripts where name = 'GetLMGetListOfPolicyAssociatedToCloudClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMGetListOfPolicyAssociatedToCloudClient')
	delete from GXDBVersions where aliasname = 'GetLMGetListOfPolicyAssociatedToCloudClient'
GO
print '... Creating Procedure: GetLMGetListOfPolicyAssociatedToCloudClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetLMGetListOfPolicyAssociatedToCloudClient
  @i_xml XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @cloudClientId int
--declare @i_xml xml
--set @i_xml='<?xml version="1.0" encoding="UTF-8" standalone="no" ?><LogMonitoring_LMGetListOfPolicyAssociatedToCloudClientReq cloudClientId="3"/>'
select @cloudClientId=b.value('@cloudClientId','int')
from @i_xml.nodes('LogMonitoring_LMGetListOfPolicyAssociatedToCloudClientReq') as a(b)
Declare   @tmp table
(
cloudId int,
monitoringPolicyid int,
retentionDays int null,
status int null
);
Declare @cloudId INT
DECLARE @oneDayInSec BIGINT
SET @oneDayInSec = (24 * 60 * 60)
DECLARE @midNightDate DATETIME
SET @midNightDate = ( SELECT CONVERT(DATETIME, DATEDIFF(DAY, 0,GETUTCDATE())))
DECLARE @midNightEpochDate BIGINT
SET @midNightEpochDate = DBO.GetUnixTime(@midNightDate)
select @cloudId = SC.CloudId
FROM DM2SearchServerCoreInfo SC Join DM2CloudCoreRole CR
ON SC.CloudId = CR.CloudId Join Dm2cloud C ON SC.CloudId = C.cloudid
WHERE roleid = 3 AND SC.ClientId = @cloudClientId;
insert into @tmp
select @cloudId,monitorPolicyId,CONVERT(INT,attrVal),0 from
APP_MonitoringPolicyProp where attrName like 'age ci data after days' and monitorPolicyId in
(
	SELECT DISTINCT propTbl.monitorPolicyId FROM APP_MonitoringPolicyProp propTbl
	INNER JOIN APP_MonitoringPolicy policyTbl
	ON propTbl.monitorPolicyId = policyTbl.monitorPolicyId
	WHERE
	(
		propTbl.monitorPolicyId in
		(
			select distinct monitorPolicyId from APP_MonitoringPolicyProp
			where (attrName like 'Cloud Id' OR attrName like 'old cloud id to prune data') and
			attrVal = CONVERT(NVARCHAR(20),@cloudId)
		)
		AND
		(
			policyTbl.status = 3 OR (propTbl.attrName like 'enable ci data ageing' and propTbl.attrVal= CONVERT(NVARCHAR(1),1))
		)
	)
)
update @tmp set status = MP.status
from @tmp T join APP_MonitoringPolicy MP on T.monitoringPolicyid = MP.monitorPolicyId
-- Now what if some policies are deconfigured.
--cores of those policy will be in solr in wq is not sent.
--So we send those policies with status = 3 , that will prune all data when space check runs.
MERGE @tmp as T
USING
(SELECT DISTINCT coreTbl.PolicyId
FROM APP_LMCoreInfo coreTbl WITH(NOLOCK)
INNER JOIN APP_MonitoringPolicyProp propTbl WITH(NOLOCK)
ON coreTbl.PolicyId = propTbl.monitorPolicyId
WHERE coreTbl.ClientId = @cloudClientId AND propTbl.attrName = 'enable ci data ageing' AND propTbl.attrVal = CONVERT(NVARCHAR(1),1) ) as deconfiguredPolicy
ON deconfiguredPolicy.policyId = T.monitoringPolicyid
WHEN NOT MATCHED
THEN INSERT(cloudId,monitoringPolicyid,retentionDays,status)
VALUES(@cloudId,deconfiguredPolicy.policyId,1,3); -- if you make status to 3 , then retention wil be set to 0 and all cores wil be unloaded.
Declare @cloudtbl table
(
  cloudId INTEGER,
  enabled INTEGER,
  attributes INTEGER,
  coreRoles INTEGER,
  flags INTEGER,
  cloudClientId INTEGER,
  baseport NVARCHAR(6),
  url NVARCHAR(2000),
  serviceLink NVARCHAR(2000),
  cloudName NVARCHAR(512)
);
insert into @cloudtbl
exec LMGetCloudInfo @cloudId,0;
declare @o_xml XML
set @o_xml = (SELECT 0 AS "@errorcode",'' AS "@errorMessage", (
SELECT monitoringPolicyid AS "@policyId",
retentionDays AS "@retentionDays",
status AS "@status"
,
(
	ISNULL(
	(
	SELECT attrVal
	FROM APP_MonitoringPolicyProp WITH(NOLOCK)
	WHERE monitorPolicyId = monitoringPolicyid AND attrName = 'Factor'
	) ,
	1 ) -- 1 is default factor , i.e., day factor
) as '@factor',
(
	SELECT CoreName AS '@coreName'
	FROM APP_LMCoreInfo WITH(NOLOCK)
	WHERE PolicyId = monitoringPolicyid and IsLoaded = 1
	FOR XML PATH ('coreInfo') , TYPE
),
(
	SELECT startTime AS '@startPeriod' , endTime AS '@endPeriod'
	FROM App_LmCoreReqInfo WITH(NOLOCK)
	WHERE policyId = monitoringPolicyid and ( (RequestedDate + (noOfDays* @oneDayInSec))  >=  @midNightEpochDate) -- IT this cases is true , then requested duration is aged.
	FOR XML PATH('requestedTimeInterval') , TYPE
)
FROM @tmp
FOR
XML PATH('retention'),
TYPE
),
(
select
url as "@hostname",
baseport as "@baseport",
serviceLink as "@nodeURL"
from @cloudtbl
FOR
XML PATH ('cloudinfo'),
TYPE
)
FOR XML PATH('LogMonitoring_LMGetListOfPolicyAssociatedToCloudClientResp'))
select @o_xml as o_xml
GO

IF EXISTS (select * from GxQscripts where name = 'GetLMGetListOfPolicyAssociatedToCloudClient')
	delete from GxQscripts where name = 'GetLMGetListOfPolicyAssociatedToCloudClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMGetListOfPolicyAssociatedToCloudClient')
	delete from GXDBVersions where aliasname = 'GetLMGetListOfPolicyAssociatedToCloudClient'
GO

insert into GXDBVersions values(2, 'GetLMGetListOfPolicyAssociatedToCloudClient',  '00010004006000080000', 'GetLMGetListOfPolicyAssociatedToCloudClient', '00010004006000080000')
GO

