

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetLMCloudClientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetLMCloudClientList.sp,v $ $Id: GetLMCloudClientList.sp,v 1.5.42.5 2017/07/28 08:16:19 jrobert Exp $"
--
--  +========================================================================+
--  | Stored Precedure: GetLMCloudClientList()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Mrityunjay upadhyay GetLMCloudClientList to fetch clouds associated to monitoring policies.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetLMCloudClientList <<<'

IF EXISTS (select * from sysobjects where name='GetLMCloudClientList')
	drop procedure GetLMCloudClientList
IF EXISTS (select * from GxQscripts where name='GetLMCloudClientList')
	delete from GxQscripts where name = 'GetLMCloudClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMCloudClientList')
	delete from GXDBVersions where aliasname = 'GetLMCloudClientList'
GO
print '... Creating Procedure: GetLMCloudClientList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetLMCloudClientList
  @i_xml XML,
  @o_xml XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @policyId INTEGER = ISNULL(( SELECT ref.value('@monitoringPolicyId','INTEGER') AS data
FROM @i_xml.nodes('LogMonitoring_GetCloudClientInfoListReq') R(ref)),0)
DECLARE @userId INTEGER = ISNULL(( SELECT ref.value('@userId','INTEGER') AS data
FROM @i_xml.nodes('LogMonitoring_GetCloudClientInfoListReq/userEntity') R(ref)),0)
DECLARE @monitoringPolicyTbl TABLE (mpId INT)
IF @policyId <> 0
BEGIN
	INSERT INTO @monitoringPolicyTbl
	VALUES(@policyId)
END
ELSE IF @userId <> 0 -- this sp is called from alert processing sp to fetch cloudId's. so for userId= 0 , send all clouds.
BEGIN
	-- Now filter clouds for associated input apptype & userId
	DECLARE @appType INTEGER = ISNULL(( SELECT ref.value('@appType','INTEGER') AS data
	FROM @i_xml.nodes('LogMonitoring_GetCloudClientInfoListReq') R(ref)),1) -- default lm app
	DECLARE @mpXml XML
	SET @mpXml= '<LogMonitoring_GetMonitoringPoliciesListReq appType="' + CONVERT(NVARCHAR(MAX),@appType )+'" />'
	EXEC LMGetMonitoringPolicy @userId, @mpXml , @mpXml OUTPUT
	INSERT INTO @monitoringPolicyTbl
	SELECT ref.value('@monitoringPolicyid','INT')
	FROM @mpXml.nodes('LogMonitoring_GetMonitoringPoliciesListResp/monitoringPolicies') AS R(ref)
END
set @o_xml = (SELECT 0 AS "@errorcode",'' AS "@errorMessage", (
SELECT distinct
		SC.ClientId AS "@clientId",
		appClientTbl.net_hostname AS "@hostname",
		SC.Portno AS "@baseport"
	FROM DM2SearchServerCoreInfo SC Join DM2CloudCoreRole CR
		ON SC.CloudId = CR.CloudId Join Dm2cloud C ON SC.CloudId = C.cloudid
			INNER JOIN APP_Client appClientTbl WITH(NOLOCK) ON appClientTbl.id = SC.ClientId
				LEFT JOIN ( SELECT policyPropTbl.attrVal as cloudId
					FROM @monitoringPolicyTbl mpTbl
					INNER JOIN APP_MonitoringPolicyProp policyPropTbl WITH(NOLOCK) ON policyPropTbl.monitorPolicyId = mpTbl.mpId
					INNER JOIN APP_MonitoringPolicy policyTbl WITH(NOLOCK) ON policyPropTbl.monitorPolicyId = policyTbl.monitorPolicyId
					WHERE policyPropTbl.attrName = 'Cloud Id' AND policyTbl.status <> 3) as lmAssocCloud
				ON C.cloudId = lmAssocCloud.cloudId
	WHERE roleid = 3 --LM role
	--AND SC.CloudId IN ( select attrVal from APP_MonitoringPolicyProp MPP inner join APP_MonitoringPolicy MP on MPP.monitorPolicyId = MP.monitorPolicyId
	--Where MP.status<>3 AND  ( @policyId = 0 OR (@policyId > 0 AND MPP.monitorPolicyId = @policyId AND MP.status = 0 )) and MPP.attrName = 'Cloud Id')
	AND appClientTbl.status & 2 <> 2 -- these are active clients. status of 2 are deconfigured ones.
	AND (@userId = 0 OR lmAssocCloud.cloudId IS NOT NULL) -- if userId is 0 , send all clouds.
	FOR
XML PATH('cloudClientList'),
TYPE
)
FOR XML PATH('LogMonitoring_GetCloudClientInfoListResp'))
GO

IF EXISTS (select * from GxQscripts where name = 'GetLMCloudClientList')
	delete from GxQscripts where name = 'GetLMCloudClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLMCloudClientList')
	delete from GXDBVersions where aliasname = 'GetLMCloudClientList'
GO

insert into GXDBVersions values(2, 'GetLMCloudClientList',  '00010005004200050000', 'GetLMCloudClientList', '00010005004200050000')
GO

