

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetJobHistoryForSIDB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetJobHistoryForSIDB.sp,v $ $Id: GetJobHistoryForSIDB.sp,v 1.1.2.1 2018/11/14 19:43:30 snandhini Exp $";
--
--  +=============================================================================================+
--  |   Procedure:  GetJobHistoryForSIDB()
--  |
--  | Description:  SP returns job count per hour for the past maxDays days using the given sidb
--  |       Input:  1. sidbId
--  |               2. maxDays
--  |               3. minDays
--  |
--  |      Output:  1. Contains minimum of 168 data points (Sunday 12.00 AM to Saturday 11.00 PM) 7*24=168
--  |               2. Is ordered in hourly style from Sunday 12.00 AM to Saturday 11.00 PM
--  |               3. Set -1 filled for unknown data
--  |               4. If system doesnot have the minimum data mentioned, return nothing
--  |
--  |
--  |      Output:  Reason
-- 	|
--  +==============================================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetJobHistoryForSIDB')
BEGIN
	print '>>> Drop Stored Procedure: GetJobHistoryForSIDB <<<'
	drop procedure GetJobHistoryForSIDB
END
IF EXISTS (select * from GxQscripts where name='GetJobHistoryForSIDB')
	delete from GxQscripts where name = 'GetJobHistoryForSIDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetJobHistoryForSIDB')
	delete from GXDBVersions where aliasname = 'GetJobHistoryForSIDB'
GO
print '... Creating Procedure: GetJobHistoryForSIDB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetJobHistoryForSIDB
  @sidbId INT,
  @maxDays INT,
  @minDays INT
AS
  DECLARE @time INT;
  DECLARE @jobCount INT;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @currentDay DATETIME = CONVERT(DATE,GETDATE())
	DECLARE @weekDay INT         = DATEPART(WEEKDAY,@currentDay)
	DECLARE @endDay DATETIME     = DATEADD(DAY,7-@weekDay+1,@currentDay)
	DECLARE @startDay DATETIME   = DATEADD(DAY,-@maxDays,@endDay)
	SET @weekDay                 = DATEPART(WEEKDAY,@startDay)
	SET @startDay                = DATEADD(DAY,7-@weekDay+1,@startDay)
	SET @endDay                  = DATEADD(HOUR,-1,@endDay)
	DECLARE @startTime INT       = DATEDIFF(SECOND,'19700101',@startDay)
	DECLARE @endTime INT         = DATEDIFF(SECOND,'19700101',@endDay)
	DECLARE @diff INT            = DATEDIFF(SECOND,GETUTCDATE(),GETDATE())
	DECLARE @minTimeInDB INT     = (SELECT min(servstartdate) from JMBkpstats)+@diff
	DECLARE @currentTime INT     = DATEDIFF(SECOND,'19700101',GETDATE())
	IF(@currentTime-@minTimeInDB)/(60*60*24) < @minDays
	 RETURN
	IF OBJECT_ID('tempdb.dbo.#hourtable') IS NOT NULL
	 DROP TABLE #hourtable
	CREATE TABLE #hourtable
	(
	hourlytime int,
	jobCount int
	primary key(hourlytime)
	)
	;WITH cteNums(n) AS
	(
		SELECT @startTime
		UNION ALL
		SELECT n + 60*60
		FROM cteNums WHERE n < @endTime -- get till currnt time
	)
	INSERT #hourtable
	SELECT n,0 FROM cteNums
	OPTION (MAXRECURSION 0)
	UPDATE A SET jobcount = B.jobcount
	FROM #hourtable A
	INNER JOIN(
		SELECT hourlytime,COUNT(1) jobCount
		FROM #hourtable hrtbl
		INNER JOIN
		(
			SELECT ((servStartDate+@diff)/3600)*3600 startTime,((servEndDate+@diff)/3600)*3600 endTime,1 jobfound  FROM JMBkpstats BKP
			INNER JOIN archgroup SP ON BKP.dataArchGrpId = SP.id
			INNER JOIN archGroupCopy SPCopy ON Sp.defaultCopy = SPCopy.id AND SPCopy.SIDBStoreId = @sidbId
			WHERE servStartDate+@diff>@starttime
		)Jobs
		ON  hrtbl.hourlytime BETWEEN startTime AND endTime
		GROUP BY hourlytime,jobfound
	)B
	ON A.hourlytime = B.hourlytime
	UPDATE #hourtable SET jobcount=-1 WHERE hourlytime > @currentTime
	UPDATE #hourtable SET jobcount=-1 WHERE hourlytime < @minTimeInDB
	SELECT hourlytime,jobCount FROM #hourtable
	IF OBJECT_ID('tempdb.dbo.#hourtable') IS NOT NULL
	 DROP TABLE #hourtable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetJobHistoryForSIDB')
	delete from GxQscripts where name = 'GetJobHistoryForSIDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetJobHistoryForSIDB')
	delete from GXDBVersions where aliasname = 'GetJobHistoryForSIDB'
GO

insert into GXDBVersions values(2, 'GetJobHistoryForSIDB',  '00010001000200010000', 'GetJobHistoryForSIDB', '00010001000200010000')
GO

