

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetInvalidArchiveFileIDList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  GetInvalidArchiveFileIDList()
--  | Description:  Expects comma separated list of Archive File ID. Returns List of Archive File IDs which are invalid.
--  | 				In environment where MMConfig PRUNE_CI_DATA_WHEN_JOBS_AGE_ON_CI_SOURCE_COPY set to 1, data on archive files on tape also
--  | 				treated as invalid or pruned. If this is not desired beahvior, then client program can pass ForceIgnoreTapeRule input as 1
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetInvalidArchiveFileIDList.sp,v $ $Id: GetInvalidArchiveFileIDList.sp,v 1.3.198.2 2018/05/09 02:33:07 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetInvalidArchiveFileIDList <<<'

IF EXISTS (select * from sysobjects where name='GetInvalidArchiveFileIDList')
	drop procedure GetInvalidArchiveFileIDList
IF EXISTS (select * from GxQscripts where name='GetInvalidArchiveFileIDList')
	delete from GxQscripts where name = 'GetInvalidArchiveFileIDList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetInvalidArchiveFileIDList')
	delete from GXDBVersions where aliasname = 'GetInvalidArchiveFileIDList'
GO
print '... Creating Procedure: GetInvalidArchiveFileIDList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetInvalidArchiveFileIDList
  @ArchFileIDList VARCHAR(max),
  @ForceIgnoreTapeRule INT = 0
AS
	BEGIN
		DECLARE @TreatTapeCopyAsInvalid INT = 0
		CREATE TABLE #tmpArchFileIDList (Id INT, aFileStatus INT default 0)
		--
		-- capture input archive file IDs into temp table
		--
		INSERT INTO #tmpArchFileIDList (Id)
		SELECT _ID AS Id FROM dbo.SplitIDs(@ArchFileIDList)
		--
		-- set status = 1 for valid entries, status = 2 for data on tapes.
		--
		UPDATE T
		SET T.aFileStatus = 1
		FROM #tmpArchFileIDList AS T
		INNER JOIN archFile AS A WITH(NOLOCK) ON T.Id = A.id AND flags & 256 <> 256
		--
		-- If PRUNE_CI_DATA_WHEN_JOBS_AGE_ON_CI_SOURCE_COPY configuration setting is set to 1, then we will treat any data which has copy only on tape library as invalid for restores.
		-- Refer to comments in descripton section at the top of this stored procedure for details on ForceIgnoreTapeRule flag.
		--
		IF ISNULL(@ForceIgnoreTapeRule, 0) = 0 AND EXISTS (SELECT value FROM MMConfigs WITH (NOLOCK) WHERE name = 'PRUNE_CI_DATA_WHEN_JOBS_AGE_ON_CI_SOURCE_COPY' AND value = 1)
		BEGIN
			SET @TreatTapeCopyAsInvalid = 1
			UPDATE T
			SET T.aFileStatus = 2
			FROM #tmpArchFileIDList AS T
WHERE EXISTS (SELECT TOP 1 ac.archCopyId FROM ArchFileCopy AS AC WITH(NOLOCK) WHERE AC.MediaType >= 1 AND AC.MediaType <= 9000 AND AC.ArchFileId = T.Id)
AND NOT EXISTS (SELECT TOP 1 ac.archCopyId FROM ArchFileCopy AS AC WITH(NOLOCK) WHERE AC.MediaType > 9000 AND AC.ArchFileId = T.Id)
		END
		--
		-- Return final output which contains invalid archive files as per input request and DB status as of now
		--
		SELECT Id AS InvalidArchFileId FROM #tmpArchFileIDList WHERE aFileStatus <> 1
		--
		-- Drop temp table created locally.
		--
		IF OBJECT_ID('tempdb.dbo.#tmpArchFileIDList') IS NOT NULL DROP TABLE #tmpArchFileIDList
	END
GO

IF EXISTS (select * from GxQscripts where name = 'GetInvalidArchiveFileIDList')
	delete from GxQscripts where name = 'GetInvalidArchiveFileIDList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetInvalidArchiveFileIDList')
	delete from GXDBVersions where aliasname = 'GetInvalidArchiveFileIDList'
GO

insert into GXDBVersions values(2, 'GetInvalidArchiveFileIDList',  '00010003019800020000', 'GetInvalidArchiveFileIDList', '00010003019800020000')
GO

