

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetInstanceExtendedProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetInstanceExtendedProperties <<<'

IF EXISTS (select * from sysobjects where name='GetInstanceExtendedProperties')
	drop procedure GetInstanceExtendedProperties
IF EXISTS (select * from GxQscripts where name='GetInstanceExtendedProperties')
	delete from GxQscripts where name = 'GetInstanceExtendedProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetInstanceExtendedProperties')
	delete from GXDBVersions where aliasname = 'GetInstanceExtendedProperties'
GO
print '... Creating Procedure: GetInstanceExtendedProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetInstanceExtendedProperties
  @i_entity XML ,
  @o_header XML OUTPUT ,
  @o_data XML OUTPUT
AS
-- GEnerates in header file
  DECLARE @header XML
  DECLARE @data XML
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @clientId INT
	DECLARE @appTypeId INT
	DECLARE @localeId INT
	SELECT
		@clientId = ISNULL(ref.value('@clientId', 'INT') , 0),
		@appTypeId = ISNULL(ref.value('@applicationId', 'INT'), 0),
		@localeId = ISNULL(ref.value('../@localeId', 'INT'), 0)
	FROM @i_entity.nodes ('App_ExtendedSummaryReq/entity') R(ref)
	DECLARE @entityHeaderTable TABLE (
		value	NVARCHAR(256),
		type	NVARCHAR(32),
		name	NVARCHAR(256)
	)
	INSERT @entityHeaderTable VALUES
		 ('//Instance/@name', 'string', 'Name')
		,('//Instance/@entityPropId', 'int', 'Id')
	SET @o_header = (
			SELECT [value] AS '@value',
				[type] AS '@type',
				[name] AS '@name'
			FROM @entityHeaderTable
			FOR XML PATH('query'),
				ROOT('header')
			)
	DECLARE @entityValueTable TABLE  (
		name			NVARCHAR(255),
		entityPropId	INT PRIMARY KEY
	)
	INSERT INTO @entityValueTable (
		entityPropId,
		name
	)
	SELECT
		id,
		name
	FROM APP_InstanceName
	WHERE id IN (
			SELECT instance
			FROM APP_Application
			WHERE clientId = @clientId
				AND appTypeId = @appTypeId
			)
	SET @o_data = (
			SELECT name AS '@name',
				entityPropId AS '@entityPropId'
			FROM  @entityValueTable
			FOR XML PATH('Instance'),
				ROOT('data')
			)
	SELECT @o_header header, @o_data data
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetInstanceExtendedProperties')
	delete from GxQscripts where name = 'GetInstanceExtendedProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetInstanceExtendedProperties')
	delete from GXDBVersions where aliasname = 'GetInstanceExtendedProperties'
GO

insert into GXDBVersions values(2, 'GetInstanceExtendedProperties',  '00000000000000000000', 'GetInstanceExtendedProperties', '00000000000000000000')
GO

