

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetIndexServerPruneTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   04/24/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetIndexServerPruneTime.sp,v $ $Id: GetIndexServerPruneTime.sp,v 1.1.2.10 2020/12/29 18:27:55 sbhukar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetIndexServerPruneTime')
BEGIN
	print '>>> Drop Stored Procedure: GetIndexServerPruneTime <<<'
	drop procedure GetIndexServerPruneTime
END
IF EXISTS (select * from GxQscripts where name='GetIndexServerPruneTime')
	delete from GxQscripts where name = 'GetIndexServerPruneTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetIndexServerPruneTime')
	delete from GXDBVersions where aliasname = 'GetIndexServerPruneTime'
GO
print '... Creating Procedure: GetIndexServerPruneTime'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetIndexServerPruneTime
  @i_xml XML
AS
  DECLARE @outXML xml
DECLARE @pseudoIdxServerId INT = 0
DECLARE @pseudoIdxServerAppId INT = 0
DECLARE @pruningEnabled INT = 0
DECLARE @dataArchGrpID INT = 0
DECLARE @currentTime INT = dbo.GetUnixTime(GETDATE())
SELECT @pseudoIdxServerId = ISNULL(N.value(N'@pseudoIndexServerId', N'INT'),0),
	@pseudoIdxServerAppId = ISNULL(N.value(N'@pseudoIndexServerAppId', N'INT'),0)
	FROM @i_xml.nodes (N'Indexing_IdxPruningDetailsReq') AS T(N);
IF @pseudoIdxServerId = 0
	SELECT @pseudoIdxServerId = clientId FROM APP_Application WITH (NOLOCK) WHERE id = @pseudoIdxServerAppId
IF object_id('tempdb.dbo.#excludedBkpSet') is not null
	DROP TABLE #excludedBkpSet
CREATE TABLE #excludedBkpSet (bkpSetId INT, bkpSetGuid VARCHAR(40), retDay INT, retCycle INT)
IF object_id('tempdb.dbo.#indexServerRetention') is not null
	DROP TABLE #indexServerRetention
CREATE TABLE #indexServerRetention ( retDay INT, retCycle INT)
IF object_id('tempdb.dbo.#idxDbList') is not null
	DROP TABLE #idxDbList
CREATE TABLE #idxDbList (bkpSetId INT, t_dbId INT, dbName VARCHAR(40), t_appid INT)
CREATE CLUSTERED INDEX bkpstList_bkpSetId_Idx ON #idxDbList (bkpSetId)
IF object_id('tempdb.dbo.#subclientIndex') is not null
	DROP TABLE #subclientIndex
CREATE TABLE #subclientIndex ( subclientGuid VARCHAR(40), checkPointTime BIGINT, retDay INT, retCycle INT, appId INT)
--Check if feature is enabled or not
SELECT @pruningEnabled = CAST(ISNULL(value,0) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Enable Index Pruning' AND modified = 0 --ENABLE_INDEX_PRUNING
IF @pruningEnabled = 0
	GOTO EXIT_POINT
SELECT @dataArchGrpID = CAST(attrVal as INT) FROM app_clientprop WITH (NOLOCK) WHERE componentnameid = @pseudoIdxServerId AND attrName = 'Index Server ArchGroup Id' and Modified  = 0
IF @dataArchGrpID = 0
	GOTO EXIT_POINT
-- M.A has to be at service pack 15 for pruning feature to work
INSERT INTO #idxDbList
SELECT DISTINCT app.backupSet, dbInfo.id, app.GUID, app.id FROM APP_Application app WITH (NOLOCK)
JOIN App_IndexDBInfo dbInfo WITH (NOLOCK) ON  app.backupSet = dbInfo.backupSetId
JOIN simInstalledPackages SIM WITH (NOLOCK) ON SIM.clientId = dbInfo.currentIdxServer
LEFT JOIN app_clientprop CP WITH (NOLOCK) ON CP.ComponentNameId = app.clientId AND CP.attrName = 'Index Server ArchGroup Id' AND CP.Modified  = 0
WHERE dataArchGrpID = @dataArchGrpID AND SIM.HighestSP > 14 AND simPackageID IN (51,1301)
AND CP.ComponentNameId IS NULL
IF NOT EXISTS(SELECT 1 FROM #idxDbList)
	GOTO EXIT_POINT
--Include the backupset in exclusion list where configuration is specified at backupset level
INSERT INTO #excludedBkpSet
SELECT DISTINCT bkplist.bkpSetId, bkpst.GUID, CAST(bp1.attrVal AS INT), CAST(bp2.attrVal AS INT)
FROM #idxDbList bkplist WITH (NOLOCK) JOIN APP_BackupSetName bkpst WITH (NOLOCK) ON bkpst.id = bkplist.bkpSetId
JOIN APP_BackupSetProp bp WITH (NOLOCK) ON bp.componentNameId = bkplist.bkpSetId AND bp.attrName = 'Enable Index Pruning' AND bp.modified = 0 -- CV_BACKUPSET_INDEX_PRUNING
JOIN APP_BackupSetProp bp1 WITH (NOLOCK) ON bp1.componentNameId = bkplist.bkpSetId AND bp1.attrName = 'IndexPruning_DBRetentionDays' AND bp1.modified = 0 --INDEX_PRUNING_DB_RETENTION_DAYS
JOIN APP_BackupSetProp bp2 WITH (NOLOCK) ON bp2.componentNameId = bkplist.bkpSetId AND bp2.attrName = 'IndexPruning_DBRetentionCycle' AND bp2.modified = 0 --INDEX_PRUNING_DB_RETENTION_CYCLE
WHERE CAST(bp.attrVal AS INT) > 0
--Handle any configuration set at commcell level
INSERT INTO #indexServerRetention
SELECT CAST(ISNULL([IndexPruning_DBRetentionDays],0) AS INT), CAST(ISNULL([IndexPruning_DBRetentionCycle],0) AS INT) FROM
(
	SELECT name, value FROM GXGlobalParam WITH (NOLOCK) WHERE name in ('IndexPruning_DBRetentionDays','IndexPruning_DBRetentionCycle') --INDEX_PRUNING_DB_RETENTION_DAYS
) P
PIVOT (MAX(value) FOR name in ([IndexPruning_DBRetentionDays],[IndexPruning_DBRetentionCycle])) T --INDEX_PRUNING_DB_RETENTION_CYCLE
--Minimum 2 cycles need to be retained
UPDATE #indexServerRetention SET retCycle = 2
WHERE retCycle IN (0,1)
IF EXISTS(SELECT 1 FROM #indexServerRetention WHERE retCycle = -1 OR retDay = -1)
	UPDATE #indexServerRetention SET retCycle = -1, retDay = -1
UPDATE #excludedBkpSet SET retCycle = 2
WHERE retCycle IN (0,1)
UPDATE #excludedBkpSet SET retCycle = -1, retDay = -1
WHERE bkpSetId IN (SELECT bkpSetId FROM #excludedBkpSet WHERE retCycle = -1 OR retDay = -1)
--Check if it is a subclient level index,
--By default insert checkpoint time as epoch time to cover the case when subclient level index is enabled but still no checkpoint info is present in App_IndexCheckpointInfo
INSERT INTO #subclientIndex
SELECT DISTINCT bkplist.dbName, 0, CAST(SP1.attrVal AS INT), CAST(SP2.attrVal AS INT), bkplist.t_appid
FROM #idxDbList bkplist WITH (NOLOCK)
JOIN App_SubClientProp SP WITH (NOLOCK) ON SP.componentNameId = bkplist.t_appid AND SP.attrName = 'Enable Index Pruning' AND SP.modified = 0 -- CV_SUBCLIENT_INDEX_PRUNING
JOIN App_SubClientProp SP1 WITH (NOLOCK) ON SP1.componentNameId = bkplist.t_appid AND SP1.attrName = 'IndexPruning_DBRetentionDays' AND SP1.modified = 0 --INDEX_PRUNING_DB_RETENTION_DAYS
JOIN App_SubClientProp SP2 WITH (NOLOCK) ON SP2.componentNameId = bkplist.t_appid AND SP2.attrName = 'IndexPruning_DBRetentionCycle' AND SP2.modified = 0 --INDEX_PRUNING_DB_RETENTION_CYCLE
WHERE dbo.isSubClientIndexEnabled(bkplist.bkpSetId)  = 1 AND CAST(SP.attrVal AS INT) > 0
UPDATE #subclientIndex SET checkPointTime = ISNULL(endTime,0)
FROM
(SELECT MAX(chk.endTime) as endTime, chk.dbName as dbGUID FROM App_IndexCheckpointInfo chk WITH(NOLOCK) JOIN #subclientIndex tmp ON tmp.subclientGuid = chk.dbName
JOIN Archfile AF WITH(NOLOCK) ON AF.Id = chk.afileId
WHERE chk.flags&1 = 1 AND AF.isValid = 1 GROUP BY chk.dbName) T WHERE T.dbGUID = subclientGuid
--Make sure pruning is not done until reference copy catches up
UPDATE #subclientIndex SET checkPointTime = T.referenceTime
FROM
(SELECT refCopy.srcAppId, MIN(refCopy.referenceTime) as referenceTime FROM JMReferenceCopy refCopy WITH(NOLOCK) JOIN #subclientIndex tmp ON tmp.appId = refCopy.srcAppId
WHERE refCopy.referenceTime < tmp.checkPointTime GROUP BY refCopy.srcAppId) T WHERE T.srcAppId = appId
UPDATE #subclientIndex SET retCycle = 2
WHERE retCycle = 0
UPDATE T SET T.retCycle = -1, T.retDay = -1
FROM #subclientIndex T
JOIN #subclientIndex S ON T.subclientGuid = S.subclientGuid
WHERE S.retCycle = -1 OR S.retDay = -1
EXIT_POINT:
SET @outXML =
(
	SELECT MAX(retDay) AS '@retentionDays', MAX(retCycle) AS '@retentionCycle',
	(
		SELECT bkpSetGuid AS '@bkpSetGUID', MAX(retDay) AS '@retentionDays', MAX(retCycle) AS '@retentionCycle'
		FROM #excludedBkpSet GROUP BY bkpSetGuid
		FOR XML PATH('excludedBkpSetDetails'),TYPE
	) ,
	(
		SELECT subclientGuid AS '@dbName',checkPointTime AS '@lastCheckPointTime', retDay AS '@retentionDays', retCycle AS '@retentionCycle'
		FROM #subclientIndex
		FOR XML PATH('dbCheckPointDetails'),TYPE
	)
	FROM #indexServerRetention
	FOR XML PATH('Indexing_IdxPruningDetailsResp')
)
SELECT @outXML
IF object_id('tempdb.dbo.#indexServerRetention') is not null
	DROP TABLE #indexServerRetention
IF object_id('tempdb.dbo.#excludedBkpSet') is not null
	DROP TABLE #excludedBkpSet
IF object_id('tempdb.dbo.#idxDbList') is not null
	DROP TABLE #idxDbList
IF object_id('tempdb.dbo.#subclientIndex') is not null
	DROP TABLE #subclientIndex
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetIndexServerPruneTime')
	delete from GxQscripts where name = 'GetIndexServerPruneTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetIndexServerPruneTime')
	delete from GXDBVersions where aliasname = 'GetIndexServerPruneTime'
GO

insert into GXDBVersions values(2, 'GetIndexServerPruneTime',  '00010001000200100000', 'GetIndexServerPruneTime', '00010001000200100000')
GO

