

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetIndexCacheSubclientDetails.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetIndexCacheSubclientDetails.sp,v $ $Id: GetIndexCacheSubclientDetails.sp,v 1.1 2013/10/31 10:52:40 sbhavanarushi Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   GetIndexCacheSubclientDetails   - Add content in the GetIndexCacheSubclientDetails
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetIndexCacheSubclientDetails <<<'

IF EXISTS (select * from sysobjects where name='GetIndexCacheSubclientDetails')
	drop procedure GetIndexCacheSubclientDetails
IF EXISTS (select * from GxQscripts where name='GetIndexCacheSubclientDetails')
	delete from GxQscripts where name = 'GetIndexCacheSubclientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetIndexCacheSubclientDetails')
	delete from GXDBVersions where aliasname = 'GetIndexCacheSubclientDetails'
GO
print '... Creating Procedure: GetIndexCacheSubclientDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetIndexCacheSubclientDetails
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXML xml
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  DECLARE @outXML xml
declare @AppIdTable table ( appId int)
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
BEGIN
 INSERT INTO  @AppIdTable(appId)
  SELECT APPIDS.ATTRIBUTES.value('@val','int') AS appId
  FROM @inXML.nodes('Indexing_AppIdDetailsReq/appId') AS APPIDS(ATTRIBUTES)
  SET @outXML = ISNULL ((SELECT commCells.aliasName as commcellName, commCells.id as commcellId, clients.name AS clientName, clients.id AS clientId,
						iDAs.name AS appName, iDAs.type AS applicationId,
						backupsets.name AS backupsetName, backupsets.id AS backupsetId,
						subclients.subclientName AS subclientName,subclients.id AS subclientId
						FROM App_Application subclients
						JOIN App_Client clients ON subclients.clientId = clients.id
						JOIN APP_CommCell commCells on clients.origCCId = commCells.id
						JOIN APP_Platform ON clients.id = APP_Platform.clientId
						JOIN APP_IDAType iDAs ON iDAs.type = subclients.appTypeId
						JOIN App_BackupSetName backupsets ON backupsets.id = subclients.backupSet
						JOIN @AppIdTable AIT ON AIT.appId = subclients.id where app_platform.platformType = '2'
						ORDER BY commcellId,clientId,applicationId,backupsetId,subclientId
						FOR XML auto, ROOT('Indexing_ICResponse')),'<Indexing_ICResponse/>')
END
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT @outXML
SET NOCOUNT ON
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'GetIndexCacheSubclientDetails')
	delete from GxQscripts where name = 'GetIndexCacheSubclientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetIndexCacheSubclientDetails')
	delete from GXDBVersions where aliasname = 'GetIndexCacheSubclientDetails'
GO

insert into GXDBVersions values(2, 'GetIndexCacheSubclientDetails',  '00010001000000000000', 'GetIndexCacheSubclientDetails', '00010001000000000000')
GO

