

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetIDAObjectsGraph_Wrapper.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "GetIDAObjectsGraph_Wrapper.sp"
--	|	Description:
--	|	This sp is used to invoke a CLR function defined in C#, which would make a REST call to graph DB.
--	|	The graph DB would compute the permissions for the intended user which was previously taken care in sec_getIdaObjectsForUser.
--	|	The returned results would be in form of xml, where it may have nodes containing the ida objects or a flag indicating user has permissions on all entities of given type
--	|	Author: suraj shankar
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetIDAObjectsGraph_Wrapper')
BEGIN
	print '>>> Drop Stored Procedure: GetIDAObjectsGraph_Wrapper <<<'
	drop procedure GetIDAObjectsGraph_Wrapper
END
IF EXISTS (select * from GxQscripts where name='GetIDAObjectsGraph_Wrapper')
	delete from GxQscripts where name = 'GetIDAObjectsGraph_Wrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetIDAObjectsGraph_Wrapper')
	delete from GXDBVersions where aliasname = 'GetIDAObjectsGraph_Wrapper'
GO
print '... Creating Procedure: GetIDAObjectsGraph_Wrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetIDAObjectsGraph_Wrapper
  @userId int,
  @permissionId INT,
  @entityTypeReq int,
  @inheritFromChildren int,
  @isAndOperation int,
  @includeNotMappedPermissions int,
  @permissionList NVARCHAR(MAX)='',
  @tableOutput NVARCHAR(MAX) 
AS
SET NOCOUNT ON
DECLARE @returnVal NVARCHAR(MAX), @x XML,@isAllAssoc INT = 0
DECLARE @permissions VARCHAR(MAX)
BEGIN
		IF @userId = 0
				RETURN
		IF(@permissionId<>0 AND @permissionList<>'')
			BEGIN
			--Invalid Usage
			RETURN
		END
		DECLARE @inputPermissionTbl  TABLE(iPermissionId INTEGER)
		IF(@permissionList<>'')
			BEGIN
				INSERT INTO @inputPermissionTbl
				SELECT DISTINCT _ID
				FROM dbo.SplitIDs(@permissionList)
			END
		ELSE
			begin
				INSERT INTO @inputPermissionTbl
				SELECT @permissionId
			END
		DELETE FROM @inputPermissionTbl
WHERE iPermissionId in (SELECT id from UMPermissions where flags& 0x001 <> 0)
		SELECT @permissions = COALESCE(@permissions + ',', '') + CAST(iPermissionId AS VARCHAR)
		FROM   @inputPermissionTbl
END
EXEC getIdaObjectsForUser_GraphAPI @userId,@entityTypeReq,@permissions,@inheritFromChildren,@isAndOperation,@includeNotMappedPermissions,@returnVal OUTPUT
SET @x = (SELECT CAST(REPLACE(@returnVal,'UTF-8','UTF-16') AS XML))
set @isallassoc = (select t.c.value('(@onAll)[1]','int') as allassoc from @x.nodes('/apis_IDAObjectsResult') t(c))
IF @isallassoc = 1
	BEGIN
		declare @outputstatement nvarchar(max) = 'insert into ' +@tableOutput
IF @entityTypeReq = 3
			SET @outputstatement += ' select id, 0, 0, 0, 0 from app_client where id <> 1'
ELSE IF @entityTypeReq = 4
			SET @outputstatement += ' select clientId, apptypeId, 0, 0, 0 from app_idaname'
ELSE IF @entityTypeReq = 5
            SET @outputstatement += ' SELECT DISTINCT clientId, appTypeId, instance, 0, 0 FROM APP_Application'
ELSE IF @entityTypeReq = 6
            SET @outputstatement += ' SELECT DISTINCT clientId, appTypeId, instance, backupset, 0 FROM APP_Application'
		ELSE
			SET @outputstatement += ' select distinct clientid, apptypeid, instance, backupset, id from app_application'
		EXEC (@outputStatement)
	END
ELSE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#graphTempOutput') is not null
			drop table #graphTempOutput
		create table #graphTempOutput (id1 int,id2 int,id3 int,id4 int,id5 int)
		insert into #graphTempOutput select t.c.value('(@id1)[1]','int') as id1,ISNULL(t.c.value('(@id2)[1]','int'),0) as id2,ISNULL(t.c.value('(@id3)[1]','int'),0) as id3,ISNULL(t.c.value('(@id4)[1]','int'),0) as id4,ISNULL(t.c.value('(@id5)[1]','int'),0) as id5 from  @x.nodes('/apis_IDAObjectsResult/idaObjects') t(c)
		declare @stmt nvarchar(max) = 'insert into ' +@tableOutput + ' select * from #graphTempOutput'
		exec (@stmt)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'GetIDAObjectsGraph_Wrapper')
	delete from GxQscripts where name = 'GetIDAObjectsGraph_Wrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetIDAObjectsGraph_Wrapper')
	delete from GXDBVersions where aliasname = 'GetIDAObjectsGraph_Wrapper'
GO

insert into GXDBVersions values(2, 'GetIDAObjectsGraph_Wrapper',  '00000000000000000000', 'GetIDAObjectsGraph_Wrapper', '00000000000000000000')
GO

