

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetHedvigDatastoreInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetHedvigDatastoreInfo.sp,v $ $Id: GetHedvigDatastoreInfo.sp,v 1.1.2.3 2020/09/30 21:58:04 rsn Exp $";
--  +---------------------------------------------------+
--  |           PROCEDURE : "GetHedvigDatastoreInfo"         |
--  +---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetHedvigDatastoreInfo')
BEGIN
	print '>>> Drop Stored Procedure: GetHedvigDatastoreInfo <<<'
	drop procedure GetHedvigDatastoreInfo
END
IF EXISTS (select * from GxQscripts where name='GetHedvigDatastoreInfo')
	delete from GxQscripts where name = 'GetHedvigDatastoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetHedvigDatastoreInfo')
	delete from GXDBVersions where aliasname = 'GetHedvigDatastoreInfo'
GO
print '... Creating Procedure: GetHedvigDatastoreInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetHedvigDatastoreInfo
  @i_xmlString XML
AS
  DECLARE @o_xmlstring XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRAN
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	IF object_id('tempdb.dbo.#hedvigdatastoreInfotTable') IS NOT null DROP TABLE #hedvigdatastoreInfotTable
CREATE TABLE #hedvigdatastoreInfotTable	(
	Id                      INT ,
	DataStoreName           NVARCHAR(255),
	VMHost                  NVARCHAR(255),
	DataStoreMountPath      NVARCHAR(512),
	HypervisorName          NVARCHAR(255),
	HypervisorId            INT,
	HedVigProxy             NVARCHAR(255),
	VDiskName               NVARCHAR(255),
	HedvigCluster           NVARCHAR(255),
	CreateDate				INT,
	CreatorId               INT,
	status                  INT,
	VDiskType				NVARCHAR(255),
	VDiskSize				INT,
	DistributeStorageId		INT,
	DistributeStorageName	NVARCHAR(255))
	-- READ THE XML
	DECLARE @VMHost		NVARCHAR(255) =  ISNULL(( SELECT ref.value('@targetHost', 'NVARCHAR(255)')
													FROM @i_xmlString.nodes ('Ida_GetHedvigDataStoreReq/HedvigRequest') R(ref)), '')
	DECLARE @HypervisorName		NVARCHAR(255) =  ISNULL(( SELECT ref.value('@clientName', 'NVARCHAR(255)')
													FROM @i_xmlString.nodes ('Ida_GetHedvigDataStoreReq/HedvigRequest/hypervisorDetails') R(ref)), '')
	DECLARE @HypervisorId		INT =  ISNULL(( SELECT ref.value('@clientId', 'INT')
													FROM @i_xmlString.nodes ('Ida_GetHedvigDataStoreReq/HedvigRequest/hypervisorDetails') R(ref)), 0)
	DECLARE @propertyLevel		INT =  ISNULL(( SELECT ref.value('@propertyLevel', 'INT')
													FROM @i_xmlString.nodes ('Ida_GetHedvigDataStoreReq') R(ref)), 0)
	DECLARE @distributeStorageId INT =  ISNULL(( SELECT ref.value('@distributedStorageId', 'INT')
													FROM @i_xmlString.nodes ('Ida_GetHedvigDataStoreReq/HedvigRequest/distributedStorage') R(ref)), 0)
		DECLARE @userId INT				=    ISNULL(( SELECT ref.value('@userId', 'INT')
													FROM @i_xmlString.nodes ('Ida_GetHedvigDataStoreReq/processinginstructioninfo/user') R(ref)), 0)
	DECLARE @isAdmin INT = 0
EXEC DBO.sec_checkPermissionOnEntity @userId, 1, @isAdmin OUTPUT, 1, 2
	IF @isAdmin <> 1
		BEGIN
			------ SECURITY CHECK ------
			--Contains objects tables to be used by SP.
		    IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		        DROP TABLE #getObjectsTable
		    CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
		    IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		        DROP TABLE #permissionIdTable
		    CREATE TABLE #permissionIdTable (permissionId INT)
		    IF OBJECT_ID('tempdb.dbo.#clientLstWithAgentMgmtCap') IS NOT NULL
				DROP TABLE #clientLstWithAgentMgmtCap
			CREATE TABLE #clientLstWithAgentMgmtCap
			(
				clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
			)
		    ------ MAP GetDistributedStoragePermissionType TO PERMISSION
	        INSERT INTO  #permissionIdTable
	        (permissionId)
VALUES (260), (261)
EXEC sec_getObjectsWithPermissionsV2 @userId, 195, 0
		    IF @distributeStorageId <> 0 AND NOT EXISTS (SELECT 1 FROM #getObjectsTable WHERE entityId = @distributeStorageId)
		    BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		        GOTO ERROR
		    END
			--Verify hypervisor security
EXEC sec_getIdaObjectsForUser @userId, 3 , 2, 0, '#clientLstWithAgentMgmtCap'
			--Get based on user
			INSERT INTO #hedvigdatastoreInfotTable (Id,DataStoreName, VMHost, DataStoreMountPath, HypervisorName , HypervisorId, HedVigProxy, VDiskName, HedvigCluster, CreateDate, CreatorId, status,
													 DistributeStorageId, DistributeStorageName)
			SELECT DISTINCT HV.Id,HV.DataStoreName,HV.VMHost, HV.DataStoreMountPath, HV.HypervisorName, HV.HypervisorId, HV.HedVigProxy, HV.DataStoreName,HV.HedvigCluster,
			HV.CreateDate, HV.CreatorId, HV.status,  HVP.attrVal as distributeStorageID, DS.name as distributeStorageName FROM HedVigDatastores HV  WITH (NOLOCK) INNER JOIN
			HedVigDatastoreProp HVP  WITH (NOLOCK) ON HV.id = HVP.componentNameId AND HVP.attrName = 'Distributed Storage ID'
			INNER JOIN App_DistributedStorage DS  WITH (NOLOCK) ON (@distributeStorageId <> 0 AND HVP.attrVal = @distributeStorageId) OR (@distributeStorageId = 0 AND HVP.attrVal = DS.id)
			INNER JOIN #clientLstWithAgentMgmtCap ON clientId = HV.HypervisorId
			INNER JOIN #getObjectsTable ON entityId = DS.id
			WHERE HVP.attrName = 'Distributed Storage ID' AND
				 HV.VMHost = COALESCE(NULLIF(@VMHost, ''),  HV.VMHost)  AND
				 HV.HypervisorId = COALESCE(NULLIF(@HypervisorId, ''),  HV.HypervisorId) AND
				 HV.HypervisorName = COALESCE(NULLIF(@HypervisorName, ''),  HV.HypervisorName)
		END
	ELSE
		BEGIN
			INSERT INTO #hedvigdatastoreInfotTable (Id,DataStoreName, VMHost, DataStoreMountPath, HypervisorName , HypervisorId, HedVigProxy, VDiskName, HedvigCluster, CreateDate, CreatorId, status,
												 DistributeStorageId, DistributeStorageName)
			SELECT HV.Id,HV.DataStoreName,HV.VMHost, HV.DataStoreMountPath, HV.HypervisorName, HV.HypervisorId, HV.HedVigProxy, HV.DataStoreName,HV.HedvigCluster,
			HV.CreateDate, HV.CreatorId, HV.status,  HVP.attrVal as distributeStorageID, DS.name as distributeStorageName FROM HedVigDatastores HV  WITH (NOLOCK) INNER JOIN
			HedVigDatastoreProp HVP  WITH (NOLOCK) ON HV.id = HVP.componentNameId AND HVP.attrName = 'Distributed Storage ID'
			INNER JOIN App_DistributedStorage DS  WITH (NOLOCK) ON (@distributeStorageId <> 0 AND HVP.attrVal = @distributeStorageId) OR (@distributeStorageId = 0 AND HVP.attrVal = DS.id)
			WHERE HVP.attrName = 'Distributed Storage ID' AND
				 HV.VMHost = COALESCE(NULLIF(@VMHost, ''),  HV.VMHost)  AND
				 HV.HypervisorId = COALESCE(NULLIF(@HypervisorId, ''),  HV.HypervisorId) AND
				 HV.HypervisorName = COALESCE(NULLIF(@HypervisorName, ''),  HV.HypervisorName)
		END
	IF @propertyLevel = 10
		BEGIN
			UPDATE #hedvigdatastoreInfotTable
			SET #hedvigdatastoreInfotTable.VDiskSize = HVP.attrVal
			FROM #hedvigdatastoreInfotTable HVT
			INNER JOIN HedVigDatastoreProp HVP ON HVT.Id = HVP.componentNameId
			WHERE HVP.attrName = 'VDiskSize'
			UPDATE #hedvigdatastoreInfotTable
			SET #hedvigdatastoreInfotTable.VDiskType = HVP.attrVal
			FROM #hedvigdatastoreInfotTable HVT
			INNER JOIN HedVigDatastoreProp HVP ON HVT.Id = HVP.componentNameId
			WHERE HVP.attrName = 'VDiskType'
		END
ERROR:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
SET @o_xmlstring =
ISNULL((SELECT		id as 'dataStoreId',
			VDiskName AS 'vdiskName',
			VDiskSize as 'vdiskSize',
			HedvigCluster as 'HedvigClusterNode',
			VMHost as 'targetHost',
			DistributeStorageId as 'distributedStorage/distributedStorageId',
			DistributeStorageName as 'distributedStorage/distributedStorageName',
			ISNULL(VDiskType, '') as 'vdiskType',
			(SELECT HedVigProxy as HedvigTargets FOR XML PATH (''),TYPE) ,
			HypervisorId as 'Hypervisordetails/clientId',
			HypervisorName as 'Hypervisordetails/clientName',
			ISNULL(DataStoreMountPath, '') as datastoreMountPath,
			status as mountStatus
FROM #hedvigdatastoreInfotTable HVT FOR XML PATH('HedvigDatastore'), ROOT('Ida_GetHedvigDataStoreResp')),
'<Ida_GetHedvigDataStoreResp/>')
SELECT @o_xmlstring
END
SET TRANSACTION ISOLATION LEVEL READ COMMITTED
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetHedvigDatastoreInfo')
	delete from GxQscripts where name = 'GetHedvigDatastoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetHedvigDatastoreInfo')
	delete from GXDBVersions where aliasname = 'GetHedvigDatastoreInfo'
GO

insert into GXDBVersions values(2, 'GetHedvigDatastoreInfo',  '00010001000200030000', 'GetHedvigDatastoreInfo', '00010001000200030000')
GO

