

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetHealthCheckStatusFull.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetHealthCheckStatusFull.sp,v $ $Id: GetHealthCheckStatusFull.sp,v 1.1.2.1 2020/10/20 03:53:30 tdontham Exp $";
--
--  +===============================================================================================+
--  |   Cursor:  GetHealthCheckStatusFull
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------------------------------------
--  |   1.0       Tejasri  Gets the CS installed version information in format Release.SPMajor.HPK
--  +================================================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetHealthCheckStatusFull')
BEGIN
	print '>>> Drop Stored Procedure: GetHealthCheckStatusFull <<<'
	drop procedure GetHealthCheckStatusFull
END
IF EXISTS (select * from GxQscripts where name='GetHealthCheckStatusFull')
	delete from GxQscripts where name = 'GetHealthCheckStatusFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetHealthCheckStatusFull')
	delete from GXDBVersions where aliasname = 'GetHealthCheckStatusFull'
GO
print '... Creating Procedure: GetHealthCheckStatusFull'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetHealthCheckStatusFull
-----------------------------------------------------------
---    PARAMETERS				                        ---
  @inXmlReq XML
-----------------------------------------------------------
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_xmlText XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clientid int = 2
Declare @csversion Varchar(1024)
Declare @version Varchar(1024)
Declare @spMajor Varchar(1024)
Declare @upNumber Varchar(1024)
select @version = (psp2.release - 5), @spMajor = psp2.SPMajor
	FROM simInstalledPackages sip WITH(NOLOCK)
	JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.SPVersionID = psp.id
	JOIN PatchSPVersion psp2 WITH(NOLOCK) ON psp.release = psp2.Release AND psp.build = psp2.build AND psp.SPmajor = psp2.SPMajor and psp.SPMinor = psp2.SPMinor AND psp.TransactionID = psp2.TransactionID
	WHERE sip.clientid = @clientid
select @upNumber=pup.UPNumber
	FROM simInstalledPackages sip WITH(NOLOCK) JOIN PatchUPVersion pup WITH(NOLOCK) ON sip.UPNumber = pup.UPNumber
	JOIN PatchSPVersion psp1 WITH(NOLOCK) ON psp1.id = sip.spVersionId JOIN PatchSPVersion psp2 WITH(NOLOCK) ON psp2.id = pup.spVersionId
	WHERE clientid = @clientid AND psp1.release = psp2.release AND psp1.build = psp2.build AND psp1.SPMajor = psp2.SPMajor AND psp1.SPMinor = psp2.SPMinor AND psp1.TransactionId = psp2.TransactionId
	ORDER BY pup.UPNumber DESC, pup.MaxTransactionID DESC
set @csversion = @version+'.'+@spMajor+'.'+ CAST(COALESCE(@upNumber,0) as varchar(10))
DECLARE  @opXmlReq xml = (SELECT @csversion as CSVersion  for xml raw('App_HealthResponse'),elements)
SELECT  @opXmlReq
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'GetHealthCheckStatusFull')
	delete from GxQscripts where name = 'GetHealthCheckStatusFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetHealthCheckStatusFull')
	delete from GXDBVersions where aliasname = 'GetHealthCheckStatusFull'
GO

insert into GXDBVersions values(2, 'GetHealthCheckStatusFull',  '00010001000200010000', 'GetHealthCheckStatusFull', '00010001000200010000')
GO

