

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetHealthCheckStatusBasic.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetHealthCheckStatusBasic.sp,v $ $Id: GetHealthCheckStatusBasic.sp,v 1.1.2.1 2020/10/20 03:53:36 tdontham Exp $";
--
--  +===============================================================================================+
--  |   Cursor:  GetHealthCheckStatusBasic
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------------------------------------
--  |   1.0       Tejasri  Gets the CS installed release version number
--  +================================================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetHealthCheckStatusBasic')
BEGIN
	print '>>> Drop Stored Procedure: GetHealthCheckStatusBasic <<<'
	drop procedure GetHealthCheckStatusBasic
END
IF EXISTS (select * from GxQscripts where name='GetHealthCheckStatusBasic')
	delete from GxQscripts where name = 'GetHealthCheckStatusBasic'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetHealthCheckStatusBasic')
	delete from GXDBVersions where aliasname = 'GetHealthCheckStatusBasic'
GO
print '... Creating Procedure: GetHealthCheckStatusBasic'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetHealthCheckStatusBasic
-----------------------------------------------------------
---    PARAMETERS				                        ---
  @inXmlReq XML
-----------------------------------------------------------
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_xmlText XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clientid int = 2
Declare @version Varchar(1024)
select @version = (psp2.release)
	FROM simInstalledPackages sip WITH(NOLOCK)
	JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.SPVersionID = psp.id
	JOIN PatchSPVersion psp2 WITH(NOLOCK) ON psp.release = psp2.Release AND psp.build = psp2.build AND psp.SPmajor = psp2.SPMajor and psp.SPMinor = psp2.SPMinor AND psp.TransactionID = psp2.TransactionID
	WHERE sip.clientid = @clientid
DECLARE  @opXmlReq xml = (SELECT @version as CSVersion  for xml raw('App_HealthResponse'),elements)
SELECT  @opXmlReq
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'GetHealthCheckStatusBasic')
	delete from GxQscripts where name = 'GetHealthCheckStatusBasic'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetHealthCheckStatusBasic')
	delete from GXDBVersions where aliasname = 'GetHealthCheckStatusBasic'
GO

insert into GXDBVersions values(2, 'GetHealthCheckStatusBasic',  '00010001000200010000', 'GetHealthCheckStatusBasic', '00010001000200010000')
GO

