

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetGUIPatches.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetGUIPatches.sp,v $ $Id: GetGUIPatches.sp,v 1.21.88.4 2020/05/01 18:00:54 kgao Exp $";
-- =============================================
-- Author:		Praveen Kuttappan
-- Create date: 8/5/2013
-- Description:	returns name and description of the GUI patches available for install
-- =============================================
--0. Ignore Diagnostic patches during processing. SplitID functions fail to convert varchar to Bigint. SP crashes if Diag is present in either cache or diag is installed on the client
--1. Get HighestSP from PatchMulticache where clientid=2 and ReleaseId = inputReleaseID and OSId = inputOSId
--2. Get AdditionalUpdates from PatchMulticache where clientid=2 and ReleaseId = inputReleaseID and OSId = inputOSId. Ignore all the diagnostic/Friendly patches present in cache. For diag patches PatchId = 0
--3. If HighestSP is not equal to 0 then get list1 of update from PatchINI where AppTypeList do not have 1 but has 701 AND HASJAR = 1 AND service pack = HighestSP(from step 1).
--4. Get list2 of update from PatchINI where AppTypeList do not have 1 but has 701 AND HASJAR = 1 AND PatchId = one of AdditionalUpdates(from step 2). Ignore all diagnostic patches present in cache. For diag patches PatchId = 0
--5. Combine list1 and list2
--5.1. Get the list of obsolete patches for list1 and list2
--6. Remove currently installed updates from final list.
--7. Remove obsolete updates collected in step 5.1 from final list.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetGUIPatches')
BEGIN
	print '>>> Drop Stored Procedure: GetGUIPatches <<<'
	drop procedure GetGUIPatches
END
IF EXISTS (select * from GxQscripts where name='GetGUIPatches')
	delete from GxQscripts where name = 'GetGUIPatches'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetGUIPatches')
	delete from GXDBVersions where aliasname = 'GetGUIPatches'
GO
print '... Creating Procedure: GetGUIPatches'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetGUIPatches
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @_ReleaseId int,
  @_OsType int,
  @_InstalledPatches VARCHAR(MAX)
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @t_patchCachedUpdates		TABLE( PatchId NVARCHAR(MAX), obsoletes NVARCHAR(MAX), AliasName NVARCHAR(MAX))
	DECLARE @t_patchInstalledUpdates	TABLE( PatchId NVARCHAR(MAX))
	-- List of GUI updates for specific cache
    -- Ignore all the diagnostic updates present in cache (Diag patches have PatchId = 0)
	INSERT INTO @t_patchInstalledUpdates
	SELECT _ID
	FROM SplitIdString(@_InstalledPatches)
	INSERT INTO @t_patchCachedUpdates
	SELECT pi.patchID, pi.Obsoletes, pi.AliasName
FROM dbo.patchGetCacheInfoByLevel(2, @_ReleaseId, 0, @_OsType, 0) pmc
	JOIN PatchCacheUpdateMap map ON pmc.cacheid = map.cacheID AND map.UPNumber = pmc.UpdatePackNumber
	JOIN PatchINI pi ON map.UpdateID = pi.id
	WHERE HasJar = 1
	AND pi.patchID > 0
	AND pi.patchID NOT IN (SELECT PatchId FROM @t_patchInstalledUpdates)
	AND NOT EXISTS (SELECT 1 FROM PatchUpdatePackageMap WHERE UpdateId = pi.id AND PackageId = 1)
	AND EXISTS (SELECT 1 FROM PatchUpdatePackageMap WHERE UpdateId = pi.id AND PackageID = 701)
	AND (CONVERT(VARBINARY(4096),LOWER(pi.patchId)) = CONVERT(VARBINARY(4096),UPPER(pi.patchId)))
	-- Remove all obsolete patches from @t_patchCachedUpdates
	DELETE @t_patchCachedUpdates
	FROM @t_patchCachedUpdates pcu
	WHERE EXISTS
	(
		SELECT 1
		FROM @t_patchCachedUpdates pcu_obs
		WHERE PATINDEX('%' + pcu.PatchId + '%', pcu_obs.Obsoletes) > 0
	)
	-- Ignore patches that are obsoleted by already installed patches
	DELETE @t_patchCachedUpdates
	FROM @t_patchCachedUpdates pcu
	WHERE EXISTS
	(
		SELECT 1
		FROM @t_patchInstalledUpdates ip
		JOIN PatchINI pi ON ip.PatchId = pi.patchId
		WHERE ReleaseId=@_ReleaseId
		AND OSId=@_OsType
		AND PATINDEX( '%' + pcu.PatchId + '%', pi.Obsoletes) > 0
	)
	SELECT DISTINCT PatchId, AliasName
	FROM @t_patchCachedUpdates
GO

IF EXISTS (select * from GxQscripts where name = 'GetGUIPatches')
	delete from GxQscripts where name = 'GetGUIPatches'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetGUIPatches')
	delete from GXDBVersions where aliasname = 'GetGUIPatches'
GO

insert into GXDBVersions values(2, 'GetGUIPatches',  '00010021008800040000', 'GetGUIPatches', '00010021008800040000')
GO

