

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFtpServicePackInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFtpServicePackInfo.sp,v $ $Id: GetFtpServicePackInfo.sp,v 1.4.14.26.14.1 2021/04/23 00:53:04 mnalamothu Exp $";
--  +========================================================================+
--  | Stored Proc:  GetFtpServicePackInfo()
--  |
--  | Description: Returns the SPNames that are valid for the given release for user to select in download software .
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetFtpServicePackInfo')
BEGIN
	print '>>> Drop Stored Procedure: GetFtpServicePackInfo <<<'
	drop procedure GetFtpServicePackInfo
END
IF EXISTS (select * from GxQscripts where name='GetFtpServicePackInfo')
	delete from GxQscripts where name = 'GetFtpServicePackInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFtpServicePackInfo')
	delete from GXDBVersions where aliasname = 'GetFtpServicePackInfo'
GO
print '... Creating Procedure: GetFtpServicePackInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetFtpServicePackInfo
  @i_xmlText XML
AS
  DECLARE @r_ReturnResult XML
begin
DECLARE	 @ReleaseName NVARCHAR(30)
DECLARE  @UTCStartTime VARCHAR(128) = '1970-01-01'
DECLARE	 @CurrentTimestamp INTEGER = DATEDIFF(s, @UTCStartTime, GETUTCDATE())
DECLARE	 @SPDelayDays INTEGER = 0
DECLARE	 @x_MajorSP	NVARCHAR(30)
DECLARE	 @x_InstalledSP	NVARCHAR(30)
DECLARE	 @x_MainstreamSP	NVARCHAR(30)
DECLARE	 @x_MainstreamSPMajor	INTEGER = 0
DECLARE  @x_LatestCUNumWithMajorSP INTEGER
DECLARE  @x_LatestCUNumWithMainstream INTEGER = 0
DECLARE  @x_InstalledCUNum INTEGER = 0
DECLARE  @InstalledTran INTEGER = 0
DECLARE  @InstalledCUTran INTEGER = 0
DECLARE  @InstalledSPVersionID INTEGER = 0
DECLARE  @InstalledSPMajor Integer = 0
DECLARE  @currentUTCTime DATETIME
-- Read the release number from input xml file for debugging
SET @ReleaseName = 	( SELECT ref.value ('@RelName', 'nvarchar(30)') FROM @i_xmlText.nodes('EVGui_GetFTPServicePackInfoReq') R ( ref ))
SELECT @CurrentTimestamp = ref.value ('@CurrentTimeStamp', 'int') FROM @i_xmlText.nodes('EVGui_GetFTPServicePackInfoReq') R ( ref ) WHERE @CurrentTimestamp <> NULL
SET @currentUTCTime = DATEADD(s, @CurrentTimeStamp, @UTCStartTime)
--Add random Additional delay based on CS GUID (2-59) if SkipAdditionalDelay is not set
IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE LOWER(name) = 'patchspadditionaldelaydays')
BEGIN
SET @SPDelayDays += (SELECT TOP 1 dbo.GetAsciiSumForString(GUID) % 60 FROM APP_Client WHERE id = 2)
	IF @SPDelayDays <= 1
		SET @SPDelayDays = 2
END
SELECT TOP 1 @InstalledSPVersionID = SPVersionID, @x_InstalledCUNum = UPNumber
FROM simInstalledPackages WITH(NOLOCK)
WHERE ClientId = 2
ORDER BY SPVersionID DESC, UPNumber DESC
SET @x_MajorSP = CONCAT( '11.' ,
	(SELECT TOP 1 p.SPMajor FROM simInstalledPackages s WITH(NOLOCK)
	 JOIN PatchSPVersion p WITH(NOLOCK) on s.SPVersionID=p.id
where s.ClientId = 2 and p.Release=16 ORDER BY p.SPMajor DESC), '.', @x_InstalledCUNum)
SELECT @InstalledCUTran = MaxTransactionID FROM PatchUPVersion WITH(NOLOCK) WHERE SPVersionID = @InstalledSPVersionID AND UPNumber = @x_InstalledCUNum
SET @InstalledSPMajor = (SELECT SPMajor FROM PatchSPVersion WITH(NOLOCK) WHERE  id = @InstalledSPVersionID)
select @x_LatestCUNumWithMajorSP = COALESCE(MAX(pup.UPNumber), 0)
from PatchUPVersion pup
join PatchSPVersion psp on psp.SPMajor = @InstalledSPMajor and pup.SPVersionID = psp.id and pup.bIsAvailableForDownload = 1 AND pup.nGUIDownloadDelayDays >= 0 AND (dbo.GetUnixTime(DATEADD(dd, -pup.nGUIDownloadDelayDays, @currentUTCTime)) > pup.Timestamp OR pup.UPNumber = @x_InstalledCUNum)
SET @x_InstalledSP = CONCAT('11.', @InstalledSPMajor, '.', @x_LatestCUNumWithMajorSP)
SET @x_MainstreamSPMajor = ISNULL((SELECT TOP 1 S1.SPMajor
		FROM PatchSPVersion S1  WITH(NOLOCK) LEFT JOIN PatchSPVersion S2  WITH(NOLOCK) ON S1.Release = S2.Release AND S1.Build = S2.Build AND S1.SPMajor = S2.SPMajor AND S1.SPMinor = S2.SPMinor
WHERE dbo.GetUnixTime(DATEADD(dd, -(S2.nGUIDownloadDelayDays + @SPDelayDays), @currentUTCTime)) > S2.Timestamp AND S1.ReleaseStr = @ReleaseName AND S1.bIsDVDPresent=1 AND S2.nLTSFlag = 1 AND S1.SPMajor >= @InstalledSPMajor AND S2.nCacheFlags = 0x1 AND S2.nGUIDownloadDelayDays >= 0
		ORDER BY S1.SPMajor DESC, S1.SPMinor DESC, ISNULL(S2.TransactionId, 0) DESC, ISNULL(S2.RevisionId, 0) DESC), @InstalledSPMajor)
IF @x_MainstreamSPMajor = @InstalledSPMajor
BEGIN
	SET @x_MainstreamSP = @x_InstalledSP
END
ELSE
BEGIN
	select @x_LatestCUNumWithMainstream = COALESCE(MAX(pup.UPNumber), 0)
	from PatchUPVersion pup
	join PatchSPVersion psp on psp.SPMajor = @x_MainstreamSPMajor and pup.SPVersionID = psp.id and pup.bIsAvailableForDownload = 1 AND dbo.GetUnixTime(DATEADD(dd, -pup.nGUIDownloadDelayDays, @currentUTCTime)) > pup.Timestamp AND pup.nGUIDownloadDelayDays >= 0
	SET @x_MainstreamSP = CONCAT('11.', @x_MainstreamSPMajor, '.', @x_LatestCUNumWithMainstream)
END
SELECT @InstalledTran = TransactionID FROM PatchSPVersion WITH(NOLOCK) WHERE id = @InstalledSPVersionID
IF OBJECT_ID('tempdb.dbo.#SPCUList') IS NOT NULL DROP TABLE #SPCUList
CREATE TABLE #SPCUList(SPMajor integer, SPTran integer, CUNum integer, CUFName varchar(50))
IF OBJECT_ID('tempdb.dbo.#SPList') IS NOT NULL DROP TABLE #SPList
CREATE TABLE #SPList(SPMajor integer, UPNumber integer)
INSERT INTO #SPList(SPMajor, UPNumber)
(SELECT DISTINCT S1.SPMajor, COALESCE(MIN(sim.UPNumber), 0)
FROM PatchSPVersion S1 WITH(NOLOCK)
LEFT JOIN PatchSPVersion S2 WITH(NOLOCK) ON S1.Release = S2.Release AND S1.Build = S2.Build AND S1.SPMajor = S2.SPMajor
JOIN simInstalledPackages sim WITH(NOLOCK) ON sim.SPversionID = S1.id
WHERE S2.ReleaseStr = @ReleaseName AND S2.bIsDVDPresent = 1 AND S1.nLTSFlag <> 2 AND S1.nCacheFlags = 0x1
GROUP BY S1.SPMajor)
INSERT INTO #SPList(SPMajor, UPNumber)
(SELECT psp.SPMajor, 0 FROM PatchSPVersion psp WITH(NOLOCK) LEFT JOIN #SPList sp WITH(NOLOCK) ON psp.SPMajor = sp.SPMajor
WHERE bIsDVDPresent = 1 AND bShowInGUI = 1 AND ReleaseStr = @ReleaseName AND psp.SPMajor > @InstalledSPMajor
AND sp.SPMajor IS NULL)
INSERT INTO #SPCUList(SPMajor, SPTran, CUNum, CUFName)
(SELECT DISTINCT S1.SPMajor, S1.TransactionID, pup.UPNumber, pup.FriendlyName
FROM PatchSPVersion S1 WITH(NOLOCK)
LEFT JOIN PatchSPVersion S2 WITH(NOLOCK) ON S1.Release = S2.Release AND S1.Build = S2.Build AND S1.SPMajor = S2.SPMajor
JOIN PatchUPVersion pup WITH(NOLOCK) ON S1.id = pup.SPVersionID
WHERE S2.releaseStr = @ReleaseName AND pup.bIsAvailableForDownload = 1 AND pup.bShowInGUI = 1 AND S1.nLTSFlag <> 2 AND S2.bIsDVDPresent = 1
AND S1.nCacheFlags = 0x1 AND (S1.SPMajor <> @InstalledSPMajor OR pup.UPNumber >= @x_InstalledCUNum))
set @r_ReturnResult = (
							SELECT @x_MajorSP as '@MajorSP',
								@x_InstalledSP as '@InstalledSP',
								@x_LatestCUNumWithMajorSP AS '@LatestCUNumWithMajorSP',
								@x_InstalledCUNum AS '@InstalledCUNum',
								@x_MainstreamSP AS '@MainstreamSP',
							(
								SELECT B.SPMajor AS '@SPName',
								(
									SELECT DISTINCT C.CUNum AS '@Num', C.CUFName AS '@FriendlyName' FROM #SPCUList C WITH(NOLOCK) WHERE B.SPMajor = C.SPMajor AND C.CUNum IS NOT NULL  AND C.CUNum >= B.UPNumber
									ORDER BY C.CUNum DESC
									FOR XML PATH ('CU'), TYPE
								)
								FROM #SPList B WITH(NOLOCK)
								ORDER BY B.SPMajor DESC
								FOR XML PATH ('SPCUList'), TYPE
							)
							FOR XML PATH ('EVGui_GetFTPServicePackInfoResp')
					  )
SELECT @r_ReturnResult
Drop Table #SPList
DROP TABLE #SPCUList
end
GO

IF EXISTS (select * from GxQscripts where name = 'GetFtpServicePackInfo')
	delete from GxQscripts where name = 'GetFtpServicePackInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFtpServicePackInfo')
	delete from GXDBVersions where aliasname = 'GetFtpServicePackInfo'
GO

insert into GXDBVersions values(2, 'GetFtpServicePackInfo',  'v1.4.14.26.14.1', 'GetFtpServicePackInfo', 'v1.4.14.26.14.1')
GO

