

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFsNodeActivity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : GetFsNodeActivity.sp
--	Author		: Logesh G
--
--  Description : This SP is to get clients file & folder anomaly activity
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFsNodeActivity.sp,v $ $Id: GetFsNodeActivity.sp,v 1.1.2.1 2020/04/29 14:58:10 logeshg Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetFsNodeActivity')
BEGIN
	print '>>> Drop Stored Procedure: GetFsNodeActivity <<<'
	drop procedure GetFsNodeActivity
END
IF EXISTS (select * from GxQscripts where name='GetFsNodeActivity')
	delete from GxQscripts where name = 'GetFsNodeActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFsNodeActivity')
	delete from GXDBVersions where aliasname = 'GetFsNodeActivity'
GO
print '... Creating Procedure: GetFsNodeActivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetFsNodeActivity
  @userId INTEGER,
  @inputXml XML,
  @outputXml XML OUTPUT
AS
BEGIN TRY
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg NVARCHAR(MAX) = ''
	--User security check
	DECLARE @isUserAdmin INT = 0
	EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
	IF @isUserAdmin = 0
	BEGIN
		SET @errorCode  = 1
		SET @errorMsg = 'User does not have required capability to view details'
		GOTO ERROR_EXIT
	END
	--Request processing
	DECLARE @clientTbl TABLE(clientId INT)
	DECLARE @filter INTEGER
	SET @filter = ISNULL((SELECT ref.value('@filter','INTEGER') AS data
                    FROM @inputXml.nodes('Api_GetAnomalyInfoReq') R(ref)),0)
	INSERT INTO @clientTbl(clientId)
	SELECT ISNULL(ClientTbl.id.value('@clientId','INT'),0)
	FROM @inputXml.nodes('Api_GetAnomalyInfoReq/clients') AS ClientTbl(id)
	-- If no input client list, then input for all client
	IF NOT EXISTS(SELECT 1 FROM @clientTbl)
	BEGIN
		INSERT INTO @clientTbl(clientId)
		SELECT DISTINCT clientId
		from HistoryDB.dbo.FsNodeActivityData
	END
	-- delete invalid clients from input request or if invalid client present in history table.
	DELETE clientTbl
	FROM @clientTbl clientTbl
	LEFT JOIN APP_Client appClient
	ON appClient.id = clientTbl.clientId
	WHERE appClient.id IS NULL
	--Request processing done
	SET @outputXml = ISNULL((
			SELECT clientTbl.clientId AS '@clientId',
			(
				SELECT	historyTbl.created AS '@createdTime',
						historyTbl.status AS '@status' ,
						CASE
						WHEN @filter = 1 THEN historyTbl.activityInfo.query('Api_AnomalyHistoryRecord/anomalyRecords')
						WHEN @filter = 2 THEN historyTbl.activityInfo.query('Api_AnomalyHistoryRecord/folderInfoList')
						ELSE historyTbl.activityInfo.query('Api_AnomalyHistoryRecord/*')
						END AS anomalyRecord
				FROM HistoryDB.dbo.FsNodeActivityData historyTbl
				WHERE historyTbl.clientId = clientTbl.clientId
				FOR XML PATH('anomalyRecordList'), TYPE
			)
	FROM @clientTbl clientTbl
	FOR XML PATH('clientInfo'),ROOT('Api_AnomalyInfoResp')
	) , '<Api_AnomalyInfoResp/>')
ERROR_EXIT:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorMsg = ERROR_MESSAGE()
END CATCH
IF @errorCode <> 0
BEGIN
	SET @outputXml = (SELECT @errorCode AS '@errorCode' , @errorMsg AS '@errorMessage'
					FOR XML PATH('error'),ROOT('Api_AnomalyInfoResp'))
END
SELECT @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'GetFsNodeActivity')
	delete from GxQscripts where name = 'GetFsNodeActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFsNodeActivity')
	delete from GXDBVersions where aliasname = 'GetFsNodeActivity'
GO

insert into GXDBVersions values(2, 'GetFsNodeActivity',  '00010001000200010000', 'GetFsNodeActivity', '00010001000200010000')
GO

