

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFrPairView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFrPairView.sp,v $ $Id: GetFrPairView.sp,v 1.2.304.2 2018/03/27 08:00:44 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetFrPairView()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetFrPairView <<<'

IF EXISTS (select * from sysobjects where name='GetFrPairView')
	drop procedure GetFrPairView
IF EXISTS (select * from GxQscripts where name='GetFrPairView')
	delete from GxQscripts where name = 'GetFrPairView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFrPairView')
	delete from GXDBVersions where aliasname = 'GetFrPairView'
GO
print '... Creating Procedure: GetFrPairView'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetFrPairView
  @i_clientId integer =0			-- OPTIONAL, RETRIEVE RESULTS FOR ALL OR JUST ONE CLIENT
AS
SET NOCOUNT ON
declare @propDestClient       nvarchar(40)
declare @srcClientForBkupSet  int
declare @destClientForBkupSet int
-----------------------------------------------------------------------------
--Following From DerivedSubclients.cpp!!
set @propDestClient  = 'FLR Destination HostId'
------------------------------------------------------------------------------------------------------------------------------
-- SET UP A VARIABLE TO HOLD THE SUBCLIENT STATUS BITS WE WILL USE TO FILTER OUT SUBCLIENTS FOR CONSIDERATION.  NOTE THAT   --
-- WE'VE INCLUDED "CV_STATUS_HIDDEN".  THIS IS BECAUSE THE DEFAULT SUBCLIENT (PAIR) WHICH IS AUTOMATICALLY CREATED IS NEVER --
-- USED FOR REPLICATION, BUT DOES NOT ALWAYS HAVE (FOR UNKNOWN REASONS) THE DEFAULT BIT SET                                 --
------------------------------------------------------------------------------------------------------------------------------
Declare @scStatusBits       integer;
set     @scStatusBits  =    2+4+8+32        -- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DEFAULT+CV_STATUS_HIDDEN
-----------------------------------------------------------------------------
IF object_id('tempdb.dbo.#PAIRS_TMP') IS NOT Null DROP TABLE #PAIRS_TMP
CREATE TABLE #PAIRS_TMP
    (
     [clientId]        int,
     [backupSetId]     int,
     [subClientId]     int,
     [destClientId]    int,
[clientName]      nvarchar(255),		--'MAX_VARCHAR_SIZE'
[destClientName]  nvarchar(255),		--'MAX_VARCHAR_SIZE'
[backupSetName]   nvarchar(255),		--'MAX_VARCHAR_SIZE'
[srcPath]         nvarchar(255),		-- 'MAX_VARCHAR_SIZE'
[destPath]        nvarchar(255),		--'MAX_VARCHAR_SIZE'
[srcGUID]         nvarchar(255),		-- 'MAX_VARCHAR_SIZE'
[destGUID]        nvarchar(255),		--'MAX_VARCHAR_SIZE'
     )
INSERT INTO #PAIRS_TMP
    SELECT
    clientId,
    backupSet,
    id,
    0,									-- Destination ClientID
    '',									-- Delay Client Name fill-in until later
    '',									-- Delay DestClient Name fill-in until later
    '',									-- Delay BackupSet Name fill-in until later
    '',									-- Source Path
    '',                                 -- Destination Path
    '',									-- Source GUID
    ''                                 -- Destination GUID
FROM   APP_application
WHERE
     apptypeId=84
     AND   (subClientStatus & @scStatusBits) = 0
 if @i_clientId <> 0
 DELETE #PAIRS_TMP WHERE clientID <> @i_clientId
------------------------
-- Fill in MT columns --
------------------------
UPDATE #PAIRS_TMP
  SET destPath = (select stringVal from APP_ScReplicationPair
                       WHERE subClientId = pairId
AND propType = 10002
                        AND modified = 0)
UPDATE #PAIRS_TMP
  SET srcPath = (select stringVal from APP_ScReplicationPair
                       WHERE subClientId = pairId
AND propType = 10001
                        AND modified = 0)
UPDATE #PAIRS_TMP
  SET srcGUID = (select stringVal from APP_ScReplicationPair
                       WHERE subClientId = pairId
AND propType = 10009
                        AND modified = 0)
UPDATE #PAIRS_TMP
  SET destGUID = (select stringVal from APP_ScReplicationPair
                       WHERE subClientId = pairId
AND propType = 10008
                        AND modified = 0)
UPDATE #PAIRS_TMP
  SET destClientId =  (select attrVal
                             from APP_BackupSetProp
                             where componentNameId= [backupSetId]
                             AND attrName = @propDestClient)
UPDATE #PAIRS_TMP
  Set [clientName] = (select name from APP_Client where id = [clientId])
UPDATE #PAIRS_TMP
  Set [destClientName] = (select name from APP_Client where id = [destClientId])
UPDATE #PAIRS_TMP
  set [backupSetName] =  (select name from APP_BackupSetName where id = [backupSetId])
SELECT
	PairId          =[subClientId],
	'Source Client' =[clientName]+'('+convert(nvarchar(3), clientID)+')',
	BackupSet       =[backupSetName]+'('+convert(nvarchar(3), backupSetId)+')',
	[srcPath],
	'Dest Client'   =[destClientName]+'('+convert(nvarchar(3), destClientID)+')',
	[destPath],
	[srcGUID],
	[destGUID]
FROM #PAIRS_TMP
order by [clientName], [backupSetName], [srcPath]
drop table #PAIRS_TMP
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetFrPairView')
	delete from GxQscripts where name = 'GetFrPairView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFrPairView')
	delete from GXDBVersions where aliasname = 'GetFrPairView'
GO

insert into GXDBVersions values(2, 'GetFrPairView',  '00010002030400020000', 'GetFrPairView', '00010002030400020000')
GO

