

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFRstalePairs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFRstalePairs.sp,v $ $Id: GetFRstalePairs.sp,v 1.6.210.2 2018/03/27 08:03:48 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetFRstalePairs()
--  |
--  |      Description: Stored Procedure  ....
--  |
--  |           Results:  ...
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetFRstalePairs <<<'

IF EXISTS (select * from sysobjects where name='GetFRstalePairs')
	drop procedure GetFRstalePairs
IF EXISTS (select * from GxQscripts where name='GetFRstalePairs')
	delete from GxQscripts where name = 'GetFRstalePairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRstalePairs')
	delete from GXDBVersions where aliasname = 'GetFRstalePairs'
GO
print '... Creating Procedure: GetFRstalePairs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetFRstalePairs
  @i_clientId integer
AS
  DECLARE @pairId integer;
  DECLARE @lastStaleTime integer;
  DECLARE @srcClientId integer;
  DECLARE @replicationSetId integer;
  DECLARE @destClientId integer;
  DECLARE @currentState integer;
  DECLARE @lastXferTime integer;
  DECLARE @srcClientName nvarchar(255);
  DECLARE @repSetName nvarchar(128);
  DECLARE @destClientName nvarchar(255);
  DECLARE @srcPath nvarchar(128);
  DECLARE @destPath nvarchar(1024);
SET NOCOUNT ON
------------------------------------------------------------------------------------------------------------------------------
-- SET UP A VARIABLE TO HOLD THE SUBCLIENT STATUS BITS WE WILL USE TO FILTER OUT SUBCLIENTS FOR CONSIDERATION.  NOTE THAT   --
-- WE'VE INCLUDED "CV_STATUS_HIDDEN".  THIS IS BECAUSE THE DEFAULT SUBCLIENT (PAIR) WHICH IS AUTOMATICALLY CREATED IS NEVER --
-- USED FOR REPLICATION, BUT DOES NOT ALWAYS HAVE (FOR UNKNOWN REASONS) THE DEFAULT BIT SET                                 --
------------------------------------------------------------------------------------------------------------------------------
Declare @scStatusBits       integer
Declare @currentTime        integer
Declare @checkTimeSecs      integer
Declare @updateIntervalMin  integer
Declare @checkTimeMin       integer
declare @tempNstr           nvarchar(256)
set     @scStatusBits   =    2+4+8+32        -- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DEFAULT+CV_STATUS_HIDDEN
set     @currentTime    = dbo.GetUnixTime (GetUTCdate())
----------------------------------------------------------------------------------------------------------
-- Determine what the watchdog time should be, based on what params are present in GxGlobalParam DB table.--
----------------------------------------------------------------------------------------------------------
SELECT @tempNstr          = value FROM GxGlobalparam WHERE Name = 'Data Replication Update Interval Minutes'
SET    @updateIntervalMin = ISNULL(@tempNstr, 15)
SET    @tempNstr          = NulL                    -- disguise the keyword 'NULL' from CPP
SELECT @tempNstr          = value FROM GxGlobalparam WHERE Name = 'Data Replication Update Watchdog Minutes'
SET    @checkTimeMin      = ISNULL(@tempNstr, 5)
SET    @checkTimeSecs     = (@updateIntervalMin + @checkTimeMin) * 60
--------------------------------------------------------------------------------------------------------------------------------
-- DESTINATION FOR PAIRS IS SET AT THE BACKUPSET (REPSET) LEVEL.   WE DON'T NEED THIS INFO FOR DETERMINING IF A PAIR IS STILL --
-- ACTIVE, BUT WE WILL USE IT WHEN REPORTING THE RESULTS TO THE CALLER, IF THEY CHOOSE TO DISPLAY IT                          --
--------------------------------------------------------------------------------------------------------------------------------
Declare @propDestClient       nvarchar(40)
set @propDestClient  = 'FLR Destination HostId'
IF object_id('tempdb.dbo.#STALEPAIRS_TMP') IS NOT Null DROP TABLE #STALEPAIRS_TMP
CREATE TABLE #STALEPAIRS_TMP
     (
     [pairId]            integer,
     [srcClientId]       integer,
     [replicationSetId]  integer,
     [destClientId]      integer,
     [currentState]      integer,
     [lastXferTime]      integer,
     [lastStaleTime]     integer,
[srcClientName]     nvarchar(255),                    --'MAX_VARCHAR_SIZE'
[repSetName]        nvarchar(128),        --'CV_MAX_BACKUPSETNAME_LEN_'
[destClientName]    nvarchar(255),                    --'MAX_VARCHAR_SIZE'
[srcPath]           nvarchar(1024),        --'CV_MAX_PROPERTYVALUE_LEN_'
[destPath]          nvarchar(1024)            --'CV_MAX_PROPERTYVALUE_LEN_'     [conflictPath]  nvarchar()        -- 'CV_MAX_PROPERTYVALUE_LEN_'
     )
-------------------------------------------------------------------
-- GET ACTIVE PAIRS EITER FOR A SPECIFIC CLIENT -OR- ALL CLIENTS --
-------------------------------------------------------------------
IF @i_clientId <> 0
BEGIN
    INSERT INTO #STALEPAIRS_TMP
        SELECT
        AP.id,
        AP.clientId,
        AP.backupSet,
        0,              -- destClientId
        0,              -- currentState
        1,              -- lastXferTime
        0,              -- lastStaleTime
        '',             -- srcClientName  (string)
        '',             -- repSetName  (string)
        '',             -- destClientName (string)
        '',             -- srcPath (string)
        ''              -- destPath (string)
    FROM   APP_Application as AP with (nolock)
      WHERE    AP.clientId = @i_clientId
        AND   AP.appTypeId = 84                            -- CV_APPTYPE_CDR
        AND   (AP.subClientStatus & @scStatusBits) = 0
END
ELSE
BEGIN
    INSERT INTO #STALEPAIRS_TMP
        SELECT
        AP.id,
        AP.clientId,
        AP.backupSet,
        0,                -- destClientId
        0,                -- currentState
        1,              -- lastXferTime   (set > 0 so we can use this a dual purpose flag)
        0,              -- lastStaleTime
        '',                -- srcClientName  (string)
        '',                -- repSetName  (string)
        '',                -- destClientName (string)
        '',                -- srcPath (string)
        ''                -- destPath (string)
    FROM   APP_Application as AP with (nolock)
      WHERE  AP.appTypeId = 84                            -- CV_APPTYPE_CDR
        AND   (AP.subClientStatus & @scStatusBits) = 0
END
------------------------------------------------------------------------------------
-- MAKE SURE WE TRACK PAIRS THAT WERE PREVIOUSLY MARKED "STALE", BUT ARE NOW "OK" --
-- WE WILL NEED TO SEND "CLEAR" ALERT CONDITION FOR THOSE                          --
------------------------------------------------------------------------------------
UPDATE #STALEPAIRS_TMP
SET [lastStaleTime] =  (Select intVal
    FROM APP_ScReplicationPair
        WHERE APP_ScReplicationPair.pairId = #STALEPAIRS_TMP.pairId
AND proptype = 16                        --'SCRP_UTC_TIME_STALE_ALERT'
            AND modified = 0)
-- FIRST TIME A PAIR IS STALE, NEED TO CREATE "STALE" PROPERTY IN scReplicationPair Table --
--------------------------------------------------------------------------------------------
INSERT INTO APP_scReplicationPair                     --(pairId, PropType, created, modified, intVal, stringVal)
  SELECT
    SP.pairId,
16,                                -- 'SCRP_UTC_TIME_STALE_ALERT'
    @currentTime,
    0,
    0,
    ''
    FROM  #STALEPAIRS_TMP AS SP
    WHERE [lastStaleTime] IS NuLl                -- Disguise "NULL" from preprocessor (Build issue)
UPDATE #STALEPAIRS_TMP
   SET [lastStaleTime] =  0
    WHERE [lastStaleTime] IS NuLl                -- Disguise "NULL" from preprocessor (Build issue)
-----------------------------------------------------------------------------------------------------
-- IF PAIRS ARE STILL STALE, WE WILL RESET THE STALE TIME FURTHER DOWN ANYWAY, --
-- .. SO WE CAN DO SOME "PRE-CLEANING" NOW                                     --
---------------------------------------------------------------------------------
UPDATE APP_scReplicationPair
SET intVal = 0
    FROM #STALEPAIRS_TMP
        WHERE APP_scReplicationPair.pairId = #STALEPAIRS_TMP.pairId
AND proptype = 16                        --'SCRP_UTC_TIME_STALE_ALERT'
            AND modified = 0
--=====================================================================================================--
----------------------------------------------------------------------------------------------------------------------------
-- "REMOVE" ROWS FOR PAIRS NOT CURRENTLY REPLICATING                                                                        --
-- .. NOTE THAT THE FOLLOWING CRITERIA ARE WHAT IS ALSO USED BY THE GUI SERVER TO DETERMINE "REPLICATING" STATUS          --
----------------------------------------------------------------------------------------------------------------------------
UPDATE #STALEPAIRS_TMP
SET [currentState] =  ISNULL((Select intVal
                    From APP_ScReplicationPair
                    Where APP_scReplicationPair.pairId = #STALEPAIRS_TMP.pairId
AND proptype = 1                        --'SCRP_ACTUAL_STATE_PROP'
                    AND modified = 0),0)
DELETE #STALEPAIRS_TMP
WHERE  [currentState] NOT IN (1, 2, 8, 10 )    -- START_PENDING, STARTED, DONE, LOG_REPLICATION (per Jeet)
  AND [lastStaleTime] = 0                      -- May have to send "clear" if alert was previously set
----------------------------------------------------------------------------------------------------------------------------
-- FOR ALL THE REPLICATING PAIRS, CHECK WHEN THE LAST UPDATE OCCURRED                                                    ---
----------------------------------------------------------------------------------------------------------------------------
UPDATE #STALEPAIRS_TMP
SET [lastXferTime] =  ISNULL((Select intVal
                    From APP_ScReplicationPair
                    Where APP_scReplicationPair.pairId = #STALEPAIRS_TMP.pairId
AND proptype = 13                        --'SCRP_UTC_LAST_XFER_TIME'
                    AND modified = 0), 1)
DELETE #STALEPAIRS_TMP
   WHERE  [lastXferTime] > @currentTime - @checkTimeSecs
      AND [lastStaleTime] = 0
UPDATE #STALEPAIRS_TMP                                                            -- THESE PAIRS ARE NOT STALE (BUT WERE PREVIOUSLY
   SET [lastXferTime] = 0                                                           -- .. REPORTED AS)
       WHERE  [lastXferTime] > @currentTime - @checkTimeSecs
----------------------------------------------------------------------------------------------------------------------------
-- OK, ANY PAIRS "REMAINING" IN THE TABLE ARE "OVERDUE" -OR- RECENTLY CLEARED AND SHOULD BE REPORTED.  FILL IN THE REST   --
-- OF THE COLUMNS SO THAT CALLER CAN CREATE A "PROPER" ERROR MESSAGE                                                      --
----------------------------------------------------------------------------------------------------------------------------
UPDATE #STALEPAIRS_TMP
set [destClientId] = (select attrVal
                             from APP_Backupsetprop
                             where componentNameId=[replicationSetId]
                             AND attrName = @propDestClient
                             AND modified = 0)
UPDATE     #STALEPAIRS_TMP
SET [srcClientName]  = (select [name] from APP_Client Where APP_client.id = [srcClientId]),
    [destClientName] = (select [name] from APP_Client Where APP_client.id = [destClientId])
UPDATE     #STALEPAIRS_TMP
SET [srcPath] = (Select stringVal FROM APP_ScReplicationPair AS SRP
                 Where SRP.pairId = #STALEPAIRS_TMP.pairId
AND  propType = 10001                --'SCRP_SRC_PATH_PROP'
                   AND  modified = 0)
UPDATE     #STALEPAIRS_TMP
SET [destPath] = (Select stringVal FROM APP_ScReplicationPair AS SRP
                 Where SRP.pairId = #STALEPAIRS_TMP.pairId
AND  propType = 10002                --'SCRP_DEST_PATH_PROP'
                   AND  modified = 0)
UPDATE     #STALEPAIRS_TMP
SET [repSetName] = (Select [name] FROM APP_BackupSetName
                 Where APP_BackupSetName.id = #STALEPAIRS_TMP.replicationSetId)
-----------------------------------------------------------------------------------
-- FOR PAIRS THAT ARE STALE, SET THE LAST (STALE) REPORTED TIME, SO WE WILL KNOW --
-- WHEN TO SET THE "ALERT CLEARED" CONDITION                                     --
-----------------------------------------------------------------------------------
UPDATE APP_scReplicationPair
SET intVal = @currentTime
    FROM #STALEPAIRS_TMP
        WHERE APP_scReplicationPair.pairId = #STALEPAIRS_TMP.pairId
AND [proptype] = 16                        --'SCRP_UTC_TIME_STALE_ALERT'
            AND [lastXferTime] > 0
            AND [modified] = 0
---------------------------------------------
-- FINALLY, RETURN ROWS (IF ANY) TO CALLER --
---------------------------------------------
SELECT
     [pairId],
     [lastStaleTime],
     [srcClientId],
     [replicationSetId],
     [destClientId],
     [currentState],
     [lastXferTime],
     [srcClientName],
     [repSetName],
     [destClientName],
     [srcPath],
     [destPath]
FROM #STALEPAIRS_TMP
drop table #STALEPAIRS_TMP
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetFRstalePairs')
	delete from GxQscripts where name = 'GetFRstalePairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRstalePairs')
	delete from GXDBVersions where aliasname = 'GetFRstalePairs'
GO

insert into GXDBVersions values(2, 'GetFRstalePairs',  '00010006021000020000', 'GetFRstalePairs', '00010006021000020000')
GO

