

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFRsetsWithDestClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFRsetsWithDestClient.sp,v $ $Id: GetFRsetsWithDestClient.sp,v 1.12.86.2 2018/03/27 08:00:05 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetFRsetsWithDestClient()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetFRsetsWithDestClient <<<'

IF EXISTS (select * from sysobjects where name='GetFRsetsWithDestClient')
	drop procedure GetFRsetsWithDestClient
IF EXISTS (select * from GxQscripts where name='GetFRsetsWithDestClient')
	delete from GxQscripts where name = 'GetFRsetsWithDestClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRsetsWithDestClient')
	delete from GXDBVersions where aliasname = 'GetFRsetsWithDestClient'
GO
print '... Creating Procedure: GetFRsetsWithDestClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetFRsetsWithDestClient
  @clientParamId int
AS
  DECLARE @clientId int;
  DECLARE @backupSetId int;
  DECLARE @subClientId int;
  DECLARE @clientName nvarchar(255);
  DECLARE @backupSetName nvarchar(128);
  DECLARE @subClientName nvarchar(128);
SET NOCOUNT ON
IF object_id('tempdb.dbo.#CONFLICTSETS_TMP') IS NOT Null DROP TABLE #CONFLICTSETS_TMP
CREATE TABLE #CONFLICTSETS_TMP
    (
     [clientId]     int,
     [instanceID]   int,
     [repSetId]     int,
[clientName]   nvarchar(255),					--'MAX_VARCHAR_SIZE'
[instanceName] nvarchar(128),       --'CV_MAX_BACKUPSETNAME_LEN_'
[repSetName]   nvarchar(128),       --'CV_MAX_SUBCLIENTNAME_LEN_'
     )
-----------------------------------------------------------------------
-- FIND ANY FLR SETS WHERE DESTINATION CLIENT ID MATCHES INPUT VALUE --
-----------------------------------------------------------------------
INSERT INTO #CONFLICTSETS_TMP
  SELECT  DISTINCT [clientId], [instance], 'repSetId' = componentNameId,  '', '', ''
    FROM APP_BackupSetprop, APP_Application
      where attrType = 7
      AND attrName = 'FLR Destination HostId'
      AND attrVal = @clientParamId
      AND componentNameId = backupSet
-- DON'T HAVE TO CHECK FOR "DELETED" REP SETS.  WHEN DELETED, THEY ARE ALWAYS "HARD DELETED" (NO REMAINING DB ENTRIES) --
-- Adjust for "Fan-In" --
 DELETE #CONFLICTSETS_TMP
  WHERE (select status from app_backupsetName where id = [repSetId]) & 8 <> 0
---------------------------------------------
-- FILL IN REST OF #CONFLICTSETS_TMP TABLE --
--------------------------------------------
UPDATE #CONFLICTSETS_TMP
  SET [clientName] = (select [name] from APP_client where id = [clientId])
UPDATE #CONFLICTSETS_TMP
  SET [instanceName] = (select [name] from APP_instanceName where id = [instanceID])
UPDATE #CONFLICTSETS_TMP
  SET [repSetName] = (select [name] from [APP_backupSetName] where id = [repSetId])
----------------------------------------
--  ALL DONE, RETURN RESULTS (IF ANY) --
----------------------------------------
SELECT
     [clientId],
     [instanceID],
     [repSetId],
     [clientName],
     [instanceName],
     [repSetName]
FROM #CONFLICTSETS_TMP
DROP TABLE #CONFLICTSETS_TMP
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetFRsetsWithDestClient')
	delete from GxQscripts where name = 'GetFRsetsWithDestClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRsetsWithDestClient')
	delete from GXDBVersions where aliasname = 'GetFRsetsWithDestClient'
GO

insert into GXDBVersions values(2, 'GetFRsetsWithDestClient',  '00010012008600020000', 'GetFRsetsWithDestClient', '00010012008600020000')
GO

