

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFRconflictPairs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFRconflictPairs.sp,v $ $Id: GetFRconflictPairs.sp,v 1.21.292.2 2018/03/27 08:06:59 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: getFRconflictPairs()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: getFRconflictPairs <<<'

IF EXISTS (select * from sysobjects where name='getFRconflictPairs')
	drop procedure getFRconflictPairs
IF EXISTS (select * from GxQscripts where name='getFRconflictPairs')
	delete from GxQscripts where name = 'getFRconflictPairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getFRconflictPairs')
	delete from GXDBVersions where aliasname = 'getFRconflictPairs'
GO
print '... Creating Procedure: getFRconflictPairs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure getFRconflictPairs
  @i_srcPath NVARCHAR(1024),
  @i_destPath NVARCHAR(1024),
  @i_backupSetId integer
AS
  DECLARE @conflict integer;
  DECLARE @clientId int;
  DECLARE @backupSetId int;
  DECLARE @subClientId int;
  DECLARE @clientName nvarchar(255);
  DECLARE @backupSetName nvarchar(128);
  DECLARE @subClientName nvarchar(128);
  DECLARE @conflictName nvarchar(1024);
SET NOCOUNT ON
declare @prop1Name            nvarchar(30)
declare @prop2Name			  nvarchar(30)
declare @propDestClient       nvarchar(40)
declare @srcClientForBkupSet  int
declare @destClientForBkupSet int
-----------------------------------------------------------------------------
--Following From DerivedSubclients.cpp!!
set @prop2Name       = 'File Replicator Destination Path'
set @prop1Name       = 'File Replicator Source Path'
set @propDestClient  = 'FLR Destination HostId'
set @srcClientForBkupSet =    (select top 1 [clientId] from APP_application where [backupset]=@i_backupSetId)
--Following From DerivedBackupSets.h!!
set @destClientForBkupSet = (select attrVal
                             from APP_backupsetprop
                             where componentNameId=@i_backupSetId
                             AND attrName = @propDestClient)
------------------------------------------------------------------------------------------------------------------------------
-- SET UP A VARIABLE TO HOLD THE SUBCLIENT STATUS BITS WE WILL USE TO FILTER OUT SUBCLIENTS FOR CONSIDERATION.  NOTE THAT   --
-- WE'VE INCLUDED "CV_STATUS_HIDDEN".  THIS IS BECAUSE THE DEFAULT SUBCLIENT (PAIR) WHICH IS AUTOMATICALLY CREATED IS NEVER --
-- USED FOR REPLICATION, BUT DOES NOT ALWAYS HAVE (FOR UNKNOWN REASONS) THE DEFAULT BIT SET                                 --
------------------------------------------------------------------------------------------------------------------------------
Declare @scStatusBits       integer;
set     @scStatusBits  =    2+4+8+32        -- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DEFAULT+CV_STATUS_HIDDEN
-----------------------------------------------------------------------------
IF object_id('tempdb.dbo.#CONFLICTPAIRS_TMP') IS NOT Null DROP TABLE #CONFLICTPAIRS_TMP
CREATE TABLE #CONFLICTPAIRS_TMP
    (conflict integer,
     [propType] int,
     [clientId] int,
     [backupSetId]  int,
     [subClientId]  int,
     [destClientId] int,
[clientName] nvarchar(255),					--'MAX_VARCHAR_SIZE'
[backupSetName] nvarchar(128),		--'CV_MAX_BACKUPSETNAME_LEN_'
[subClientName] nvarchar(128),		--'CV_MAX_SUBCLIENTNAME_LEN_'
[conflictPath]  nvarchar(1024)		-- 'CV_MAX_PROPERTYVALUE_LEN_'
     )
-----------------------------
-- CHECK  DESTINATION PATH --
-----------------------------
-- 1. Destination Paths Must be unique Commserver-wide
-- 2. Destination Folder cannot be used as a Source Folder
-- 3. Pathnames on different machines are NOT the same destination Path!
INSERT INTO #CONFLICTPAIRS_TMP
    SELECT
    2,									-- Conflict is destination type
    propType,
    AP.clientId,
    AP.backupSet,
    SRP.pairID,
    0,									-- Destination ClientID
    '',									-- Delay Client Name fill-in until later
    '',									-- Delay BackupSet Name fill-in until later
    '',									-- Delay SubClient Name fill-in until later
    T_conflict      = SRP.stringVal
FROM   APP_application as AP, APP_scReplicationPair as SRP
WHERE
    SRP.pairId = AP.id
AND (propType = 10001
or propType = 10002)		-- 'cpropType = SCRP_SRC_PATH_PROP or propType = SCRP_DEST_PATH_PROP'
    AND (stringVal = @i_destPath)
    AND AP.apptypeId=84
    AND (AP.subClientStatus & @scStatusBits) = 0
	AND (SRP.modified = 0)
-- CHECK FOR SAME DESTINATION CLIENT+PATH
UPDATE #CONFLICTPAIRS_TMP
  SET destClientId =  (select attrVal
                             from APP_backupsetprop
                             where componentNameId= [backupSetId]
                             AND attrName = @propDestClient)
DELETE #CONFLICTPAIRS_TMP								-- FOR DESTINATION PATHS THAT MATCH DESTINATION PATH PARAMETER, THOSE THAT
 WHERE [destClientId] <> @destClientForBkupSet			-- .. ARE ON DIFFERENT MACHINES ARE OK, SO DELETE THEM FROM CONFLICT RETURN SET
AND [propType] = 10002					-- 'SCRP_DEST_PATH_PROP'
DELETE #CONFLICTPAIRS_TMP								-- FOR SOURCE PATHS THAT MATCH DESTINATION PATH PARAMETER, THOSE THAT
 WHERE [clientId] <> @destClientForBkupSet			-- .. ARE ON DIFFERENT MACHINES ARE OK, SO DELETE THEM FROM CONFLICT RETURN SET
AND [propType] = 10001					-- 'SCRP_SRC_PATH_PROP'
------------------------
-- CHECK  SOURCE PATH --
------------------------
-- 1. Source Path Cannot also be used as a Destination Path
-- 2. (OK to have duplicate Source Paths)
INSERT INTO #CONFLICTPAIRS_TMP
    SELECT
    1,
    propType,
    AP.clientId,
    backupSet,
    SRP.pairID,
    0,
    '',
    '',
    '',
    T_conflict      = SRP.stringVal
FROM   APP_application as AP, APP_scReplicationPair as SRP
WHERE
    SRP.pairId = AP.id
AND  propType = 10002				--'SCRP_DEST_PATH_PROP'
    AND (stringVal = @i_srcPath)
	AND AP.apptypeId=84
    AND (AP.subClientStatus & @scStatusBits) = 0
	AND (SRP.modified = 0)
UPDATE #CONFLICTPAIRS_TMP
  SET destClientId =  (select attrVal
                             from APP_backupsetprop
                             where componentNameId= [backupSetId]
                             AND attrName = @propDestClient)
DELETE #CONFLICTPAIRS_TMP
            WHERE [destclientId] <> @srcClientForBkupSet    -- No Conflict to have same \\Client\Path as Source  in multiple pairs
                  AND [conflict]=1							-- Defect 77404: w/o this, was deleting legitimate
															--   conflict rows from Destination Path Test above
-------------------------------------------------------------
-- NEVER INCLUDE "PSUEDO_PAIRS" IN RESULTS!                --
-------------------------------------------------------------
DELETE #CONFLICTPAIRS_TMP
   WHERE EXISTS (Select * from APP_screplicationPair
                     WHERE [subClientId] = [pairId]
AND [propType] = 18	-- 'SCRP_IS_A_PSEUDOPAIR'
                       AND intVal <> 0)
------------------------
-- Fill in MT columns --
------------------------
UPDATE #CONFLICTPAIRS_TMP
  Set [clientName] = (select name from APP_client where id = [clientId])
UPDATE #CONFLICTPAIRS_TMP
  set [backupSetName] =  (select name from [APP_backupSetName] where id = [backupSetId])
UPDATE #CONFLICTPAIRS_TMP
	set [subclientName] = (select [subclientName] from APP_application WHERE id=[subClientId])
SELECT
	[conflict],
	[clientId],
	[backupSetId],
	[subClientId],
	[clientName],
	[backupSetName],
	[subClientName],
	[conflictPath]
FROM #CONFLICTPAIRS_TMP
drop table #CONFLICTPAIRS_TMP
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetFRconflictPairs')
	delete from GxQscripts where name = 'GetFRconflictPairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRconflictPairs')
	delete from GXDBVersions where aliasname = 'GetFRconflictPairs'
GO

insert into GXDBVersions values(2, 'GetFRconflictPairs',  '00010021029200020000', 'GetFRconflictPairs', '00010021029200020000')
GO

