

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFRconflictLogs.sp] ---------- 

--  UNCOMMENT FOR TRACE DEBUGGING     #define PARAM_TRACE  1
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFRconflictLogs.sp,v $ $Id: GetFRconflictLogs.sp,v 1.6.86.2 2018/03/27 08:06:18 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetFRconflictLogs()
--  |
--	|  Description:  Determine !IF! the requested GUID (param) is
--  |                already being used for any CDR PAIR (subClient)
--  |                on the requested client (param)
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetFRconflictLogs <<<'

IF EXISTS (select * from sysobjects where name='GetFRconflictLogs')
	drop procedure GetFRconflictLogs
IF EXISTS (select * from GxQscripts where name='GetFRconflictLogs')
	delete from GxQscripts where name = 'GetFRconflictLogs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRconflictLogs')
	delete from GXDBVersions where aliasname = 'GetFRconflictLogs'
GO
print '... Creating Procedure: GetFRconflictLogs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetFRconflictLogs
  @clientIDparam int,
  @logGUIDparam nvarchar(1024)
AS
  DECLARE @conflict integer;
  DECLARE @clientId int;
  DECLARE @backupSetId int;
  DECLARE @subClientId int;
  DECLARE @clientName nvarchar(255);
  DECLARE @backupSetName nvarchar(128);
  DECLARE @subClientName nvarchar(128);
  DECLARE @conflictName nvarchar(1024);
SET NOCOUNT ON
set @conflict = 0
IF object_id('tempdb.dbo.#CONFLICTLOGGUIDS_TMP') IS NOT Null DROP TABLE #CONFLICTLOGGUIDS_TMP
CREATE TABLE #CONFLICTLOGGUIDS_TMP
   (
    [clientId] int,
    [backupSetId]  int,
    [subClientId]  int,
    [destClientId] int,
[clientName] nvarchar(255),                   --'MAX_VARCHAR_SIZE'
[backupSetName] nvarchar(128),       --'CV_MAX_BACKUPSETNAME_LEN_'
[subClientName] nvarchar(128),       --'CV_MAX_SUBCLIENTNAME_LEN_'
[conflictGUID]  nvarchar(1024)        -- 'CV_MAX_PROPERTYVALUE_LEN_'
    )
------------------------------------------------------------------------------------------------------------------------------
-- SET UP A VARIABLE TO HOLD THE SUBCLIENT STATUS BITS WE WILL USE TO FILTER OUT SUBCLIENTS FOR CONSIDERATION.  NOTE THAT   --
-- WE'VE INCLUDED "CV_STATUS_HIDDEN".  THIS IS BECAUSE THE DEFAULT SUBCLIENT (PAIR) WHICH IS AUTOMATICALLY CREATED IS NEVER --
-- USED FOR REPLICATION, BUT DOES NOT ALWAYS HAVE (FOR UNKNOWN REASONS) THE DEFAULT BIT SET                                 --
------------------------------------------------------------------------------------------------------------------------------
Declare @scStatusBits       integer;
set     @scStatusBits  =    2+4+8+32        -- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DEFAULT+CV_STATUS_HIDDEN
-----------------------------------------------------------------------------
-------------------------------------------
-- FIND ALL PAIR IDS WITH MATCHING GUIDs --
-------------------------------------------
INSERT INTO #CONFLICTLOGGUIDS_TMP
    SELECT
    AP.clientId,
    AP.backupSet,
    SRP.pairID,
    0,                                  -- Destination ClientID
    '',                                 -- Delay Client Name fill-in until later
    '',                                 -- Delay BackupSet Name fill-in until later
    '',                                 -- Delay SubClient Name fill-in until later
    [conflictGUID]   = @logGUIDparam
FROM   APP_Application as AP, APP_scReplicationPair as SRP
WHERE
    SRP.pairId   = AP.id
    AND   AP.apptypeId=84
    AND   (AP.subClientStatus & @scStatusBits) = 0
AND propType     = 10009		-- 'SCRP_SOURCE_GUID'
    AND stringVal    = @logGUIDparam
    AND AP.clientId  = @clientIDparam
    AND SRP.modified = 0
IF NOT EXISTS (select * from #CONFLICTLOGGUIDS_TMP)
    GOTO  NO_CONFLICTS
SET @conflict = 1010						-- 'SCRP_CONFLICT_GUID_LOGFILE'
-------------------------------------------------------------
-- NEVER INCLUDE "PSUEDO_PAIRS" IN RESULTS!                --
-------------------------------------------------------------
DELETE #CONFLICTLOGGUIDS_TMP
   WHERE EXISTS (Select * from APP_ScreplicationPair
                     WHERE [subClientId] = [pairId]
AND [propType] = 18   -- 'SCRP_IS_A_PSEUDOPAIR'
                       AND intVal <> 0)
-------------------------------------------------------------
-- FILL IN SOME MISSING COLUMN DATA FROM APPLICATION TABLE --
-------------------------------------------------------------
UPDATE #CONFLICTLOGGUIDS_TMP
   SET backupSetID = (select [backupSet] FROM APP_Application WHERE id = [subClientId])
-------------------------------------------------------------
-- ANY REMAINING ROWS !ARE! CONFLICTS, SO FILL IN MISSING  --
-- COLUMNS FOR REPORTING PURPOSES                          --
-------------------------------------------------------------
UPDATE #CONFLICTLOGGUIDS_TMP
  SET [clientName] = (select [name] from APP_Client where id = [clientId])
UPDATE #CONFLICTLOGGUIDS_TMP
  SET [backupSetName] = (select [name] from [APP_BackupSetName] where id = [backupSetId])
UPDATE #CONFLICTLOGGUIDS_TMP
  SET [subclientName] = (select [subclientName] from [APP_Application] where id = [subClientId])
NO_CONFLICTS:
-------------------------------------------------
-- FINALLY, REPORT BACK TO CALLER AND CLEAN UP --
-------------------------------------------------
SELECT
    @conflict,
    [clientId],
    [backupSetId],
    [subClientId],
    [clientName],
    [backupSetName],
    [subClientName],
    [conflictGUID]
FROM #CONFLICTLOGGUIDS_TMP
drop table #CONFLICTLOGGUIDS_TMP
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetFRconflictLogs')
	delete from GxQscripts where name = 'GetFRconflictLogs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRconflictLogs')
	delete from GXDBVersions where aliasname = 'GetFRconflictLogs'
GO

insert into GXDBVersions values(2, 'GetFRconflictLogs',  '00010006008600020000', 'GetFRconflictLogs', '00010006008600020000')
GO

