

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFRconflictGUIDS.sp] ---------- 

--  UNCOMMENT FOR TRACE DEBUGGING     #define PARAM_TRACE  1
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFRconflictGUIDS.sp,v $ $Id: GetFRconflictGUIDS.sp,v 1.31.86.2 2018/03/27 08:17:09 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetFRconflictGUIDS()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetFRconflictGUIDS <<<'

IF EXISTS (select * from sysobjects where name='GetFRconflictGUIDS')
	drop procedure GetFRconflictGUIDS
IF EXISTS (select * from GxQscripts where name='GetFRconflictGUIDS')
	delete from GxQscripts where name = 'GetFRconflictGUIDS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRconflictGUIDS')
	delete from GXDBVersions where aliasname = 'GetFRconflictGUIDS'
GO
print '... Creating Procedure: GetFRconflictGUIDS'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetFRconflictGUIDS
  @iFlag int,
  @setId int,
  @pairId int,
  @srcGUIDparam nvarchar(1024),
  @destGUIDparam nvarchar(1024)
AS
  DECLARE @clientId int;
  DECLARE @backupSetId int;
  DECLARE @subClientId int;
  DECLARE @clientName nvarchar(255);
  DECLARE @backupSetName nvarchar(128);
  DECLARE @subClientName nvarchar(128);
  DECLARE @conflictGUID nvarchar(1024);
  DECLARE @conflictCode int;
SET NOCOUNT ON
DECLARE @dstClientId nvarchar(255);
-- FOLLOWING IS A "HIDDEN" OPTION THAT WILL ALLOW USERS TO SELECT THE SAME SRC & DESTINATION VOLUMN
-- ENTRY MUST BE IN GLOBALPARAM, AND THE VALUE MUST BE SET TO '1', OTHERWISE ALL CHECKING WILL BE DONE!
Declare  @skipSameVolFolderCheck int
set @skipSameVolFolderCheck = 0
if exists (select  * from GXGlobalParam where name = 'FLRAllowChaining' AND value like '1')   --'GLOBALPARAM_SKIP_FLAG'
  set @skipSameVolFolderCheck = 1
-- CONVENIENCE VARIABLES:
declare @backupSet integer
------------------------------------------------------------------------------------------------------------------------------
-- SET UP A VARIABLE TO HOLD THE SUBCLIENT STATUS BITS WE WILL USE TO FILTER OUT SUBCLIENTS FOR CONSIDERATION.  NOTE THAT   --
-- WE'VE INCLUDED "CV_STATUS_HIDDEN".  THIS IS BECAUSE THE DEFAULT SUBCLIENT (PAIR) WHICH IS AUTOMATICALLY CREATED IS NEVER --
-- USED FOR REPLICATION, BUT DOES NOT ALWAYS HAVE (FOR UNKNOWN REASONS) THE DEFAULT BIT SET                                 --
------------------------------------------------------------------------------------------------------------------------------
Declare @scStatusBits       integer;
set     @scStatusBits  =    2+4+8+32        -- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DEFAULT+CV_STATUS_HIDDEN
-----------------------------------------------------------------------------
if (@pairId <> 0 )
BEGIN
	set @backupSet = (select backupSet from APP_application Where id = @pairId)
declare @GUIDstring nvarchar(1024)
	set @GUIDstring = (SELECT stringVal FROM APP_ScReplicationPair
                      WHERE [pairId] = @pairId
AND propType = 10008)  -- 'SCRP_DESTINATION_GUID'
END
else
BEGIN
	SET @backupSet  = @setId
	SET @GUIDstring = @destGUIDparam
END
set @clientId = (select top 1 clientid from APP_Application where backupSet = @backupSet)
set @dstClientId = (select top 1 attrVal from app_backupsetprop where componentnameid = @backupSet and attrname like 'FLR Destination HostId')
IF object_id('tempdb.dbo.#CONFLICTGUIDS_TMP') IS NOT Null DROP TABLE #CONFLICTGUIDS_TMP
CREATE TABLE #CONFLICTGUIDS_TMP
    (
     [clientId]           int,
     [backupSetId]        int,
     [subClientId]        int,
     [bkupSetReplOptions] int,
[clientName]         nvarchar(255),					--'MAX_VARCHAR_SIZE'
[backupSetName]      nvarchar(128),		--'CV_MAX_BACKUPSETNAME_LEN_'
[subClientName]      nvarchar(128),		--'CV_MAX_SUBCLIENTNAME_LEN_'
[conflictPath]       nvarchar(1024),		-- 'CV_MAX_PROPERTYVALUE_LEN_'
	 [conflictCode]       int
     )
-------------------------------------------
-- FIND ALL PAIR IDS WITH MATCHING GUIDs --
-------------------------------------------
--INSERT INTO #CONFLICTGUIDS_TMP
  -- SELECT
    --[clientId]           = 0,
    --[backupSetId]        = 0,
    --[subClientId]        = SRP.pairId,
    --[bkupSetReplOptions] = 0,
    --[clientName]         = '',
    --[backupSetName]      = '',
    --[subClientName]      = '',
    --[conflictPath]       = @GUIDstring,
	--[conflictCode]       = SCRP_CONFLICT_GUID_CONSIST_PTS			--'SCRP_CONFLICT_GUID_CONSIST_PTS'
   --FROM   APP_application as AP,  APP_scReplicationPair as SRP
   --WHERE
	--SRP.pairId   = AP.id
    --AND propType = SCRP_DESTINATION_GUID				-- 'SCRP_DESTINATION_GUID'
    --AND stringVal =  @GUIDstring
    --AND AP.apptypeId=84
    --AND (AP.subClientStatus & @scStatusBits) = 0
	--AND SRP.modified = 0								-- ALWAYS USE "MOST CURRENT"
-------------------------------------------------------------
-- FILL IN SOME MISSING COLUMN DATA FROM APPLICATION TABLE --
-------------------------------------------------------------
UPDATE #CONFLICTGUIDS_TMP
SET backupSetID = (select [backupSet] FROM APP_application WHERE id = [subClientId])
UPDATE #CONFLICTGUIDS_TMP
SET bkupSetReplOptions = (select [attrVal] FROM APP_BackupsetProp
                            WHERE componentNameId = [backupSetID]
                            AND  attrName = "FLR Replication Options"			-- 'CV_FILE_REPL_OPTIONS_FLAGS' from DerivedBackupSets.h (hard coded here!)
                            )
----------------------------------------------------------------
-- DELETE THE SUBCLIENTS FROM THE SAME BACKUPSET, THEY ARE OK --
----------------------------------------------------------------
DELETE #CONFLICTGUIDS_TMP
  WHERE [backupSetID] = @backupSet
------------------------------------------------------------------------------------------------------------------
-- (CONDITIONALLY) DELETE THE SUBCLIENTS WHOSE BACKUPSETS !DO NOT! HAVE ALLOW CONSISTENCY POINTS OPTION ENABLED --
------------------------------------------------------------------------------------------------------------------
IF (@iFlag = 0)
	DELETE #CONFLICTGUIDS_TMP
  		WHERE ((bkupSetReplOptions & 64) = 0)  --'CV_FILE_REPL_OPT_ALLOW_CONSIST_PTS' From Derived BackupSets.h (Harcoded here!)
IF @skipSameVolFolderCheck = 0
BEGIN
------------------------------------------------------------------------------------------------------------------
-- Defect 77012: A Volume that is used as a source cannot also be used as a destination                         --
------------------------------------------------------------------------------------------------------------------
IF @srcGUIDparam <> ''
	INSERT INTO #CONFLICTGUIDS_TMP
	SELECT
		[clientId]           = 0,
		[backupSetId]        = 0,
		[subClientId]        = [pairId],
		[bkupSetReplOptions] = 0,
		[clientName]         = '',
		[backupSetName]      = '',
		[subClientName]      = '',
		[conflictPath]       = @srcGUIDparam,
--		[conflictCode]       = SCRP_CONFLICT_GUID_SRC_VOL			--'SCRP_CONFLICT_GUID_SRC_VOL'
[conflictCode]       = 1003			--'SCRP_CONFLICT_GUID_DEST_VOL'
	FROM APP_ScReplicationPair
	WHERE
propType = 10008				-- 'SCRP_DESTINATION_GUID'
		AND (select top 1 attrVal from app_backupsetprop where componentnameid in( select backupset from app_application where id = [pairId] ) and attrname like 'FLR Destination HostId'  ) + ':' + stringVal =  (CAST(@clientId AS NVARCHAR(20)) + ':' + @srcGUIDparam)  --@srcGUIDparam
		AND modified = 0								-- ALWAYS USE "MOST CURRENT"
END					-- skipCheck
IF @destGUIDparam <> ''
	INSERT INTO #CONFLICTGUIDS_TMP
	SELECT
		[clientId]           = 0,
		[backupSetId]        = 0,
		[subClientId]        = [pairId],
		[bkupSetReplOptions] = 0,
		[clientName]         = '',
		[backupSetName]      = '',
		[subClientName]      = '',
		[conflictPath]       = @destGUIDparam,
--		[conflictCode]       = SCRP_CONFLICT_GUID_DEST_VOL			--'SCRP_CONFLICT_GUID_DEST_VOL'
[conflictCode]       = 1002			--'SCRP_CONFLICT_GUID_SRC_VOL'
	FROM APP_ScReplicationPair
	WHERE
propType = 10009				-- 'SCRP_SOURCE_GUID'
        AND (CAST((select top 1 clientid from APP_Application where id = [pairId] ) AS NVARCHAR(20)) + ':' + stringVal) =  ( @dstClientId + ':'+ @destGUIDparam )
		AND modified = 0						-- ALWAYS USE "MOST CURRENT"
UPDATE #CONFLICTGUIDS_TMP
SET backupSetID = (select [backupSet] FROM APP_application WHERE id = [subClientId])
WHERE backupSetID = 0
-------------------------------------------------------------
-- NEVER INCLUDE "PSUEDO_PAIRS" IN RESULTS!                --
-------------------------------------------------------------
DELETE #CONFLICTGUIDS_TMP
   WHERE EXISTS (Select * from APP_ScReplicationPair
                     WHERE [subClientId] = [pairId]
AND [propType] = 18   -- 'SCRP_IS_A_PSEUDOPAIR'
                       AND intVal <> 0)
-------------------------------------------------------------
-- ANY REMAINING ROWS !ARE! CONFLICTS, SO FILL IN MISSING  --
-- COLUMNS FOR REPORTING PURPOSES                          --
-------------------------------------------------------------
UPDATE #CONFLICTGUIDS_TMP
  SET [clientId] = (select [clientID] FROM APP_application WHERE id = [subClientId])
UPDATE #CONFLICTGUIDS_TMP
  SET [clientName] = (select [name] from APP_Client where id = [clientId])
UPDATE #CONFLICTGUIDS_TMP
  SET [backupSetName] = (select [name] from [APP_BackupSetName] where id = [backupSetId])
UPDATE #CONFLICTGUIDS_TMP
  SET [subclientName] = (select [subclientName] from [APP_application] where id = [subClientId])
-------------------------------------------------
-- FINALLY, REPORT BACK TO CALLER AND CLEAN UP --
-------------------------------------------------
SELECT
	[clientId],
    [backupSetId],
    [subClientId],
    [clientName],
    [backupSetName],
    [subClientName],
    [conflictPath],
	[conflictCode]
FROM #CONFLICTGUIDS_TMP
drop table #CONFLICTGUIDS_TMP
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetFRconflictGUIDS')
	delete from GxQscripts where name = 'GetFRconflictGUIDS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRconflictGUIDS')
	delete from GXDBVersions where aliasname = 'GetFRconflictGUIDS'
GO

insert into GXDBVersions values(2, 'GetFRconflictGUIDS',  '00010031008600020000', 'GetFRconflictGUIDS', '00010031008600020000')
GO

