

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetFRactivePairsForIda.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetFRactivePairsForIda.sp,v $ $Id: GetFRactivePairsForIda.sp,v 1.11.278.2 2018/03/27 08:05:03 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetFRactivePairsForIda()
--  |
--	|      Description: Stored Procedure called by CvSim to determine if any
--  |                   Replication Pairs are still active for the iDa before
--	|                   deleting the iDa.  Assumes single instance of CDR iDa
--  |                   per client.
--	|
--	|		   Results: If no pairs are still active, no rows are returned. If
--	|                   any pairs are still active, one row is returned for ea.
--	|                   such pair
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetFRactivePairsForIda <<<'

IF EXISTS (select * from sysobjects where name='GetFRactivePairsForIda')
	drop procedure GetFRactivePairsForIda
IF EXISTS (select * from GxQscripts where name='GetFRactivePairsForIda')
	delete from GxQscripts where name = 'GetFRactivePairsForIda'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRactivePairsForIda')
	delete from GXDBVersions where aliasname = 'GetFRactivePairsForIda'
GO
print '... Creating Procedure: GetFRactivePairsForIda'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetFRactivePairsForIda
  @i_clientId integer
AS
  DECLARE @pairId integer;
  DECLARE @srcClientId integer;
  DECLARE @replicationSetId integer;
  DECLARE @destClientId integer;
  DECLARE @currentState integer;
  DECLARE @srcClientName nvarchar(255);
  DECLARE @destClientName nvarchar(128);
  DECLARE @repSetName nvarchar(128);       --'CV_MAX_SUBCLIENTNAME_LEN_'
  DECLARE @srcPath nvarchar(128);
  DECLARE @destPath nvarchar(1024);
SET NOCOUNT ON
------------------------------------------------------------------------------------------------------------------------------
-- SET UP A VARIABLE TO HOLD THE SUBCLIENT STATUS BITS WE WILL USE TO FILTER OUT SUBCLIENTS FOR CONSIDERATION.  NOTE THAT   --
-- WE'VE INCLUDED "CV_STATUS_HIDDEN".  THIS IS BECAUSE THE DEFAULT SUBCLIENT (PAIR) WHICH IS AUTOMATICALLY CREATED IS NEVER --
-- USED FOR REPLICATION, BUT DOES NOT ALWAYS HAVE (FOR UNKNOWN REASONS) THE DEFAULT BIT SET                                 --
------------------------------------------------------------------------------------------------------------------------------
Declare @scStatusBits       integer;
set     @scStatusBits  =	2+4+8+32    	-- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DEFAULT+CV_STATUS_HIDDEN
--------------------------------------------------------------------------------------------------------------------------------
-- DESTINATION FOR PAIRS IS SET AT THE BACKUPSET (REPSET) LEVEL.   WE DON'T NEED THIS INFO FOR DETERMINING IF A PAIR IS STILL --
-- ACTIVE, BUT WE WILL USE IT WHEN REPORTING THE RESULTS TO THE CALLER, IF THEY CHOOSE TO DISPLAY IT                          --
--------------------------------------------------------------------------------------------------------------------------------
Declare @propDestClient       nvarchar(40)
set @propDestClient  = 'FLR Destination HostId'
IF object_id('tempdb.dbo.#ACTIVEPAIRS_TMP') IS NOT Null DROP TABLE #ACTIVEPAIRS_TMP
CREATE TABLE #ACTIVEPAIRS_TMP
     (
     [pairId]			integer,
     [srcClientId]		integer,
     [replicationSetId]	integer,
     [destClientId]		integer,
     [currentState]		integer,
[srcClientName]	nvarchar(255),				--'MAX_VARCHAR_SIZE'
[destClientName]	nvarchar(255),				--'MAX_VARCHAR_SIZE'
[repSetName]		nvarchar(128),	--'CV_MAX_SUBCLIENTNAME_LEN_'
[srcPath]			nvarchar(1024),	--'CV_MAX_PROPERTYVALUE_LEN_'
[destPath]			nvarchar(1024)		--'CV_MAX_PROPERTYVALUE_LEN_'     [conflictPath]  nvarchar()		-- 'CV_MAX_PROPERTYVALUE_LEN_'
     )
INSERT INTO #ACTIVEPAIRS_TMP
    SELECT
    AP.id,
    AP.clientId,
    AP.backupSet,
    0,				-- destClientId
    0,				-- currentState
    '',				-- srcClientName  (string)
    '',				-- destClientName (string)
    '',				-- repSetName (string)
    '',				-- srcPath (string)
    ''				-- destPath (string)
FROM   APP_Application as AP
WHERE	AP.clientId = @i_clientId
  AND   AP.appTypeId = 84							-- CV_APPTYPE_CDR
  AND   (AP.subClientStatus & @scStatusBits) = 0
UPDATE #ACTIVEPAIRS_TMP
  SET [currentState] =  ISNULL((Select intVal
                       From APP_ScReplicationPair
                       Where APP_ScReplicationPair.pairId = #ACTIVEPAIRS_TMP.pairId
AND proptype = 1						--'SCRP_ACTUAL_STATE_PROP'
                       AND modified = 0), 0)
----------------------------------------------------------------------------------------------------------------------------
-- NOTE THAT THE FOLLOWING CRITERIA ARE WHAT IS ALSO USED BY THE GUI SERVER BEFORE DELETING PAIRS ON A PAIR BY PAIR BASIS --
----------------------------------------------------------------------------------------------------------------------------
DELETE #ACTIVEPAIRS_TMP
WHERE  [currentState] in (0, 6, 9, 12 )		-- MR 92572  States per Vijay 4/13/2007
--WHERE  [currentState] in (0, 6, 8, 9 )    -- UNKNOWN(NEW), STOPPED, DONE, FAILED(ABORTED)
----------------------------------------------------------------------------------------------------------------------------
-- FAN-IN IS DONE ON THE DEFAULT REPSET.  "RECOVERY POINTS" will be used for "Activity" Checks on these pairs, so remove  --
-- them here                                                                                                              --
----------------------------------------------------------------------------------------------------------------------------
DELETE #ACTIVEPAIRS_TMP
WHERE (select status from app_backupsetName where id = replicationSetId) & 8 <> 0
----------------------------------------------------------------------------------------------------------------------------
-- THE REMAINING ROWS IN THE TEMP TABLE ARE STILL DEEMED "ACTIVE".  FILL IN THE REST OF THE FIELDS SO THAT THE CALLER     --
-- CAN IDENTIFY TO THE USER WHAT PAIRS HAVE TO BE CLEANED UP BEFORE THIS IDA CAN BE DELETED                               --
----------------------------------------------------------------------------------------------------------------------------
UPDATE #ACTIVEPAIRS_TMP
set [destClientId] = (select attrVal
                             from APP_Backupsetprop
                             where componentNameId=[replicationSetId]
                             AND attrName = @propDestClient
                             AND modified = 0)
UPDATE 	#ACTIVEPAIRS_TMP
SET [srcClientName]  = (select [name] from APP_client Where APP_client.id = [srcClientId]),
    [destClientName] = (select [name] from APP_client Where APP_client.id = [destClientId])
UPDATE 	#ACTIVEPAIRS_TMP
SET [srcPath] = (Select stringVal FROM APP_ScReplicationPair AS SRP
                 Where SRP.pairId = #ACTIVEPAIRS_TMP.pairId
AND  propType = 10001				--'SCRP_SRC_PATH_PROP'
                   AND  modified = 0)
UPDATE 	#ACTIVEPAIRS_TMP
SET [destPath] = (Select stringVal FROM APP_ScReplicationPair AS SRP
                 Where SRP.pairId = #ACTIVEPAIRS_TMP.pairId
AND  propType = 10002				--'SCRP_DEST_PATH_PROP'
                   AND  modified = 0)
UPDATE  #ACTIVEPAIRS_TMP
SET [repSetName] = (Select [name] FROM APP_BackupSetName
                 Where APP_BackupSetName.id = #ACTIVEPAIRS_TMP.replicationSetId)
---------------------------------------------
-- FINALLY, RETURN ROWS (IF ANY) TO CALLER --
---------------------------------------------
SELECT
     [pairId],
     [srcClientId],
     [replicationSetId],
     [destClientId],
     [currentState],
     [srcClientName],
     [destClientName],
     [repSetName],
     [srcPath],
     [destPath]
FROM #ACTIVEPAIRS_TMP
drop table #ACTIVEPAIRS_TMP
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetFRactivePairsForIda')
	delete from GxQscripts where name = 'GetFRactivePairsForIda'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetFRactivePairsForIda')
	delete from GXDBVersions where aliasname = 'GetFRactivePairsForIda'
GO

insert into GXDBVersions values(2, 'GetFRactivePairsForIda',  '00010011027800020000', 'GetFRactivePairsForIda', '00010011027800020000')
GO

