

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetExchangeMailBoxTotal.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/08/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetExchangeMailBoxTotal.sp,v $ $Id: ";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetExchangeMailBoxTotal <<<'

IF EXISTS (select * from sysobjects where name='GetExchangeMailBoxTotal')
	drop procedure GetExchangeMailBoxTotal
IF EXISTS (select * from GxQscripts where name='GetExchangeMailBoxTotal')
	delete from GxQscripts where name = 'GetExchangeMailBoxTotal'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetExchangeMailBoxTotal')
	delete from GXDBVersions where aliasname = 'GetExchangeMailBoxTotal'
GO
print '... Creating Procedure: GetExchangeMailBoxTotal'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetExchangeMailBoxTotal
AS
	DECLARE @clientId	INT
	DECLARE @appTypeId	INT
	DECLARE @backupSet	INT
	DECLARE @scName		nvarchar(128)
	DECLARE @scStatus	INT
	IF object_id('tempdb.dbo.#mailBoxInfo') is not null DROP TABLE #mailBoxInfo
	create table  #mailBoxInfo
	(
		clientId		int NOT null,
		appTypeId		int NOT null,
		backupSet		int NOT null,
		clientName		nvarchar(255),
		appTypeName		varchar(255),
		subclientName	nvarchar(128),
		mailBoxCount	int,
	)
	DECLARE exchangeMailBoxes CURSOR LOCAL FORWARD_ONLY FOR
	SELECT clientId, appTypeId, backupSet, subclientName, subclientStatus
		FROM APP_Application WHERE id IN (SELECT componentNameId FROM app_subclientprop WHERE attrType=111 AND modified=0) ORDER BY clientId, appTypeId
	BEGIN TRANSACTION
	OPEN exchangeMailBoxes
	FETCH FROM exchangeMailBoxes INTO @clientId, @appTypeId, @backupSet, @scName, @scStatus
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS(SELECT * FROM #mailBoxInfo WHERE clientId=@clientId AND appTypeId=@appTypeId AND backupSet=@backupSet)
		BEGIN
			UPDATE #mailBoxInfo
			SET mailBoxCount = mailBoxCount + 1
			WHERE clientId=@clientId AND appTypeId=@appTypeId AND backupSet=@backupSet
		END
		ELSE
		BEGIN
			INSERT INTO #mailBoxInfo
			SELECT @clientId, @appTypeId, @backupSet, '', '', @scName, 1
		END
		FETCH NEXT FROM exchangeMailBoxes INTO @clientId, @appTypeId, @backupSet, @scName, @scStatus
	END
	UPDATE #mailBoxInfo
	SET clientName = (SELECT name FROM APP_Client WHERE id = #mailBoxInfo.clientId)
	WHERE clientName=''
	UPDATE #mailBoxInfo
	SET appTypeName = (SELECT name FROM APP_IDAType WHERE type = #mailBoxInfo.appTypeId)
	WHERE appTypeName=''
	SELECT clientName, subclientName, appTypeName, mailBoxCount FROM #mailBoxInfo
	CLOSE exchangeMailBoxes
	DEALLOCATE exchangeMailBoxes
	ROLLBACK TRANSACTION
	DROP TABLE #mailBoxInfo
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetExchangeMailBoxTotal')
	delete from GxQscripts where name = 'GetExchangeMailBoxTotal'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetExchangeMailBoxTotal')
	delete from GXDBVersions where aliasname = 'GetExchangeMailBoxTotal'
GO

insert into GXDBVersions values(2, 'GetExchangeMailBoxTotal',  '00000000000000000000', 'GetExchangeMailBoxTotal', '00000000000000000000')
GO

