

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetError.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetError.sp,v $ $Id: GetError.sp,v 1.4 2007/02/28 15:28:15 avibhor Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Submit the immediate job
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetError <<<'

IF EXISTS (select * from sysobjects where name='GetError')
	drop procedure GetError
IF EXISTS (select * from GxQscripts where name='GetError')
	delete from GxQscripts where name = 'GetError'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetError')
	delete from GXDBVersions where aliasname = 'GetError'
GO
print '... Creating Procedure: GetError'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetError
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @errorString NVARCHAR(MAX) OUTPUT,
  @errorCode integer OUTPUT
AS
BEGIN
    SET NOCOUNT ON;
    -- Get error information.
	SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Error ' + CONVERT(varchar(50), ERROR_NUMBER()) +
          ', Severity ' + CONVERT(varchar(5), ERROR_SEVERITY()) +
          ', State ' + CONVERT(varchar(5), ERROR_STATE()) +
          ', Procedure ' + ISNULL(ERROR_PROCEDURE(), '-') +
          ', Line ' + CONVERT(varchar(5), ERROR_LINE());
     SET @errorString = @errorString + ' Message ' + ERROR_MESSAGE();
END;
GO

IF EXISTS (select * from GxQscripts where name = 'GetError')
	delete from GxQscripts where name = 'GetError'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetError')
	delete from GXDBVersions where aliasname = 'GetError'
GO

insert into GXDBVersions values(2, 'GetError',  '00010004000000000000', 'GetError', '00010004000000000000')
GO

