

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetEntityExtractorInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  GetEntityExtractorInfo
--  | Description:   Get entity extraction information from tables in EntityAnnotator
--  |                and EntityExtractionRule
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetEntityExtractorInfo.sp,v $ $Id: GetEntityExtractorInfo.sp,v 1.6.2.31.8.1 2021/01/30 01:01:06 jjindal Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetEntityExtractorInfo')
BEGIN
	print '>>> Drop Stored Procedure: GetEntityExtractorInfo <<<'
	drop procedure GetEntityExtractorInfo
END
IF EXISTS (select * from GxQscripts where name='GetEntityExtractorInfo')
	delete from GxQscripts where name = 'GetEntityExtractorInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetEntityExtractorInfo')
	delete from GXDBVersions where aliasname = 'GetEntityExtractorInfo'
GO
print '... Creating Procedure: GetEntityExtractorInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetEntityExtractorInfo
  @i_xmlStr XML = ''
AS
  DECLARE @o_respXML XML = ''
--sample input XML
--'<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
--<DM2ContentIndexing_EntityDetailsReq opType="1"><entity extractingClientName="10" ruleType="1"/><instance instanceName="Instance001"/></DM2ContentIndexing_EntityDetailsReq>'
DECLARE @ruleType INT = ISNULL(( SELECT R.ref.value('@ruleType', 'INT') FROM @i_xmlStr.nodes('/DM2ContentIndexing_EntityDetailsReq/entity') R(ref)), 1)
DECLARE @eeClientName NVARCHAR(1024) = ISNULL(( SELECT R.ref.value('@extractingClientName', 'NVARCHAR(1024)') FROM @i_xmlStr.nodes('/DM2ContentIndexing_EntityDetailsReq/entity') R(ref)), N'')
DECLARE @eeClientId INT = ISNULL(( SELECT id FROM APP_CLIENT  WITH (NOLOCK) WHERE name = @eeClientName), 0)
DECLARE @requestType INT = ISNULL(( SELECT R.ref.value('@requestType', 'INT') FROM @i_xmlStr.nodes('/DM2ContentIndexing_EntityDetailsReq') R(ref)), 0)
DECLARE @getDisabled INT = ISNULL((SELECT R.ref.value('@getDisabled','INT') from @i_xmlStr.nodes('DM2ContentIndexing_EntityDetailsReq') R(ref)), 0)
IF @requestType = 0
begin
IF @ruleType = 1 --Rule_type_by_Client
	begin
	/*
		DECLARE @cloudId INT
		DECLARE @solrUrl VARCHAR(MAX)
		--
		DECLARE @searchCloudUrl TABLE (t_cloudId INT, t_solrUrl NVARCHAR(2048))
		INSERT INTO @searchCloudUrl (t_cloudId)
		SELECT DISTINCT S.CloudId
		FROM DM2SearchServerCoreInfo S WITH (NOLOCK)
			INNER JOIN EntityProcessor EP WITH (NOLOCK) ON S.CloudId = EP.CloudID
		--get comma seperated solr url for multinode cloud  (eg. node1,node2,node3)
		DECLARE CallSPCursor CURSOR
			FOR SELECT t_cloudId  FROM @searchCloudUrl
		 OPEN CallSPCursor
			FETCH FROM CallSPCursor INTO @cloudId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SELECT @solrUrl =   isnull(@solrUrl + ', ','') + ServiceLink FROM DM2SearchServerCoreInfo WHERE CloudId = @cloudId
				UPDATE @searchCloudUrl
				SET t_solrUrl = @solrUrl
				WHERE t_cloudId = @cloudId
				SET @solrUrl=null
				FETCH FROM CallSPCursor INTO @cloudId
			END
			CLOSE CallSPCursor
			DEALLOCATE CallSPCursor
			*/
		--
		set @o_respXML = (SELECT
						(
						 	(SELECT
								ES.EntityRulerId AS '@entityRulerId',
								ES.EntityId AS '@entityId',
								ES.subClientId AS '@subclientId',
								ES.AppTypeId AS '@appTypeId',
								EP.nodeClientId AS '@nodeClientId',
								EP.cloudId AS '@cloudId',
								EP.ForwardRefTime AS '@forwardRefTime',
								EP.BackwardRefTime AS '@backwardRefTime',
								EP.ExtractingClientId AS '@extractingClientId',
								ES.flags AS '@flags',
								S.ServiceLink AS '@solrUrl'
								FROM EntitySelection ES WITH (NOLOCK)
								INNER JOIN EntityProcessor EP WITH (NOLOCK) ON ES.EntityRulerId = EP.EntityRulerId
								INNER JOIN DM2SearchServerCoreInfo S WITH(NOLOCK) ON S.ClientId = EP.NodeClientId AND S.CloudId = EP.CloudID
WHERE EP.ExtractingClientID = @eeClientId AND ES.Enabled = 1
								FOR XML PATH('entityDetails'), TYPE
							)
						)FOR XML PATH('EntityDetailsResp')
					)
	end
end
else if @requestType IN (1,2,3)	-- request from CA java layer and CA python layer
begin
	DECLARE @getALL BIT = 1
	DECLARE @policyId INT = 0
	DECLARE @ciPolicyId INT = 0
	DECLARE @dcPolicyID INT = ISNULL(( SELECT T.ref.value('@dcPolicyID', 'INT') FROM @i_xmlStr.nodes('/DM2ContentIndexing_EntityDetailsReq/eEDetailReq') T(ref)), 0)
	DECLARE @dcPlanID INT = ISNULL(( SELECT T.ref.value('@dcPlanID', 'INT') FROM @i_xmlStr.nodes('/DM2ContentIndexing_EntityDetailsReq/eEDetailReq') T(ref)), 0)
	DECLARE @dataSourceID INT = ISNULL(( SELECT T.ref.value('@dataSourceID', 'INT') FROM @i_xmlStr.nodes('/DM2ContentIndexing_EntityDetailsReq/eEDetailReq') T(ref)), 0)
    DECLARE @reqXML XML
	DECLARE @enableImageExtraction NVARCHAR(20) = 'false'
    DECLARE @isCAEnabled NVARCHAR(20) = 'false'
    DECLARE @pushOnlyMetadata NVARCHAR(20) = 'true'
    DECLARE @includeFilters NVARCHAR(MAX) = ''
    DECLARE @excludeFilters TABLE (path NVARCHAR(MAX) )
    DECLARE @outXML XML
    DECLARE @outXMLTable TABLE(xmlValue XML)
	DECLARE @entityDetails TABLE (EntityID int, EntityType int, ParentEntityID int, isSelected bit, AnnotatorXML XML)
	DECLARE @caCloudId INT = 0
	DECLARE @caClientId INT = 0
	DECLARE @caPortNo NVARCHAR(32) = ''
	DECLARE @caUrl NVARCHAR(255) = ''
	DECLARE @caconfig NVARCHAR(MAX) = ''
    DECLARE @caInstanceName NVARCHAR(32)
	DECLARE @mlEntityDetails TABLE (Counter_Id int IDENTITY(1,1) ,EntityId int , EntityType int, CAClientUsedInTraining int,CAPortUsedInTraining int)
	DECLARE @OCRLanguage INT=1
	DECLARE @propsTable TABLE (name NVARCHAR(MAX), value NVARCHAR(MAX))
	-- DECLARE @jobID INT = ISNULL(( SELECT T.ref.value('@jobID', 'INT') FROM @i_xmlStr.nodes('/DM2ContentIndexing_EntityDetailsReq/eEDetailReq') T(ref)), 0)
	-- policyId first precedence
	IF @dcPolicyID <> 0
	BEGIN
		SET @policyId = @dcPolicyID
	END
	ELSE IF @dcPlanID <> 0
	BEGIN
SELECT @policyId = ISNULL(dbo.AppPlanGetEntityValueV2(@dcPlanID,'Data classification policy',default),0) -- 'Data classification policy' - 'Data classification policy'
SELECT @ciPolicyId = ISNULL(dbo.AppPlanGetEntityValueV2(@dcPlanID,'Content Indexing Policy',default),0) -- 'Content Indexing Policy' - 'Content Indexing Policy'
SELECT @caCloudId = ISNULL(dbo.AppPlanGetEntityValueV2(@dcPlanID,'Content Analyzer Cloud Id',default),0) -- 'Content Analyzer Cloud Id' - 'Content Analyzer Cloud Id'
	END
	ELSE IF @dataSourceID <> 0
	BEGIN
		DECLARE @propertyID int
		SELECT @propertyID = PropertyID FROM SEProperty WHERE PropertyName = 'dcplanid'
		SELECT @dcPlanID = PropertyValue FROM SEDataSourceProperty WHERE PropertyID = @propertyID AND DataSourceId = @dataSourceID
SELECT @policyId = ISNULL(dbo.AppPlanGetEntityValueV2(@dcPlanID,'Data classification policy',default),0) -- 'Data classification policy' - 'Data classification policy'
SELECT @ciPolicyId = ISNULL(dbo.AppPlanGetEntityValueV2(@dcPlanID,'Content Indexing Policy',default),0) -- 'Content Indexing Policy' - 'Content Indexing Policy'
SELECT @caCloudId = ISNULL(dbo.AppPlanGetEntityValueV2(@dcPlanID,'Content Analyzer Cloud Id',default),0) -- 'Content Analyzer Cloud Id' - 'Content Analyzer Cloud Id'
        IF @caCloudId = 0
        BEGIN
            SELECT @propertyID = PropertyID FROM SEProperty WHERE PropertyName = 'cacloudid'
            SELECT @caCloudId = PropertyValue FROM SEDataSourceProperty WHERE PropertyID = @propertyID AND DataSourceId = @dataSourceID
        END
	END
    IF @caCloudId <> 0
	BEGIN
		SELECT @caClientId = ClientId FROM DM2SearchServerCoreInfo where CloudId = @caCloudId and cloudType = 2
		SELECT @isCAEnabled = attrVal FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @caClientId AND attrName = 'contentPreviewEngineEnabled' and modified = 0
		SELECT @caInstanceName = attrVal FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @caClientId AND attrName = 'Galaxy Instance name' and modified = 0
		SELECT @caPortNo = ISNULL(attrVal, (CASE WHEN @caInstanceName = 'Instance001' THEN '22000' ELSE ('2200'+ SUBSTRING (@caInstanceName, LEN(@caInstanceName), LEN(@caInstanceName))) END)) FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @caClientId AND attrName = 'contentPreviewPort' and modified = 0
		SELECT @caUrl = 'http://' + net_hostName + ':' + @caPortNo FROM APP_Client (NOLOCK) WHERE id = @caClientId
	END
    	-- Get flag for extracting text from image (OCR)
	IF @ciPolicyId <> 0
	BEGIN
		SET @reqXML = (
							SELECT 30 AS '@propertyLevel',	-- ListPropertyLevels_AllProperties
							(
								SELECT
								(
									SELECT @ciPolicyId AS '@policyId' FOR XML PATH('policyEntity'), TYPE
								)
								FOR XML PATH('policy'), TYPE
							) FOR XML PATH('Ida_GetConfigurationPolicyReq'), TYPE
							)
		DELETE FROM @outXMLTable
		INSERT INTO @outXMLTable EXEC AppConfigurationPolicyGet @i_xmlString = @reqXML
		SELECT @outXML = xmlValue FROM @outXMLTable
		SET @enableImageExtraction = ISNULL((SELECT m.c.value('@enableImageExtraction','nvarchar(20)') from @outXML.nodes('Ida_GetConfigurationPolicyResp/policies/detail/ciPolicy') as m(c)),'false')
		SET @OCRLanguage = ISNULL((SELECT m.c.value('@val','int') from @outXML.nodes('Ida_GetConfigurationPolicyResp/policies/detail/ciPolicy/ocrLanguages') as m(c)), 1)
		SET @pushOnlyMetadata = CASE WHEN ISNULL((SELECT m.c.value('@opType','int') from @outXML.nodes('Ida_GetConfigurationPolicyResp/policies/detail/ciPolicy') as m(c)), 1) = 1 then 'true'
										ELSE 'false' END
		SET @includeFilters = ISNULL((SELECT m.c.value('@includeDocTypes','nvarchar(MAX)') from @outXML.nodes('Ida_GetConfigurationPolicyResp/policies/detail/ciPolicy/filters/fileFilters') as m(c)),'')
        INSERT INTO @excludeFilters
        SELECT m.c.value('@val','nvarchar(MAX)') from @outXML.nodes('Ida_GetConfigurationPolicyResp/policies/detail/ciPolicy/filters/fileFilters/excludePaths') as m(c)
	END
	ELSE IF @dataSourceID <> 0
	BEGIN
		SELECT @caconfig = PropertyValue FROM SEDataSourceProperty WHERE PropertyID IN(SELECT PropertyID FROM SEProperty WHERE PropertyName =  'caconfig') AND DataSourceId = @dataSourceID
		SELECT @pushOnlyMetadata = PropertyValue FROM SEDataSourceProperty WHERE PropertyID IN(SELECT PropertyID FROM SEProperty WHERE PropertyName =  'pushOnlyMetadata') AND DataSourceId = @dataSourceID
		SELECT @enableImageExtraction = PropertyValue FROM SEDataSourceProperty WHERE PropertyID IN(SELECT PropertyID FROM SEProperty WHERE PropertyName =  'enableImageExtraction') AND DataSourceId = @dataSourceID
		SELECT @includeFilters = PropertyValue FROM SEDataSourceProperty WHERE PropertyID IN(SELECT PropertyID FROM SEProperty WHERE PropertyName =  'includefilters') AND DataSourceId = @dataSourceID
	END
	IF @policyId <> 0
	BEGIN
		SET @getAll = 0
		SET @reqXML = (
								SELECT 30 AS '@propertyLevel',	-- ListPropertyLevels_AllProperties
								(
									SELECT
									(
										SELECT @policyId AS '@policyId' FOR XML PATH('policyEntity'), TYPE
									)
									FOR XML PATH('policy'), TYPE
								) FOR XML PATH('Ida_GetConfigurationPolicyReq'), TYPE
							  )
			-- get policydetails from policyId
			DELETE FROM @outXMLTable
			INSERT INTO @outXMLTable EXEC AppConfigurationPolicyGet @i_xmlString = @reqXML
			SELECT @outXML = xmlValue FROM @outXMLTable
IF @requestType IN (1,2)
			BEGIN
			DECLARE @entityDetailsXML XML
			SET @entityDetailsXML = (
									SELECT(
										SELECT T.ref.query('entityDetail') from @outXML.nodes('Ida_GetConfigurationPolicyResp/policies/detail/eePolicy/extractionPolicy/extractionPolicyList/tags') T(ref) FOR XML PATH(''), TYPE
										)
										FOR XML PATH('entityDetails'), TYPE
									)
			INSERT INTO @entityDetails
			SELECT T.ref.value('@entityId', 'int'),
				   T.ref.value('@entityType', 'int'),
				   NULL,
				   1,
				   NULL
				   FROM @entityDetailsXML.nodes('entityDetails/entityDetail') T(ref)
			-- get entitytype and parentEntityId for each entityId
			MERGE @entityDetails ET
			USING EntityAnnotator EA
			ON ET.EntityId=EA.EntityId AND EA.Enabled = 1
			WHEN MATCHED THEN
			UPDATE SET ET.EntityType = EA.EntityType, ET.ParentEntityID = EA.ParentEntityId,ET.AnnotatorXML = EA.AnnotatorXML
			WHEN NOT MATCHED BY SOURCE THEN
			DELETE;
			-- insert parent entites in the list again
			INSERT INTO @entityDetails
			SELECT EA.EntityId, EA.EntityType, EA.ParentEntityID, 0,EA.AnnotatorXML FROM EntityAnnotator EA, @entityDetails ED WHERE ED.ParentEntityID IS NOT NULL AND EA.EntityID = ED.ParentEntityID AND EA.EntityID <> ED.EntityID
			-- special case for ML entity to setup tppm entries requestType = 2 (CE request)
IF @requestType = 2
			 BEGIN
				INSERT INTO @mlEntityDetails(EntityId,EntityType,CAClientUsedInTraining,CAPortUsedInTraining)
				SELECT ED.EntityID,ED.EntityType,  p.value('@clientId', 'int'),0 FROM @entityDetails ED
				CROSS APPLY ED.AnnotatorXML.nodes('/entityXML/classifierDetails/CAUsedInTraining') t(p)
where ED.EntityType = 4
			IF EXISTS(SELECT TOP 1 1 FROM @mlEntityDetails)
				BEGIN
					UPDATE M
					SET CAPortUsedInTraining = S.Portno
					FROM @mlEntityDetails M
					JOIN DM2SearchServerCoreInfo S WITH(NOLOCK) ON M.CAClientUsedInTraining = S.ClientId
WHERE S.CloudType = 2
					DECLARE @mlEntityCount int;
					SELECT @mlEntityCount = COUNT(*) from @mlEntityDetails;
					DECLARE @counter INT;
					SET @counter = 1;
					WHILE @counter <= @mlEntityCount
						BEGIN
						DECLARE @toClientID int;
						DECLARE @toPortNo int;
							SELECT @toClientID = (SELECT CAClientUsedInTraining FROM @mlEntityDetails where Counter_Id=@counter)
							SELECT @toPortNo = (SELECT CAPortUsedInTraining FROM @mlEntityDetails where Counter_Id=@counter)
							IF @caClientId <> @toClientID
								BEGIN
									IF NOT EXISTS (SELECT TOP 1 1 FROM APP_FirewallTPPM
WHERE tppmType=9
AND fromEntityType=3
										AND fromEntityId=@caClientId
										AND fromPortNumber=0
AND toEntityType=3
										AND toEntityId=@toClientID
										AND toPortNumber=@toPortNo
										AND tppmParams=''
										AND status=1)
											BEGIN
EXEC AppSetFirewallTPPM @i_tppmType = 9,@i_fromEntityType =3, @i_fromEntityId=@caClientId,@i_fromPortNumber=0,
@i_toEntityType=3,@i_toEntityId=@toClientID,@i_toPortNumber=@toPortNo,@i_tppmParams=''
											END
								END
							SET @counter = @counter + 1
						END
				END
			 END
			END
	END
	-- in case, we found policyDetails and requestType is 1 (from python layer)
	-- in case of requestType 2 (CE layer) and we had some planId or dataSourceId return the actual output
	-- this is to avoid returning all the entities in case plan got deleted
	-- (EERequestType.REGULAREXP = 1, EERequestType.ENTITIES = 2)
IF  (@requestType = 1 AND @getALL <> 1) or (@requestType = 2 AND (@dcPolicyID <> 0 or @dcPlanID <> 0 or @dataSourceID <> 0))
	BEGIN
			INSERT INTO @propsTable values ('ocrLanguage', @OCRLanguage)
			SET @o_respXML = (
								SELECT @enableImageExtraction AS '@enableImageExtraction', --Setting the image Extraction flag (OCR)
									(
											SELECT	name as '@name',
													value as '@value'
											FROM @propsTable FOR XML PATH('nameValues')
											, ROOT('planProperties'), TYPE
									),
									(
											SELECT  ED.EntityID AS '@entityId',
												    ED.EntityType AS '@entityType',
												    ED.ParentEntityID AS '@parentEntityId',
												    ED.isSelected AS '@isSelected',
CASE WHEN @requestType = 1 THEN EA.Name ELSE NULL END AS '@entityName',
CASE WHEN @requestType = 1 THEN EA.RegularExpression ELSE NULL END AS '@regularExpression',
													EA.EntityKey AS '@entityKey',
													EA.flags AS '@flags',
CASE WHEN (@requestType = 1 OR EA.EntityType=4) THEN (SELECT EA.AnnotatorXML AS 'entityXML') ELSE NULL END
												   FROM @entityDetails ED INNER JOIN EntityAnnotator EA ON EA.EntityID = ED.EntityID
												   FOR XML PATH('entityDetails'), TYPE
									) FOR XML PATH('EntityDetailsResp'), TYPE
							 )
	END
ELSE IF @requestType in (1,2) AND @getALL = 1 -- (EERequestType.REGULAREXP = 1, EERequestType.ENTITIES = 2)
	BEGIN
		set @o_respXML = (SELECT
	                    (
	                        (SELECT
	                            EA.EntityId AS '@entityId',
		                        EA.EntityType AS '@entityType',
	                            EA.Name AS '@entityName',
	                            EA.RegularExpression AS '@regularExpression',
				    EA.flags AS '@flags',
				    EA.ParentEntityID AS '@parentEntityId',
					EA.EntityKey AS '@entityKey',
				    (SELECT EA.AnnotatorXML AS 'entityXML')
	                            FROM EntityAnnotator EA WITH (NOLOCK) WHERE (EA.Enabled = 1 or @getDisabled = 1)
	                            FOR XML PATH('entityDetails'), TYPE
	                        )
	                    )FOR XML PATH('EntityDetailsResp')
							 )
	END
ELSE IF @requestType = 3 -- (EERequestType.PLANDETAILS = 3)
	BEGIN
        INSERT INTO @propsTable values ('iscaenabled', @isCAEnabled)
        INSERT INTO @propsTable values ('catargeturl', @caUrl)
        INSERT INTO @propsTable values ('pushonlymetadata', @pushOnlyMetadata)
        INSERT INTO @propsTable values ('includefilters', @includeFilters)
		INSERT INTO @propsTable values ('caconfig', @caconfig)
		INSERT INTO @propsTable values ('caclientid', @caClientId)
		INSERT INTO @propsTable values ('ocrLanguage', @OCRLanguage)
		SET @o_respXML = (
			SELECT @enableImageExtraction AS '@enableImageExtraction', --Setting the image Extraction flag (OCR)
				(
						SELECT name as '@name',
								value as '@value'
						FROM @propsTable FOR XML PATH('nameValues')
						, ROOT('planProperties'), TYPE
				)
				FOR XML PATH('EntityDetailsResp')
			)
	END
end
select @o_respXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetEntityExtractorInfo')
	delete from GxQscripts where name = 'GetEntityExtractorInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetEntityExtractorInfo')
	delete from GXDBVersions where aliasname = 'GetEntityExtractorInfo'
GO

insert into GXDBVersions values(2, 'GetEntityExtractorInfo',  'v1.6.2.31.8.1', 'GetEntityExtractorInfo', 'v1.6.2.31.8.1')
GO

