

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetEntitiesForEE.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetEntitiesForEE.sp,v $ $Id: GetEntitiesForEE.sp,v 1.1.6.9 2020/09/19 04:45:15 smukherjee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetEntitiesForEE')
BEGIN
	print '>>> Drop Stored Procedure: GetEntitiesForEE <<<'
	drop procedure GetEntitiesForEE
END
IF EXISTS (select * from GxQscripts where name='GetEntitiesForEE')
	delete from GxQscripts where name = 'GetEntitiesForEE'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetEntitiesForEE')
	delete from GXDBVersions where aliasname = 'GetEntitiesForEE'
GO
print '... Creating Procedure: GetEntitiesForEE'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetEntitiesForEE
  @i_userId int,
  @i_entityId int = 0,
  @i_getDisabled bit = 0,
  @i_eeEntityType int = 0
AS
  SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  -- get data classfication containers for the user
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- adding tenant security
-- check if user belongs to a company
DECLARE @organizationId int = 0
DECLARE @DEFAULT_CUSTOM_CONTAINER_GUID nvarchar(40) = '22CD8879-B2FD-4A63-8096-B515FC13502D' -- default custom entity
DECLARE @custom_container_guid nvarchar(40) = @DEFAULT_CUSTOM_CONTAINER_GUID
DECLARE @dm2container_temp table(
    comment nvarchar(max),
    containerGuid nvarchar(40),
    containerId int,
    containerName nvarchar(max),
    containerType   int
)
SELECT @organizationId = dbo.AppGetOrganizationForUser(@i_userId)
IF @organizationId <> 0 AND EXISTS(SELECT 1 FROM UMDSProviders WHERE serviceType = 5) -- UMDS_PROVIDER_ORGANIZATIONS
BEGIN
	IF OBJECT_ID('tempdb.dbo.#UserHasPermissionOnEntity_temp') IS NOT NULL
        DROP TABLE #UserHasPermissionOnEntity_temp
    CREATE TABLE #UserHasPermissionOnEntity_temp(entityId int)
EXEC dbo.sec_getNonIdaObjectsForThisUser @i_userId, 9517, 0, '#UserHasPermissionOnEntity_temp'
    SELECT TOP 1 @custom_container_guid = containerGuid FROM DM2Container DC INNER JOIN #UserHasPermissionOnEntity_temp UTEMP ON DC.containerId = UTEMP.entityId
    IF @custom_container_guid = @DEFAULT_CUSTOM_CONTAINER_GUID -- in case no custom container exists for the tenant yet, avoid showing global custom container entities
        SET @custom_container_guid = ''
END
-- get containers where user have permissions
INSERT INTO @dm2container_temp
SELECT comment, containerGuid, containerId, containerName, containerType
FROM DM2Container
WHERE containerType IN (9516, 9520) OR (containerType = 9517 and @custom_container_guid = CAST(containerGuid AS NVARCHAR(256)))
-- drop the custom parent container if no custom entity exists for the user
IF @custom_container_guid = ''
DELETE FROM @dm2container_temp WHERE containerGuid = 'B05D1D67-FCE2-493B-A7F4-5400938EAF70' AND containerType=9520
  DECLARE @o_respXML XML = ''
  SET @o_respXML = (SELECT
		(
			(
				SELECT
					EA.EntityId AS '@entityId',
					EA.ParentEntityID AS '@parentEntityId',
					EA.Flags AS '@flags',
					EA.Name As '@entityName',
					EA.Enabled AS '@enabled',
					EA.EntityKey AS '@entityKey',
					EA.Attribute AS '@attribute',
					EA.EntityType AS '@entityType',
					EA.Description AS '@description',
					CASE WHEN @i_entityId <> 0 THEN EA.RegularExpression ELSE NULL END AS'@regularExpression',
					DC.comment AS '@categoryName',
					DT.TagDesc AS '@displayName',
					DATEDIFF(SECOND,{d '1970-01-01'},EA.CreateTime) AS '@createdTime',
					(SELECT AnnotatorXML AS 'entityXML' )
				FROM EntityAnnotator EA
				INNER JOIN DM2DocTags DT ON CAST(EA.EntityID as nvarchar(512)) = ISNULL(DT.TagValue,'0')
							AND (EA.Enabled = 1 OR @i_getDisabled = 1)
							AND (@i_entityID = 0 OR EntityID = @i_entityID)
				INNER JOIN @dm2container_temp DC ON DC.containerGuid = DT.containerGuid
				where (@i_eeEntityType=0 OR EA.EntityType=@i_eeEntityType)
				FOR XML PATH('entityDetails'), TYPE
			)
		)
		FOR XML PATH('EntityDetailsResp'))
select @o_respXML
GO

IF EXISTS (select * from GxQscripts where name = 'GetEntitiesForEE')
	delete from GxQscripts where name = 'GetEntitiesForEE'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetEntitiesForEE')
	delete from GXDBVersions where aliasname = 'GetEntitiesForEE'
GO

insert into GXDBVersions values(2, 'GetEntitiesForEE',  '00010001000600090000', 'GetEntitiesForEE', '00010001000600090000')
GO

