

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetEntitiesBySensitivity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetEntitiesBySensitivity <<<'

IF EXISTS (select * from sysobjects where name='GetEntitiesBySensitivity')
	drop procedure GetEntitiesBySensitivity
IF EXISTS (select * from GxQscripts where name='GetEntitiesBySensitivity')
	delete from GxQscripts where name = 'GetEntitiesBySensitivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetEntitiesBySensitivity')
	delete from GXDBVersions where aliasname = 'GetEntitiesBySensitivity'
GO
print '... Creating Procedure: GetEntitiesBySensitivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetEntitiesBySensitivity
AS
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	declare @sensitivity table (
		Entities nvarchar(1024),
		SensitivityType	int
	)
	declare @high nvarchar(1024) = null
	select @high = COALESCE(@high+',' , '') + EntityKey from EntityAnnotator where Flags=5 and ISNULL(EntityKey,'') <> ''
	insert into @sensitivity
	SELECT @high, 1
	declare @moderate nvarchar(1024) = null
	select @moderate = COALESCE(@moderate+',' , '') + EntityKey from EntityAnnotator where Flags=3 and ISNULL(EntityKey,'') <> ''
	insert into @sensitivity
	SELECT @moderate, 2
	declare @low nvarchar(1024) = null
	select @low = COALESCE(@low+',' , '') + EntityKey from EntityAnnotator where Flags=1 and ISNULL(EntityKey,'') <> ''
	insert into @sensitivity
	SELECT @low, 3
	declare @outXML xml
	SET @outXML = (
					select (
							   select ISNULL(Entities,'') as '@entities',
							   SensitivityType as '@sensitivityType'
							   from @sensitivity
							   for xml path('sensitiveEntities'), type
							)
						for xml path('EntitiesBySensitivity')
				  )
	select @outXML
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetEntitiesBySensitivity')
	delete from GxQscripts where name = 'GetEntitiesBySensitivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetEntitiesBySensitivity')
	delete from GXDBVersions where aliasname = 'GetEntitiesBySensitivity'
GO

insert into GXDBVersions values(2, 'GetEntitiesBySensitivity',  '00000000000000000000', 'GetEntitiesBySensitivity', '00000000000000000000')
GO

