

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDocumentationLink.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetDocumentationLink.sp,v $ $Id: GetDocumentationLink.sp,v 1.1.4.5 2018/07/28 04:58:52 anarde Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "GetDocumentationLink"                                   |
-- 	+-----------------------------------------------------------------------+
--  Note: 10/30/2006 -Skatz	  Do not believe we want to pull in UMDSUserGroup tables into
--                            this list. This should only be called for "local" users anyway!
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetDocumentationLink <<<'

IF EXISTS (select * from sysobjects where name='GetDocumentationLink')
	drop procedure GetDocumentationLink
IF EXISTS (select * from GxQscripts where name='GetDocumentationLink')
	delete from GxQscripts where name = 'GetDocumentationLink'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDocumentationLink')
	delete from GXDBVersions where aliasname = 'GetDocumentationLink'
GO
print '... Creating Procedure: GetDocumentationLink'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetDocumentationLink
  @use_iis_server INTEGER = 1
AS
  DECLARE @doclink nvarchar(max) = ''
declare @release int
declare @highestSp int
SET NOCOUNT ON
    SELECT distinct top 1 @release = g.release, @highestSp = HighestSP
    FROM simInstalledPackages s (nolock)
    INNER JOIN APP_CLIENT c (nolock) ON s.ClientId = c.id
    INNER JOIN simAllGalaxyRel g (nolock) ON g.id = c.releaseId
    WHERE ClientId =2
	order by g.release, HighestSP
IF @use_iis_server = 1 AND EXISTS(SELECT * FROM GXGlobalParam WHERE name = 'IIS Server selected' AND value = 1  and modified = 0)
        SELECT @doclink = ISNULL(value,'') FROM GXGlobalParam WHERE name = 'IIS Server name'  and modified = 0
    ELSE
    BEGIN
		SELECT @doclink = ISNULL(value,'') FROM GXGlobalParam WHERE name ='LinkToDocumentationWebSite' and modified = 0
		SET @doclink = Concat(@doclink, '/v', @release, '_sp', @highestSp, '/article')
    END
    SELECT @doclink AS docLink
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetDocumentationLink')
	delete from GxQscripts where name = 'GetDocumentationLink'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDocumentationLink')
	delete from GXDBVersions where aliasname = 'GetDocumentationLink'
GO

insert into GXDBVersions values(2, 'GetDocumentationLink',  '00010001000400050000', 'GetDocumentationLink', '00010001000400050000')
GO

