

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDependentJobsToRetain.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: PavanKumar Veeravalli
--	Date:   6/26/2015
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetDependentJobsToRetain.sp";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetDependentJobsToRetain <<<'

IF EXISTS (select * from sysobjects where name='GetDependentJobsToRetain')
	drop procedure GetDependentJobsToRetain
IF EXISTS (select * from GxQscripts where name='GetDependentJobsToRetain')
	delete from GxQscripts where name = 'GetDependentJobsToRetain'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDependentJobsToRetain')
	delete from GXDBVersions where aliasname = 'GetDependentJobsToRetain'
GO
print '... Creating Procedure: GetDependentJobsToRetain'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetDependentJobsToRetain
  @i_jobId INTEGER,
  @i_commCellId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @o_jobId INTEGER
  DECLARE @o_commCellId INTEGER
  DECLARE @o_appId INTEGER
  DECLARE @o_appTypeId INTEGER
  DECLARE @o_opType INTEGER
  DECLARE @o_backupLevel INTEGER
  DECLARE @o_attributes BIGINT
  DECLARE @o_startDate INTEGER
  DECLARE @o_endDate INTEGER
  DECLARE @o_sizeOfApp BIGINT
  DECLARE @o_sizeOnMedia BIGINT
  DECLARE @o_status INTEGER
  DECLARE @o_disabled INTEGER
  DECLARE @o_flags INTEGER
  DECLARE @o_retentionEndTime BIGINT
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
if (OBJECT_ID('tempdb.dbo.#tempJobData') IS NOT NULL) DROP TABLE #tempJobData
if (OBJECT_ID('tempdb.dbo.#tempJobRetention') IS NOT NULL) DROP TABLE #tempJobRetention
DECLARE @t_appId        INT
DECLARE @isArchiverAppTypeId              INT
DECLARE @t_backupLevel  INT
DECLARE @t_startDate    INT
DECLARE @t_clientId INT
DECLARE @t_cycleSequence INT
DECLARE @t_fullCycleNum INT
DECLARE @t_TimeZoneType INT
DECLARE @t_TimeZone     VARCHAR(255)
DECLARE @t_csTimeZone VARCHAR(255)
DECLARE @regularAge INT
DECLARE @archiverAge INT
DECLARE @retentionJobs INT
SET     @t_csTimeZone = dbo.GetClientTimeZone(2)
CREATE TABLE #tempJobData  (
        jobId INT,
        commCellId INT,
        appId INT,
        appType INT,
        optype INT,
        backupLevel INT,
        attributes BIGINT,
        startDate INT,
        endDate INT,
        sizeOfApp BIGINT,
        sizeOnMedia BIGINT,
        status INT,
        disabled INT,
        flags INT,
        extRetentionFlags INT,
        retentionDays BIGINT,
        retentionJobs INT,
        retentionEndTime bigint
        )
CREATE TABLE #tempJobRetention
       (
	    jobID int,
        commCellId int,
        manualRetentionEndTime bigint
       )
DECLARE  @tblCopyCount TABLE
       (
            jobId INT,
            commCellId INT,
            dataType INT,
            copyCount INT
	   )
SELECT  @t_appId = appId, @t_startDate = servStartDate,@t_cycleSequence = cyclesequence ,@t_fullCycleNum = fullCycleNum, @t_backupLevel = bkpLevel
FROM    JMBkpStats WITH (NOLOCK)
WHERE   jobId = @i_jobId AND commCellId = @i_commCellId
SELECT @t_ClientId = app.clientId, @isArchiverAppTypeId = ISNULL(AppInfo.isDMAppType, 0) From app_application AS app WITH (NOLOCK) LEFT OUTER JOIN APP_IDATypeHandlingInfo AppInfo WITH(NOLOCK)
ON app.appTypeId = AppInfo.appTypeId
WHERE @t_appid = App.id
SELECT  @regularAge = retentionDays, @archiverAge = archiverRetDays
FROM    archAgingRule WITH (NOLOCK)
WHERE   copyId = @i_copyId
--Get all backup jobs that created archive files (to skip jobs like backup copy jobs)
INSERT  INTO #tempJobData
SELECT  jobId, commCellId, appId, appType, opType, bkpLevel, bkpAttributes, servStartDate, servEndDate, totalUncompBytes, 0, 0, 0, 0, 0,CASE WHEN @isArchiverAppTypeId = 1 THEN @archiverAge ELSE @regularAge END, 0, 0
FROM    JMBkpStats JBKP WITH (NOLOCK)
WHERE   appId = @t_appId AND status IN (1, 3, 14) AND  fullCycleNum = @t_fullCycleNum AND servStartDate<=@t_startDate -- AND cyclesequence <= @t_cycleSequence
AND  EXISTS(SELECT 1 FROM ArchFile AF WITH(NOLOCK) WHERE AF.jobId = JBKP.jobId AND AF.commCellId = JBKP.commCellId)
UPDATE  #tempJobData
SET     flags = (flags | 2)
WHERE NOT EXISTS(SELECT 1 FROM JMBkpStats WITH(NOLOCK) WHERE appId = @t_appId AND fullCycleNum > @t_fullCycleNum AND status IN(1, 3, 14))
INSERT  INTO @tblCopyCount
                SELECT  J.jobId, J.commCellId, J.dataType, COUNT(DISTINCT J.archGrpCopyId)
                FROM   #tempJobData T, JMJobDataStats J WITH(NOLOCK)
WHERE J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.status = 100 AND (J.disabled & 256) = 0
                GROUP BY J.jobId, J.commCellId, J.dataType
UPDATE   #tempJobData
SET   flags = (flags | 1)
                FROM   #tempJobData A, (SELECT            jobId, commCellId, MIN(copyCount) AS copyCount FROM @tblCopyCount GROUP BY jobId, commCellId) B
                WHERE A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.copyCount <= 1
UPDATE  #tempJobData
    SET     status  = (case when (B.minStatus = 100 and B.maxStatus = 101) then 103 else B.maxStatus end),
            disabled= B.disabled, sizeOnMedia = B.sizeOnMedia
    FROM    #tempJobData A,
            (SELECT J.jobId, J.commCellId,
                    MIN(J.status) AS minStatus, MAX(J.status) AS maxStatus, MAX(J.disabled) AS disabled, SUM(J.sizeOnMedia) AS sizeOnMedia
            FROM    #tempJobData T, JMJobDataStats J
            WHERE   J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = @i_copyId
AND (J.disabled & 256) = 0
            GROUP BY J.jobId, J.commCellId) B
    WHERE   A.jobId = B.jobId AND A.commCellId = B.commCellId
INSERT INTO #tempJobRetention
SELECT J.jobId,J.commCellId,MAX(J.manualRetentionEndTime)
FROM    JMJobDataStats J WITH (NOLOCK), #tempJobData T
    WHERE   J.jobId = T.jobId AND J.commCellId = T.commCellId
        AND J.archGrpCopyId = @i_copyId
        AND J.Status <> 1000    GROUP BY J.jobId, J.commCellId, J.appId
SELECT @t_TimeZone = CASE WHEN AG.TimeZoneType = 0 THEN @t_csTimeZone WHEN AG.TimeZoneType = 1 THEN dbo.GetClientTimeZone(@t_clientId) ELSE (CASE WHEN AG.TimeZone = '' THEN @t_csTimeZone ELSE AG.TimeZone END) END
FROM    archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
WHERE   AG.id = AGC.archGroupId AND AGC.id = @i_copyId
IF @regularAge >= 0 AND @isArchiverAppTypeId = 0
BEGIN
    CREATE  TABLE #tempAgingRulesExt(retentionDays INT, retentionRule INT)
    INSERT  INTO #tempAgingRulesExt
    SELECT  retentionDays, retentionRule
    FROM    archAgingRuleExtended WITH (NOLOCK)
    WHERE   copyId = @i_copyId
    IF @@ERROR = 0 AND @@ROWCOUNT > 0
    BEGIN
        DECLARE @l_ExtRetentionRuleSum  INT
        SELECT  @l_ExtRetentionRuleSum = SUM(retentionRule) FROM #tempAgingRulesExt
        UPDATE  #tempJobData
        SET     extRetentionFlags = (
                case
                when extRetentionFlags & (64|4096) <> 0 then 64
                when extRetentionFlags & (32|2048) <> 0 then 32
                when extRetentionFlags & (16|1024) <> 0 then 16
                when extRetentionFlags & (8 | 512) <> 0 then 8
               when extRetentionFlags & (4 | 256) <> 0 then 4
                when extRetentionFlags & (524288 | 8388608) <> 0 then 524288
                when extRetentionFlags & (262144 | 4194304) <> 0 then 262144
                when extRetentionFlags & 2 <> 0 then 2
                end)
        WHERE   extRetentionFlags & @l_ExtRetentionRuleSum <> 0
        UPDATE  #tempJobData
        SET     retentionDays = b.retentionDays
        FROM    #tempJobData a, #tempAgingRulesExt b
        WHERE   b.retentionRule = a.extRetentionFlags
                AND (b.retentionDays < 0 OR b.retentionDays > a.retentionDays)
    END
    DROP TABLE #tempAgingRulesExt
END
--Update retentionJobs for those appType and copy that honors Job Based Retention
IF EXISTS (SELECT copyId FROM archAgingRule AAR WITH (NOLOCK) WHERE AAR.copyId = @i_copyId AND (AAR.flags & 128) > 0)
BEGIN
    SELECT  @retentionJobs = AAR.retentionJobs
    FROM archAgingRule AAR WITH (NOLOCK)
    WHERE AAR.copyId = @i_copyId
AND (AAR.flags & 128) > 0
    UPDATE #tempJobData
    SET retentionJobs = @retentionJobs
    FROM    #tempJobData T, App_Application A WITH (NOLOCK)
    WHERE   T.appId = A.id
    AND     @retentionJobs > 0
    AND     A.appTypeId NOT IN (
                    SELECT appTypeId
                    FROM APP_IDATypeHandlingInfo
                    WHERE ignoreJobRetention = 1
                )
END
UPDATE   #tempJobData SET  retentionEndTime =  T.manualRetentionEndTime
        FROM #tempJobData J,#tempJobRetention T
                                WHERE J.jobId = T.jobId AND J.commCellId = T.commCellId
UPDATE  #tempJobData
SET     retentionEndTime = case when (A.retentionEndTime = 0 AND A.retentionJobs > 0) then -2
                                --when (A.retentionEndTime = 0 AND A.isDDBBackup > 0) then -2
                                when A.retentionDays < 0 then -1
                                when A.retentionEndTime >(A.startDate + A.retentionDays*24*3600) then A.retentionEndTime
                                else (A.startDate + A.retentionDays*24*3600) end
FROM    #tempJobData A
UPDATE  #tempJobData
SET   retentionEndTime = case  when retentionEndTime = -2 then -2
                              when retentionEndTime = -1 then -1
                              else retentionEndTime + dbo.GetDiffFromCSTimeZone(retentionEndTime, @t_TimeZone, @t_csTimeZone) end
FROM    #tempJobData J
WHERE   @t_TimeZone <> '' AND @t_TimeZone <> @t_csTimeZone
SELECT jobId , commCellId , appId , appType , optype , backupLevel , attributes ,
        startDate , endDate , sizeOfApp , sizeOnMedia , status , disabled , flags ,retentionEndTime FROM #tempJobData
if (OBJECT_ID('tempdb.dbo.#tempJobData') IS NOT NULL) DROP TABLE #tempJobData
if (OBJECT_ID('tempdb.dbo.#tempJobRetention') IS NOT NULL) DROP TABLE #tempJobRetention
GO

IF EXISTS (select * from GxQscripts where name = 'GetDependentJobsToRetain')
	delete from GxQscripts where name = 'GetDependentJobsToRetain'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDependentJobsToRetain')
	delete from GXDBVersions where aliasname = 'GetDependentJobsToRetain'
GO

insert into GXDBVersions values(2, 'GetDependentJobsToRetain',  '00000000000000000000', 'GetDependentJobsToRetain', '00000000000000000000')
GO

