

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDefaultAlrmTemplates.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Vibhor Mishra
--	Date:   03/31/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetDefaultAlrmTemplates.sp,v $ $Id: GetDefaultAlrmTemplates.sp,v 1.1.2.9 2020/01/27 19:14:17 dkraplanee Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetDefaultAlrmTemplates')
BEGIN
	print '>>> Drop Stored Procedure: GetDefaultAlrmTemplates <<<'
	drop procedure GetDefaultAlrmTemplates
END
IF EXISTS (select * from GxQscripts where name='GetDefaultAlrmTemplates')
	delete from GxQscripts where name = 'GetDefaultAlrmTemplates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDefaultAlrmTemplates')
	delete from GXDBVersions where aliasname = 'GetDefaultAlrmTemplates'
GO
print '... Creating Procedure: GetDefaultAlrmTemplates'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetDefaultAlrmTemplates
  @i_userId INT = NULL,
  @i_commcellID INT = NULL,
  @i_ccGroupId INT = NULL,
  @i_companyId INT = NULL,
  @i_isPublic INT = NULL,
  @i_version nvarchar(255) = NULL
AS
  DECLARE @o_responseXML XML;
BEGIN
SET NOCOUNT ON
    DECLARE @o_errorCode INT = 0
    DECLARE @o_errorMessage NVARCHAR(1024) = ''
	DECLARE @hexcommcellID VARCHAR(32) = dbo.ConvertBigIntToHexStr(@i_commcellID)
	SET @i_commcellID = CASE WHEN @i_commcellID <= 0 THEN -1 ELSE @i_commcellID END
	SET @i_ccGroupId = CASE WHEN @i_ccGroupId <= 0 THEN -1 ELSE @i_ccGroupId END
	SET @i_companyId = CASE WHEN @i_companyId <= 0 THEN -1 ELSE @i_companyId END
	IF OBJECT_ID('tempdb..#templatesList') IS NOT NULL DROP TABLE #templatesList
	CREATE TABLE #templatesList
	(
		templateId INT,
		templateName nvarchar(512),
		templateDesc nvarchar(max),
		alarmId		INT,
		isDisabled	INT,
		orderId		INT,
		templateFlags	INT
	)
	INSERT INTO #templatesList
	SELECT T.templateId,
			T.templateName,
			T.templateDesc ,
			ISNULL(A.AlarmId,-1) ,
			ISNULL(A.flags,-1),
			priority,
			T.flags
	FROM CustomAlarmTemplates T
		LEFT OUTER JOIN CustomAlarmProps A
			ON A.userId = @i_userId AND ISNULL(A.extendedProps.value('(alarmProps/@templateId)[1]', 'INT'), -1) = T.templateId
													-- To handle case of existing default alerts that used commcellId instead of commservUniqueId
				AND ((@i_commcellID <> -1 AND @i_commcellID = ISNULL(A.extendedProps.value('(alarmProps/@commUniId)[1]', 'INT'),ISNULL(A.extendedProps.value('(/alarmProps/commcellInfo/@commCellId)[1]','INT'), -1)))
						OR (@i_ccGroupId <> -1 AND @i_ccGroupId = ISNULL(A.extendedProps.value('(alarmProps/@ccGroupId)[1]', 'INT'), -1))
						OR (@i_companyId <> -1 AND @i_companyId = ISNULL(A.extendedProps.value('(alarmProps/@companyId)[1]', 'INT'), -1))
						OR T.flags & 2 = 2)
	WHERE ((ISNULL(@i_commcellID,-1) = -1 AND ISNULL(@i_ccGroupId,-1) = -1 AND ISNULL(@i_companyId,-1) = -1 AND T.flags & 2 = 2) -- for T.flags, check CustomAlarmTemplates.script file
		OR ((ISNULL(@i_commcellID,-1) > 0 AND T.flags & 4 = 4)
				OR (ISNULL(@i_ccGroupId,-1) > 0 AND T.flags & 8 = 8)
				OR (ISNULL(@i_companyId,-1) > 0 AND T.flags & 16 = 16)))
		AND T.flags & 1 <> 1 -- Don't show hidden templates
		AND (ISNULL(@i_isPublic,0) = 0 OR (ISNULL(@i_isPublic,0) = 1 AND T.templateId NOT IN (10, 13, 16)))	-- Exclude Disk Lib, DDB, Index cache from being shown on public cloud's worldwide dashboard
	-- Delete "Commcell is down" alert as its not valid for version 9 and 10 commcells on Public cloud where this alert is created on SignalR Connection time.
	IF @i_isPublic > 0 AND @i_commcellID > 0 AND (@i_version LIKE '9.0%' OR @i_version LIKE '10%')
	BEGIN
		DELETE FROM #templatesList
WHERE templateId = 5			-- "Commcell is down" alert for Individual Commcell Monitoring form
	END
	-- Delete private only alerts if this is a public setup.
	IF @i_isPublic > 0
	BEGIN
		DELETE FROM #templatesList
		WHERE templateFlags & 32 = 32			-- fifth bit -> for private only
	END
	DECLARE @templates XML = (SELECT T.templateId AS '@templateId',
									T.templateName AS '@templateName',
									T.templateDesc AS '@templateDesc',
									T.alarmId AS '@alarmId',
									isDisabled AS '@isDisabled'
							FROM #templatesList T
							ORDER BY T.orderId
		FOR XML PATH('alarmTemplate'),TYPE)
EXIT_PROC:
    set @o_responseXML = (SELECT
            @o_errorCode AS 'errorResponse/@errorCode',
            @o_errorMessage AS 'errorResponse/@errorMessage',
			@templates
    FOR XML PATH(''), ROOT('CVGui_AlarmTemplateResp'))
    select @o_responseXML as o_responseXML
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetDefaultAlrmTemplates')
	delete from GxQscripts where name = 'GetDefaultAlrmTemplates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDefaultAlrmTemplates')
	delete from GXDBVersions where aliasname = 'GetDefaultAlrmTemplates'
GO

insert into GXDBVersions values(2, 'GetDefaultAlrmTemplates',  '00010001000200090000', 'GetDefaultAlrmTemplates', '00010001000200090000')
GO

