

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDataPathMediaAgentsList.sp] ---------- 

--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetDataPathMediaAgentsList.sp,v $ $Id: GetDataPathMediaAgentsList.sp,v 1.1.2.2 2020/12/10 06:57:10 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE: "GetDataPathMediaAgentsList"                             |
--  |                                                                       |
--  | Execute the System stored procedure to fcheck the job and later job   |
--  | indexed                                                               |
--  +-----------------------------------------------------------------------+
/*
Input XML format
<MediaManager_GetDataPathMediaAgentsListReq>
<spCopy _type_="18" copyId="4" storagePolicyId="3"/>
<app _type_="7" applicationId="5"/>
</MediaManager_GetDataPathMediaAgentsListReq>
Output XML format
<MediaManager_GetDataPathMediaAgentsListResp errorCode="-1" errorString="Error string">
	<mediaAgentsList _type_="11" mediaAgentId="1" mediaAgentName="MAName1"/>
	<mediaAgentsList _type_="11" mediaAgentId="2" mediaAgentName="MAName2"/>
</MediaManager_GetDataPathMediaAgentsListResp>
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetDataPathMediaAgentsList')
BEGIN
	print '>>> Drop Stored Procedure: GetDataPathMediaAgentsList <<<'
	drop procedure GetDataPathMediaAgentsList
END
IF EXISTS (select * from GxQscripts where name='GetDataPathMediaAgentsList')
	delete from GxQscripts where name = 'GetDataPathMediaAgentsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDataPathMediaAgentsList')
	delete from GXDBVersions where aliasname = 'GetDataPathMediaAgentsList'
GO
print '... Creating Procedure: GetDataPathMediaAgentsList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetDataPathMediaAgentsList
  @i_XML XML OUTPUT
AS
DECLARE @copyId INTEGER = 0
DECLARE @spId INTEGER = 0
DECLARE @appId INTEGER = 0
DECLARE @errorCode INTEGER = 0
DECLARE @errorString VARCHAR(1024) = ''
IF @i_XML.exist('/MediaManager_GetDataPathMediaAgentsListReq') = 1
BEGIN
    SELECT @copyId = ISNULL(T.item.value('@copyId','INT'),0), @spId = ISNULL(T.item.value('@storagePolicyId','INT'),0)
            FROM @i_XML.nodes('/MediaManager_GetDataPathMediaAgentsListReq/spCopy') T(item)
	SELECT @appId = ISNULL(T.item.value('@subclientId','INT'),0)
            FROM @i_XML.nodes('/MediaManager_GetDataPathMediaAgentsListReq/app') T(item)
END
IF @copyId = 0 AND @spId = 0
BEGIN
	IF @appId <> 0
	BEGIN
		SELECT @spId = dataArchGrpId FROM APP_Application WITH (NOLOCK) WHERE id = @appId
	END
	IF @spId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid input. Provide valid StoragePolicy\Copy\Subclient id.'
		GOTO END_EXIT
	END
END
if object_id('tempdb.dbo.#DataPathListForSPCopy') is not null DROP TABLE #DataPathListForSPCopy
    create table #DataPathListForSPCopy
	(
		DataPathId            integer,
		MAId                  integer,
MAName                nvarchar(255),
		MAReleaseId           integer,
hostName              nvarchar(255),
		libId                 integer,
libName               nvarchar(255),
		libType               integer,
		masterPoolId          integer,
masterPoolName        nvarchar(255),
		drivePoolId           integer,
		drivePoolTypeId       integer,
		mountPathTypeId       integer,
drivePoolName         nvarchar(255),
		DataPathFlag          integer,
		spareGroupId          integer,
spareGroupName        nvarchar(255),
		IdxCacheId            integer,
IdxCacheName          nvarchar(255),
		FlushBlockSizeKB      integer,
		ChunkSizeMB           integer,
		HWCompression         integer,
clientInterface       nvarchar(255),
mediaAgentInterface   nvarchar(255),
		priority              integer,
		NoOfClientSubSelects  integer,
		HWEncryption          integer,
		hasNoData             integer,
		DeviceTypeId          integer
	)
	INSERT INTO #DataPathListForSPCopy
	EXEC MMS2getCopyFailOverConfig @spId, @copyId, 0, 0, 0
	SELECT Top 1 @errorCode = DataPathId FROM #DataPathListForSPCopy
	IF @errorCode = -1
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'No datapath specified in StoragePolicy\Copy.'
		GOTO END_EXIT
	END
	ELSE
	BEGIN
		SET @errorCode = 0  -- Resetting error code for success
	END
END_EXIT:
SET @i_XML =
    (
		SELECT @errorCode AS '@errorCode',
		@errorString AS '@errorString',
        (SELECT DISTINCT
				MAId AS '@mediaAgentId',
                MAName AS '@mediaAgentName'
        FROM    #DataPathListForSPCopy
        FOR XML PATH ('mediaAgentsList'), TYPE)
		FOR XML PATH ('MediaManager_GetMediaAgentsListResp'), TYPE
    )
IF OBJECT_ID('tempdb..#DataPathListForSPCopy') IS NOT NULL DROP TABLE #DataPathListForSPCopy
GO

IF EXISTS (select * from GxQscripts where name = 'GetDataPathMediaAgentsList')
	delete from GxQscripts where name = 'GetDataPathMediaAgentsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDataPathMediaAgentsList')
	delete from GXDBVersions where aliasname = 'GetDataPathMediaAgentsList'
GO

insert into GXDBVersions values(2, 'GetDataPathMediaAgentsList',  '00010001000200020000', 'GetDataPathMediaAgentsList', '00010001000200020000')
GO

