

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDashboard_TileInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetDashboard_TileInfo.sp,v $ $Id: GetDashboard_TileInfo.sp,v 1.1.2.16 2020/11/06 09:43:06 shubhamagrawal Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetDashboard_TileInfo')
BEGIN
	print '>>> Drop Stored Procedure: GetDashboard_TileInfo <<<'
	drop procedure GetDashboard_TileInfo
END
IF EXISTS (select * from GxQscripts where name='GetDashboard_TileInfo')
	delete from GxQscripts where name = 'GetDashboard_TileInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDashboard_TileInfo')
	delete from GXDBVersions where aliasname = 'GetDashboard_TileInfo'
GO
print '... Creating Procedure: GetDashboard_TileInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetDashboard_TileInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_userId INT,
  @Dashboard VARCHAR(20)
-----------------------------------------------------------
AS
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
	IF @Dashboard NOT IN ('SERVER','COMMCELL','APPLIANCE','APPLIANCECOMMCELL','ORCHESTRATION','TENANT','ENDPOINT')
	RETURN
 BEGIN TRY
	DECLARE @allAssociation int =0
	IF OBJECT_ID('Tempdb.dbo.#PropertyInfo') is not NULL
	DROP TABLE #PropertyInfo
	CREATE TABLE #PropertyInfo(PropertyType varchar(40),PropertyCount int,Ordering Int )
	 IF object_id('tempdb.dbo.#clientListTmp') is not null DROP TABLE #clientListTmp
	create table  #clientListTmp ( [capabilities]  bigint NOT null, [flag]      int NOT null default 0, [commCellId]    int NOT null default 2, [clientGroupId] int NOT null default 0, [clientId]      int NOT null default 0, [appTypeId]     int NOT null default 0, [instanceId]    int NOT null default 0, [backupsetId]   int NOT null default 0, [subClientId]   int NOT null default 0, [mediaAgentId]  int NOT null default 0, [libraryId]     int NOT null default 0, [archGroupId]   int NOT null default 0, [vtContainerId] int NOT null default 0, [vtPolicyId]    int NOT null default 0, [vtShelfId]     int NOT null default 0, [reviewSetId]   int NOT null default 0, [querySetId]    int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId]       int NOT null default 0, [legalHoldId]   int NOT null default 0, [tagId]     int NOT null default 0, [cdPolicyId]    int NOT null default 0, [complianceReportId]   int  NOT null default 0, [taskId]        int NOT null default 0, [workflowId]    int NOT null default 0, [logMonitoringPolicyId] int NOT null default 0, [arrayId]       int NOT null default 0, [cloudId]       int NOT null default 0, [userGroupId]   int NOT null default 0, [providerId]    int NOT null default 0, [entityId1]     int NOT null default 0, [entityId2]     int NOT null default 0, [entityId3]     int NOT null default 0, [entityId4]     int NOT null default 0, [entityId5]     int NOT null default 0, [entityId6]     int NOT null default 0, [entityId7]     int NOT null default 0, [entityId8]     int NOT null default 0, [entityId9]     int NOT null default 0  )
	IF @allAssociation=0  --Perform  Secuerity Check
	   BEGIN
		   EXEC sec_getUserObjects @i_userId, 2009, 0, '#clientListTmp'
	   END
		   IF object_id('tempdb.dbo.#clientTbl') is not null
		   DROP TABLE #clientTbl
		   CREATE TABLE  #clientTbl (
		   clientId INT PRIMARY KEY,PropertyType NVARCHAR(25),AdditionalInfo nvarchar(100))
		   IF  EXISTS(SELECT    1
						FROM      #clientListTmp AO
						WHERE     AO.commCellId = 2         AND AO.clientGroupId = 0 AND AO.clientId = 0      AND AO.appTypeId = 0             AND AO.instanceId = 0  AND
								   AO.backupsetId = 0        AND AO.subClientId = 0   AND AO.mediaAgentId = 0  AND AO.libraryId = 0             AND AO.archGroupId = 0 AND
								   AO.vtContainerId = 0      AND AO.vtPolicyId = 0    AND AO.vtShelfId = 0     AND AO.reviewSetId = 0           AND AO.querySetId = 0  AND
								   AO.downloadSetId = 0      AND AO.ermId = 0         AND AO.legalHoldId = 0   AND AO.tagId = 0                 AND AO.cdPolicyId = 0  AND
								   AO.complianceReportId = 0 AND AO.taskId = 0        AND AO.workflowId = 0    AND AO.logMonitoringPolicyId = 0 AND AO.arrayId = 0     AND
								   AO.cloudId = 0            AND AO.userGroupId = 0   AND AO.providerId = 0    AND AO.entityId1 = 0             AND AO.entityId2 = 0   AND
								   AO.entityId3 = 0          AND AO.entityId4 = 0     AND AO.entityId5 = 0     AND AO.entityId6 = 0             AND AO.entityId7 = 0   AND
								   AO.entityId8 = 0          AND AO.entityId9 = 0 AND @allAssociation=0)
		   BEGIN
			SET @allAssociation =1
		   END
	  		  IF ( @allAssociation =1)  --admin
			  BEGIN
                        INSERT INTO #clientTbl(clientId,PropertyType )
					    SELECT Ac.id,'VMs'
					    FROM APP_Client AC
					    INNER JOIN APP_ClientProp ACP ON ACP.componentNameId = AC.id
						            AND ACP.attrName = 'Last Backup JobID'
							       AND ACP.modified = 0
					  INSERT INTO #clientTbl(clientId,PropertyType )
					  SELECT  C.id ,CASE WHEN c.status &4096=4096 THEN 'Laptops'
									 ELSE 'Servers'
								  END
					  FROM
						  APP_Client C
						  LEFT OUTER JOIN APP_ClientProp ACP
	   					  ON ACP.componentNameId=C.id AND ACP.attrName='Index Server Type' AND ACP.attrVal IN ('6','7','8') and ACP.modified=0
						  LEFT JOIN #clientTbl Cl
							  ON Cl.clientId =C.id
					  WHERE
						  c.specialClientFlags & 0x1 <> 0x1
						  AND NOT EXISTS
						   (SELECT APP_VMToPMMap.PMClientId FROM APP_VMToPMMap WHERE APP_VMToPMMap.PMClientId = C.id
						   AND APP_VMToPMMap.VMClientId = 2)
						  AND (ACP.attrVal IS NULL)
						  AND Cl.ClientID is null
			END
    		    IF ( @allAssociation =0 )  --non admin
			  BEGIN
						-- VM Specific
						IF @DashBoard in ('COMMCELL' ,'APPLIANCE','APPLIANCECOMMCELL','TENANT')
						BEGIN
						IF OBJECT_ID('tempdb.dbo.#idaSubClientList') IS NOT NULL DROP TABLE #idaSubClientList
						IF OBJECT_ID('tempdb.dbo.#APPJobCycleTbl_tmp_VM') IS NOT NULL DROP TABLE #APPJobCycleTbl_tmp_VM
						    CREATE TABLE #APPJobCycleTbl_tmp_VM (vmClientId INT,jobId INT,clientId INT,instanceId INT,appId INT,subClientName  NVARCHAR(1024))
						    CREATE TABLE #idaSubClientList(t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
							EXEC sec_getIdaObjectsForUser @i_userId, 7 /*SUBCLIENT_ENTITY*/ , 0, 0, '#idaSubClientList'
							-- Get All VM's in APP_VMProp
							-- We will keep the relevant one once basic info has been fetched
							INSERT INTO #APPJobCycleTbl_tmp_VM
							   SELECT APCP.componentNameId,
							    JMB.jobId, AAP.clientId, AAP.instance, AAP.id, AAP.subclientName
								FROM APP_ClientProp APCP
								INNER JOIN JMBkpStats JMB WITH (NOLOCK)
								    ON CAST(JMB.jobId AS NVARCHAR(64))= APCP.attrVal
								INNER JOIN APP_Application AAP WITH (NOLOCK)
								ON AAP.id= JMB.appId AND AAP.appTypeId=106
						  WHERE APCP.attrName='Last Backup JobID' AND APCP.modified=0
							-- Implement Security Check
							-- Either user should have VIEW rights on the VM or VIEW rights on the subclient that backed it up
							DELETE T FROM #APPJobCycleTbl_tmp_VM T
							LEFT JOIN
								( SELECT AJCT.vmClientId FROM #APPJobCycleTbl_tmp_VM AJCT
									INNER JOIN #clientListTmp IDCL
										ON IDCL.clientId =AJCT.vmClientId
									UNION
									SELECT AJCT.vmClientId FROM #APPJobCycleTbl_tmp_VM AJCT
										INNER JOIN #idaSubClientList IDSCL
											ON IDSCL.t_subclientId=AJCT.appId) ViewRight
                               ON   T.vmClientId =ViewRight.vmClientId
							   WHERE ViewRight.vmClientId is NULL
							 INSERT INTO #clientTbl(clientId,PropertyType )
							 SELECT vmClientId,'VMS'
							 FROM  #APPJobCycleTbl_tmp_VM
						END
						  INSERT INTO #clientTbl(clientId,PropertyType )
						  SELECT  C.id ,CASE WHEN c.status &4096=4096 THEN 'LAPTOPS'
										 ELSE 'SERVERS'
									  END
						  FROM
							  APP_Client C
							  INNER JOIN #clientListTmp CT ON C.id = CT.clientId
							  LEFT OUTER JOIN APP_ClientProp ACP
								  ON ACP.componentNameId=C.id AND ACP.attrName='Index Server Type' AND ACP.attrVal IN ('6','7','8')
							  LEFT JOIN #clientTbl Cl
								  ON Cl.clientId =C.id
						  WHERE
							  c.specialClientFlags & 0x1 <> 0x1
							  AND NOT EXISTS (SELECT APP_VMToPMMap.PMClientId FROM APP_VMToPMMap
							  WHERE APP_VMToPMMap.PMClientId = C.id AND APP_VMToPMMap.VMClientId = 2)
								    AND (ACP.attrVal IS NULL) AND Cl.ClientID is null
			  END
			  DELETE ct
			  FROM  #clientTbl ct
			    LEFT OUTER JOIN APP_Platform p WITH(NOLOCK) ON
				  p.clientId = ct.clientId
				  AND p.platformType = 4
			  WHERE
			    p.clientId IS NULL
				--Exclude psuedo client which are created for solr cloud & content analyzer cloud
			    --these are dummy clients which does not needs be shown in the admin console page
			   DELETE T
			   FROM #clientTbl T
			   WHERE dbo.IsDistributedPseudoClient(T.clientId ) = 1
				--Delete the physical clients for the user centric client
			   DELETE #clientTbl WHERE CAST(clientId AS VARCHAR(10)) IN
					(SELECT prop2.attrVal FROM #clientTbl c
INNER JOIN APP_ClientProp prop on prop.componentNameId = c.clientId and prop.modified=0 AND attrName ='User Centric Client' AND attrVal='1'
INNER JOIN APP_ClientProp prop2 ON prop.componentNameId=prop2.componentNameId AND prop2.modified = 0 AND prop2.attrName = 'Physical Client Id' AND prop2.attrVal<>'0'
						WHERE PropertyType='Laptops')
			 AND PropertyType='Laptops'
    IF @DashBoard = 'ORCHESTRATION'
    BEGIN
      INSERT #PropertyInfo VALUES ('DATABASES',0,10),('FILESERVERS',0,20),('GENERICAPPS',0,30),('MAILBOXES',0,40),('VMS',0,40)
	  	DELETE CT
			  FROM  #clientTbl ct WHERE PropertyType='LAPTOPS'
          UPDATE CT
			   SET
				PropertyCount= DatabaseList.DBCount
		  FROM  #PropertyInfo CT
				 CROSS APPLY
			 (
				SELECT COUNT(DISTINCT  app.ClientID) DBCount
				FROM App_Application App
					JOIN APP_IDAname Ida ON Ida.appTypeId = app.appTypeId
									    AND App.clientId = Ida.clientId
					JOIN APP_iDAType IDAType ON IDAType.type = ida.appTypeId
					JOIN APP_AppTypeGroupAssoc TypeAssoc ON TypeAssoc.appTypeId = IDA.appTypeId
					JOIN #clientTbl clist ON clist.ClientID = App.ClientID
				WHERE TypeAssoc.appGroupId = 89
			 ) DatabaseList
			 WHERE  PropertyType = 'DATABASES'
			 	  --File System
		    UPDATE CT
			   SET
				PropertyCount= FS.FSCount
		  FROM  #PropertyInfo CT
				 CROSS APPLY
			 (
				 SELECT COUNT(DISTINCT  App.ClientID) FSCount
			 FROM App_Application App
				 JOIN APP_IDAname Ida ON Ida.appTypeId = app.appTypeId
									AND App.clientId = Ida.clientId
				 JOIN APP_iDAType IDAType ON IDAType.type = ida.appTypeId
				 JOIN APP_AppTypeGroupAssoc TypeAssoc ON TypeAssoc.appTypeId = IDA.appTypeId
				 JOIN #clientTbl clist ON clist.ClientID = App.ClientID
			 WHERE TypeAssoc.appGroupId = 35
				  AND Ida.Apptypeid NOT IN (64)
			 ) FS
			 WHERE  PropertyType = 'FILESERVERS'
		  --Generic Apps
		  		 UPDATE CT
				  SET
				    PropertyCount= GenericApp.GenericAppCount
			 FROM  #PropertyInfo CT
					CROSS APPLY
				(
			 	    SELECT  COUNT( DISTINCT e.value('/Api_VirtualAppReq[1]/vApp[1]/vAppEntity[1]/@vAppName', 'varchar(50)')) GenericAppCount
					 FROM App_VirtualApp ap
				    CROSS APPLY  vxml.nodes('/Api_VirtualAppReq[1]/vApp[1]/genericApp[1]/enterpriseNodes') s(e)
				    WHERE   flags !=1  and isnull(deleted ,0) =0
				) GenericApp
				    WHERE  PropertyType = 'GENERICAPPS'
             --mailbox
		    UPDATE CT
		    SET
			   PropertyCount = Mailbox.MailboxCount
		  FROM #PropertyInfo CT
		  CROSS APPLY
		  (
			 SELECT COUNT(distinct aliasName) MailboxCount  FROM APP_EmailConfigPolicyAssoc A
						WHERE status = 0 and modified = 0 and userGuid != '' and mailBoxType = 1
		  ) Mailbox
		    WHERE  PropertyType = 'MAILBOXES'
		    --vm
		   UPDATE CT
		    SET
			   PropertyCount = Vm.VmCount
		  FROM #PropertyInfo CT
		  CROSS APPLY
		  (
			 SELECT Count(*) VmCount
				 FROM  #clientTbl C WHERE PropertyType ='VMS'
		  ) Vm
		    WHERE  PropertyType = 'VMS'
			 SELECT PropertyType,PropertyCount
			 FROM #PropertyInfo
			 ORDER BY Ordering
    END
      --Servers
    IF @DashBoard in ('SERVER')
	   BEGIN
	        DECLARE @ServerProp TABLE(PropertyType VARCHAR(100),PropertyCount int ,Ordering int)
		 INSERT @ServerProp VALUES ('FILESERVERS',0,10),('NASFILERS',0,20),('DATABASES',0,30),('OTHERS',0,40), ('UNIX',0,60),('WINDOWS',0,70)
		 UPDATE ct SET PropertyType='OTHERS'
			  FROM  #clientTbl ct WHERE PropertyType<>'SERVERS'
		  --   Gather  Server Specific Info
		  --1) Databases
			 UPDATE CT
			   SET
				  PropertyType = 'DATABASES'
			 FROM #clientTbl CT
				 JOIN
			 (
				SELECT DISTINCT
					  app.ClientID
				FROM App_Application App
					JOIN APP_IDAname Ida ON Ida.appTypeId = app.appTypeId
									    AND App.clientId = Ida.clientId
					JOIN APP_iDAType IDAType ON IDAType.type = ida.appTypeId
					JOIN APP_AppTypeGroupAssoc TypeAssoc ON TypeAssoc.appTypeId = IDA.appTypeId
					JOIN #clientTbl clist ON clist.ClientID = App.ClientID
				WHERE TypeAssoc.appGroupId = 89
			 ) DatabaseList ON DatabaseList.ClientID = Ct.ClientID AND PropertyType='SERVERS'
            -- 2)	NAS Filers
		UPDATE CT
		    SET
			   PropertyType = 'NASFILERS'
		  FROM #clientTbl CT
			  JOIN APP_Client C ON Ct.CLientID = C.ID
			  LEFT OUTER JOIN simOperatingSystem os WITH(READUNCOMMITTED) ON
                            c.simOperatingSystemId = os.id
		   WHERE
                        c.id > 1
                        AND os.id IS NOT NULL
                        AND os.SubType = 'NAS'
			    		AND PropertyType='SERVERS'
		  --File System
		UPDATE CT
		    SET
			   PropertyType = 'FILESERVERS'
		  FROM #clientTbl CT,
		  (
			 SELECT DISTINCT
				   App.ClientID
			 FROM App_Application App
				 JOIN APP_IDAname Ida ON Ida.appTypeId = app.appTypeId
									AND App.clientId = Ida.clientId
				 JOIN APP_iDAType IDAType ON IDAType.type = ida.appTypeId
				 JOIN APP_AppTypeGroupAssoc TypeAssoc ON TypeAssoc.appTypeId = IDA.appTypeId
				 JOIN #clientTbl clist ON clist.ClientID = App.ClientID
									 AND PropertyType='SERVERS'
			 WHERE TypeAssoc.appGroupId = 35
				  AND Ida.Apptypeid NOT IN(64)
		  ) FS
		  WHERE fs.ClientID = Ct.ClientID
		  --UNIX and Windows
			 UPDATE CT
		    SET
			   AdditionalInfo=Apptype
		  FROM #clientTbl CT,
		  (
			 SELECT DISTINCT
				   App.ClientID,CASE WHEN  IDAType.type IN  (17,18,19,20,21,29,36,38,63,64,74) THEN 'UNIX'
									 WHEN  IDAType.type IN  (11,33,34,42,43) THEN 'WINDOWS'
									 END Apptype
			 FROM App_Application App
				 JOIN APP_IDAname Ida ON Ida.appTypeId = app.appTypeId
									AND App.clientId = Ida.clientId
				 JOIN APP_iDAType IDAType ON IDAType.type = ida.appTypeId
				 JOIN APP_AppTypeGroupAssoc TypeAssoc ON TypeAssoc.appTypeId = IDA.appTypeId
				 JOIN #clientTbl clist ON clist.ClientID = App.ClientID
			 WHERE TypeAssoc.appGroupId = 35
				  AND Ida.Apptypeid NOT IN(64) AND PropertyType in ('FILESERVERS','NASFILERS')
		  ) FS
		  WHERE fs.ClientID = Ct.ClientID
         --Others
			 UPDATE CT
			   SET
				  PropertyType = 'OTHERS'
			 FROM #clientTbl CT
			 WHERE PropertyType = 'SERVERS'
			 UPDATE S
			   SET
				  PropertyCount = ClientList.ClientCount
			 FROM @ServerProp S,
			 (
				SELECT COUNT(DISTINCT Ct.clientId) ClientCount,
					  PropertyType
				FROM #clientTbl Ct
				GROUP BY PropertyType
			 ) ClientList
			 WHERE ClientList.PropertyType = S.PropertyType
			 UPDATE S
			   SET
				  PropertyCount = ClientList.ClientCount
			 FROM @ServerProp S,
			 (
				SELECT COUNT(DISTINCT Ct.clientId) ClientCount,
					  AdditionalInfo
				FROM #clientTbl Ct
				GROUP BY AdditionalInfo
			 ) ClientList
			 WHERE ClientList.AdditionalInfo = S.PropertyType
			 SELECT PropertyType,PropertyCount
			 FROM @ServerProp
			 ORDER BY Ordering
			 RETURN
		END
    IF @DashBoard in ('COMMCELL' ,'APPLIANCE','APPLIANCECOMMCELL','TENANT')
    BEGIN
	   IF @DashBoard NOT in ('APPLIANCE') --Exclude User Info
	   BEGIN
		    IF OBJECT_ID ('tempdb.dbo.#usersThisUserCanView') is not null
		    DROP table #usersThisUserCanView
		    CREATE TABLE #usersThisUserCanView (userID INT)
            EXEC sec_getUsersForThisUser '#usersThisUserCanView',@i_userId
		    INSERT #PropertyInfo
		    SELECT  'USERS' PropertyType,count(*) PropertyCount ,50 from #usersThisUserCanView
	  END
		   INSERT #PropertyInfo
		   SELECT Prop PropertyType,
				ISNULL(Clients, 0) PropertyCount
				,Ordering
		   FROM
		   (
			  SELECT 'SERVERS' Prop,
					10 Ordering
			  UNION
			  SELECT 'VMS' Prop,
					20 Ordering
			  UNION
			  SELECT 'LAPTOPS' Prop,
					30 Ordering
		   ) v
		   OUTER APPLY
		   (
			  SELECT COUNT(ClientID) Clients,
					PropertyType
			  FROM #clientTbl
			  WHERE v.Prop = PropertyType
			  GROUP BY PropertyType
		   ) C
		   IF @DashBoard IN ('COMMCELL','TENANT')
		   BEGIN
			  SELECT PropertyType,PropertyCount FROM #PropertyInfo Order by Ordering asc
			  RETURN
		   END
		END
	 IF @Dashboard in ('ENDPOINT')
	  BEGIN
	  CREATE TABLE #appgetdeviceClientList (
                     clientId INT PRIMARY KEY,
                     t_appTypeId INT,
                     t_instanceId INT,
                     t_backupsetId INT,
                     t_subclientId INT
                     )
		EXEC sec_getIdaObjectsForUser @i_userid,
                     3 /*CLIENT_ENTITY */,
                     0 /*View*/,
                     0,
                     '#appgetdeviceClientList'
	  DECLARE @AppGrp35AppTypes TABLE (
              appTypeId            INT PRIMARY KEY
       )
		INSERT INTO @AppGrp35AppTypes
		SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35,0)
			INSERT INTO #PropertyInfo
					SELECT 'laptops' ,COUNT(*) AS [Clientount],10
			FROM #appgetdeviceClientList um
			INNER JOIN APP_Client c
				   ON c.id = um.clientId
						  AND c.STATUS & 0x1000 = 0x1000
			INNER JOIN APP_IDAName ida
				   ON ida.clientId = um.clientId
						  AND    ida.appTypeId <> 13
						  AND ida.appTypeId IN (
								 SELECT appTypeId
								 FROM @AppGrp35AppTypes
						  )
			LEFT OUTER JOIN APP_ClientProp pid ON
				   pid.componentNameId = um.clientId
				   AND pid.modified = 0
				   AND pid.attrName = 'Associated Plan'
				   AND ISNUMERIC(pid.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp ucc ON
				   ucc.componentNameId = um.clientId
				   AND ucc.modified = 0
				   AND ucc.attrName = 'User Centric Client'
				   AND ISNUMERIC(ucc.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp pcid ON
				   pcid.componentNameId = um.clientId
				   AND pcid.modified = 0
				   AND pcid.attrName = 'Physical Client Id'
				   AND ISNUMERIC(pcid.attrVal) = 1
			LEFT OUTER JOIN APP_Plan p ON
				   pid.attrVal IS NOT NULL
				   AND p.id = CAST(pid.attrVal AS INT)
			LEFT OUTER JOIN APP_ClientProp acpcs ON
				   acpcs.componentNameId = um.clientId
				   AND acpcs.modified = 0
				   AND acpcs.attrName = 'PlatformDeleted 4'
				   AND ISNUMERIC(acpcs.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp acpma ON
				   acpma.componentNameId = um.clientId
				   AND acpma.modified = 0
				   AND acpma.attrName = 'PlatformDeleted 2'
				   AND ISNUMERIC(acpma.attrVal) = 1
			WHERE UM.clientId NOT IN
			(
				   SELECT attrVal FROM APP_ClientProp WHERE attrName = 'Physical Client Id' AND modified = 0
			)
			DECLARE @callerId int = @i_userId
			IF OBJECT_ID('tempdb.dbo.#UsersSec_getUsersNewTbl')  IS NOT NULL
				DROP TABLE #UsersSec_getUsersNewTbl
			CREATE TABLE  #UsersSec_getUsersNewTbl  (userId int);
			EXEC sec_getUsersForThisUser '#UsersSec_getUsersNewTbl' ,@callerId
            INSERT INTO #PropertyInfo
			SELECT 'Users',count(*)  AS 'User Count',20 from
			(SELECT DISTINCT userOrGroupId 'userid' from UMOwners where entityType = 3 and entityId IN (SELECT id FROM APP_Client WHERE status & 4096 = 4096)  and isUser <> 0
			UNION
			SELECT DISTINCT UG.userId 'userid' from UMOwners UM INNER JOIN UMUserGroup UG on UM.userOrGroupId = UG.groupId where entityType = 3 and entityId IN (SELECT id FROM APP_Client WHERE status & 4096 = 4096) and UM.isUser = 0
			UNION
			SELECT DISTINCT UG.userId 'userid' from UMOwners UM INNER JOIN UMDSGroupMaps UGM on UM.userOrGroupId = UGM.umgroupId INNER JOIN UMDSUserGroup UG ON UGM.umDSgroupId = UG.groupId  where entityType = 3 and
			entityId IN (SELECT id FROM APP_Client WHERE status & 4096 = 4096) and UM.isUser = 0
			) A where A.userid in (SELECT userid from #UsersSec_getUsersNewTbl)
			DROP TABLE #UsersSec_getUsersNewTbl
			-- We need critical events for last 24 hrs
			DECLARE @startTime INT = dbo.getunixtime(dateadd(hour,-1*24,getutcdate()))
			DECLARE @endTime INT =dbo.getunixtime(getutcdate())
			INSERT INTO #PropertyInfo
				SELECT 'alerts',count(DISTINCT hist.LiveFeedId) as 'CriticalLiveFeedsCount',30
			FROM NTLiveFeedsMessageHistory hist with (readuncommitted) INNER JOIN NTLiveFeedsStatus stat with (readuncommitted) ON hist.LiveFeedId = stat.LiveFeedsId
			AND stat.userId = @i_userId
			where (hist.escalationLevel & 0xFFFF0000)/ POWER(2,17)=1
			and created>=@startTime
			and (created<=@endTime or @endTime=0)
			SELECT PropertyType,PropertyCount, Ordering  from #PropertyInfo
			RETURN
	  END
	  If  @Dashboard in ('APPLIANCE','APPLIANCECOMMCELL')
	  BEGIN
		DECLARE @blockCount INT = 0
            ;with blocks_cte
            AS  (
                select 1 as temp
                from MMDiskHwInfo D
                    INNER join MMMountpathToStorageDevice MPSD ON MPsd.deviceid = D.deviceid
                    INNER JOIN MMMountpath MP ON MP.mountpathid = mpsd.mountpathid
                    INNER JOIN MMsdsstoragepool S ON S.libraryid = MP.libraryid
                    INNER JOIN #clientTbl C ON D.hostId = C.ClientId
                GROUP BY D.blockNumber, S.GDSPId
            )
            SELECT @blockCount = count(*) FROM blocks_cte
			INSERT #PropertyInfo
				SELECT 'BLOCKS' Appliance, @blockCount, 6
			SELECT PropertyType,PropertyCount  FROM #PropertyInfo
			ORDER BY Ordering asc
			RETURN
		END
	END TRY
	BEGIN CATCH
			DECLARE  @ErrorMsg VARCHAR(max)
            SELECT    @ErrorMsg ='ERROR:'+ CAST(ERROR_NUMBER() AS VARCHAR(20))+' ErrNo '+
											CAST(ERROR_SEVERITY() AS VARCHAR(3))+' Severity '+
											CAST(ERROR_STATE() AS VARCHAR(3))+' SP '+
											CAST(ISNULL(ERROR_PROCEDURE(),'') AS VARCHAR(25))+' Line '+
											CAST(ERROR_LINE()AS VARCHAR(10))+' Msg '+
											CAST(ERROR_MESSAGE() AS VARCHAR(210));
	        THROW 51000,@ErrorMsg,1;
	END CATCH
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetDashboard_TileInfo')
	delete from GxQscripts where name = 'GetDashboard_TileInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDashboard_TileInfo')
	delete from GXDBVersions where aliasname = 'GetDashboard_TileInfo'
GO

insert into GXDBVersions values(2, 'GetDashboard_TileInfo',  '00010001000200160000', 'GetDashboard_TileInfo', '00010001000200160000')
GO

