

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDLPPropXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--When client asks for his settings, implement the following logic:
--1)	If this client has enableDLP=1 in the DB, return the clients settings
--2)	If the client doesnt have enableDLP=1, enumerate all the groups that have this client. For every group that has enableDLP=1, take dlpContents and dlpEnableClientKeys and combine them in one as:
--		a.	dlpContents  by concatenating strings together
--		b.	dlpFilters  by concatenating strings together
--		c.	dlpEnableClientKeys  by ANDing all flags together
--		d.	enableDLP - by ORing all flags together
--		e.	dlpStolen - by ORing all flags together
--		f.	dlpScanIntervalMins - take Max scan interval
--		g.	dlpMinFileAgeMins - take Max File Age
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetDLPPropXML')
BEGIN
	print '>>> Drop Stored Procedure: GetDLPPropXML <<<'
	drop procedure GetDLPPropXML
END
IF EXISTS (select * from GxQscripts where name='GetDLPPropXML')
	delete from GxQscripts where name = 'GetDLPPropXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDLPPropXML')
	delete from GXDBVersions where aliasname = 'GetDLPPropXML'
GO
print '... Creating Procedure: GetDLPPropXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetDLPPropXML
  @clientId INT,
  @IsWebcosoleDisableDLP INT,
  @IsWebconsoleDisableSecureErase INT,
  @o_xml XML output
AS
DECLARE @errorCode				INT	= 0
DECLARE @errorString			VARCHAR(MAX) = 'Success'
BEGIN TRY
 DECLARE @DLPPropTbl TABLE (clientId int, errorCode int, enableDLP int, dlpEnableClientKeys int, dlpStolen int, dlpScanIntervalMins int, dlpMinFileAgeMins int, dlpEnableAutomaticDecryption int, dlpUnlockMethod int, dlpContents  NVARCHAR(MAX), dlpFilters  NVARCHAR(MAX), errorString  VARCHAR(MAX), clientName  NVARCHAR(MAX), clientDisplayName  NVARCHAR(MAX))
	DECLARE @DLPContentTbl TABLE (
                                dlpContents NVARCHAR(MAX)
                                )
	DECLARE @DLPFilterTbl TABLE (
                                dlpFilters NVARCHAR(MAX)
                                )
	--DLP Secure Erase data
	DECLARE @DLPRmPropTbl TABLE (errorCode int, enableRmDLP int, dlpRmOfflineDays int, dlpRmNow int, dlpRmContents  NVARCHAR(MAX), dlpRmFilters  NVARCHAR(MAX), errorString  VARCHAR(MAX))
	DECLARE @DLPRmContentTbl TABLE (
                                dlpContents NVARCHAR(MAX)
                                )
	DECLARE @DLPRmFilterTbl TABLE (
                                dlpFilters NVARCHAR(MAX)
                                )
    -- Insert statements for procedure here
	 IF(@IsWebcosoleDisableDLP = 0)
	BEGIN
		INSERT into @DLPPropTbl
		EXEC GetDLPProp @clientId, 0
		INSERT INTO @DLPContentTbl
		SELECT _ID FROM dbo.SplitStringByDelimiter(ISNULL((select dlpContents from @DLPPropTbl where dlpContents<>';'),''),';')
		INSERT INTO @DLPFilterTbl
		SELECT _ID FROM dbo.SplitStringByDelimiter(ISNULL((select dlpFilters from @DLPPropTbl where dlpFilters<>';'),''),';')
	 END
	 ELSE
		INSERT INTO @DLPPropTbl VALUES(null, null, null, null, null, null, null, null, null, null , null, null  , null, null)
	IF(@IsWebconsoleDisableSecureErase = 0)
	BEGIN
		INSERT INTO @DLPRmPropTbl
		EXEC GetRMDLPProp @clientId
		INSERT INTO @DLPRmContentTbl
		SELECT _ID FROM dbo.SplitStringByDelimiter(ISNULL((select dlpRmContents from @DLPRmPropTbl where dlpRmContents<>';'),''),';')
		INSERT INTO @DLPRmFilterTbl
		SELECT _ID FROM dbo.SplitStringByDelimiter(ISNULL((select dlpRmFilters from @DLPRmPropTbl where dlpRmFilters<>';'),''),';')
	END
	SET @o_xml= ((SELECT
											enableDLP AS '@enableDLP',
											dlpStolen AS '@dlpStolen',
											dlpEnableClientKeys AS '@dlpEnableClientKeys',
											dlpScanIntervalMins AS '@dlpScanIntervalMins',
											dlpMinFileAgeMins AS '@dlpMinFileAgeMins',
											dlpEnableAutomaticDecryption AS '@dlpEnableAutomaticDecryption',
											dlpUnlockMethod AS '@dlpUnlockMethod',
											(SELECT DISTINCT dlpContents AS '@val'
												FROM @DLPContentTbl
																		FOR XML PATH('dlpContents'), TYPE),
											(SELECT DISTINCT dlpFilters AS '@val'
												FROM @DLPFilterTbl
											FOR XML PATH('dlpFilters'), TYPE),
											  ((SELECT
											enableRmDLP AS '@enableRmDLP',
											dlpRmOfflineDays AS '@dlpRmOfflineDays',
											dlpRmNow AS '@dlpRmNow',
											(SELECT DISTINCT dlpContents AS '@val'
												FROM  @DLPRmContentTbl
																		FOR XML PATH('dlpRmContents'), TYPE),
											(SELECT DISTINCT dlpFilters AS '@val'
												FROM @DLPRmFilterTbl
																				FOR XML PATH('dlpRmFilters'), TYPE)
											  FROM @DLPRmPropTbl	FOR XML PATH('dlpRMProperties'), TYPE))
											  FROM @DLPPropTbl
										FOR XML PATH('dlpProperties'),TYPE))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'GetDLPPropXML')
	delete from GxQscripts where name = 'GetDLPPropXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDLPPropXML')
	delete from GXDBVersions where aliasname = 'GetDLPPropXML'
GO

insert into GXDBVersions values(2, 'GetDLPPropXML',  '00000000000000000000', 'GetDLPPropXML', '00000000000000000000')
GO

