

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDLPProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--When client asks for his settings, implement the following logic:
--1)	If this client has enableDLP=1 in the DB, return the clients settings
--2)	If the client doesnt have enableDLP=1, enumerate all the groups that have this client. For every group that has enableDLP=1, take dlpContents and dlpEnableClientKeys and combine them in one as:
--		a.	dlpContents - by concatenating strings together
--		b.	dlpFilters - by concatenating strings together
--		c.	dlpEnableClientKeys - by ANDing all flags together
--		d.	enableDLP - by ORing all flags together
--		e.	dlpStolen - by ORing all flags together --CMR 178504: Mark Device lost or stolen to be moved out of enable DLP group box. Rule 2e is not applicable. Get this property from client instead of client group.
--		f.	dlpScanIntervalMins - take Max scan interval
--		g.	dlpMinFileAgeMins - take Max File Age
--		h.	dlpUnlockMethod - take Minimum which is greater than 0.
--		i.  dlpEnableAutomaticDecryption - by ORing all flags together
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetDLPProp')
BEGIN
	print '>>> Drop Stored Procedure: GetDLPProp <<<'
	drop procedure GetDLPProp
END
IF EXISTS (select * from GxQscripts where name='GetDLPProp')
	delete from GxQscripts where name = 'GetDLPProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDLPProp')
	delete from GXDBVersions where aliasname = 'GetDLPProp'
GO
print '... Creating Procedure: GetDLPProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetDLPProp
  @clientId INT,
  @jobId INT = 0
AS
  DECLARE @outClientId INT	= 0
  DECLARE @errorCode INT	= 0
  DECLARE @enableDLP INT = 0
  DECLARE @dlpEnableClientKeys INT = 1
  DECLARE @dlpStolen INT = 0
  DECLARE @dlpScanIntervalMins INT = 0
  DECLARE @dlpMinFileAgeMins INT = 0
  DECLARE @dlpEnableAutomaticDecryption INT = 0
  DECLARE @dlpUnlockMethod INT = 0
  DECLARE @dlpContents NVARCHAR(MAX) = N''
  DECLARE @dlpFilters NVARCHAR(MAX) = N''
  DECLARE @errorString VARCHAR(MAX) = 'Success'
  DECLARE @clientName NVARCHAR(MAX)
  DECLARE @clientDisplayName NVARCHAR(MAX) = N''
BEGIN TRY
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF @clientId>0
	BEGIN
		DECLARE @v_groupid			VARCHAR(MAX) = ''
		-- performance fix for high CPU Usage by adding modified = 0 checks now uses the correct index instead of performing a CI Scan operation
		DECLARE @pseudoClientId INT = ISNULL((
			SELECT TOP 1
				ACP1.componentNameId
			FROM APP_ClientProp ACP1
				INNER JOIN APP_ClientProp ACP2 ON
					ACP1.componentNameId = ACP2.componentNameId
AND ACP2.attrName = 'User Centric Client'
					AND ACP2.attrVal = N'1'
					AND ACP2.modified = 0
			WHERE
ACP1.attrName = 'Physical Client Id'
				AND ACP1.attrVal = CAST(@clientId AS NVARCHAR(12))	-- corrected cast for index usage
				AND ACP1.modified = 0
			ORDER BY ACP1.componentNameId), 0)
		IF @pseudoClientId <> 0
		BEGIN
			SET @clientId = @pseudoClientId
		END
		--Req 1.
		IF EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) where componentNameId = @clientId AND attrName = 'enableDLP' AND attrVal = N'1' AND modified = 0)
		BEGIN
			SET @enableDLP = 1
			SET @dlpContents = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpContents' AND modified = 0), N'')
			SET @dlpFilters = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpFilters' AND modified = 0), N'')
			SET @dlpStolen = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpStolen' AND modified = 0), 0)
			SET @dlpEnableClientKeys = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpEnableClientKeys' AND modified = 0), 0)
			SET @dlpScanIntervalMins = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpScanIntervalMins' AND modified = 0), 15)
			SET @dlpMinFileAgeMins = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpMinFileAgeMins' AND modified = 0), 5)
			SET @dlpEnableAutomaticDecryption = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpEnableAutomaticDecryption' AND modified = 0), 0)
			SET @dlpUnlockMethod = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpUnlockMethod' AND modified = 0), 0)
		END
		ELSE
		BEGIN
			--Req 2a.
		SELECT @dlpContents = @dlpContents  + attrVal FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																											WHERE CGA.clientId = @clientId
																												AND CGA.clientGroupId = CG.id )
																									 AND attrName = 'enableDLP'
																									 AND attrVal = '1' ) AND attrName = 'dlpContents' AND modified = 0
	--	IF LEN(@dlpContents) > 1
		--	SET @dlpContents = RIGHT(@dlpContents, LEN(@dlpContents) - 1)
		--Req 2b.
		SELECT @dlpFilters = @dlpFilters  + attrVal FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableDLP'
																								 AND attrVal = '1' ) AND attrName = 'dlpFilters' AND modified = 0
	--	IF LEN(@dlpFilters) > 1
		--	SET @dlpFilters = RIGHT(@dlpFilters, LEN(@dlpFilters) - 1)
		--Req 2c.
		SELECT @dlpEnableClientKeys = @dlpEnableClientKeys & CAST(ISNULL(attrVal, 0) AS INT) FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN (( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableDLP'
																								 AND attrVal = '1' )) AND attrName = 'dlpEnableClientKeys' AND modified = 0
		--Req 2d.
		SELECT @enableDLP = @enableDLP | CAST(ISNULL(attrVal, 0) AS INT) FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN (( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableDLP'
																								 AND attrVal = '1' )) AND attrName = 'enableDLP' AND modified = 0
		--Req 2e.
		--CMR 178504: Mark Device lost or stolen to be moved out of enable DLP group box.
		--Get this property from client instead of client group.
		--SELECT @dlpStolen = @dlpStolen | CAST(ISNULL(attrVal, 0) AS INT) FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN (( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
		--																								WHERE CGA.clientId = @clientId
		--																									AND CGA.clientGroupId = CG.id )
		--																						 AND attrName = 'enableDLP'
		--																						 AND attrVal = '1' )) AND attrName = 'dlpStolen' AND modified = 0
		SET @dlpStolen = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpStolen'), 0)
		--Req 2f.
		SET @dlpScanIntervalMins = ISNULL( (SELECT MAX( CAST(ISNULL(attrVal, 0) AS INT) ) FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN (( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableDLP'
																								 AND attrVal = '1' )) AND attrName = 'dlpScanIntervalMins' AND modified = 0), 15)
		--Req 2g.
		SET @dlpMinFileAgeMins = ISNULL( (SELECT MAX( CAST(ISNULL(attrVal, 0) AS INT) ) FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN (( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableDLP'
																								 AND attrVal = '1' )) AND attrName = 'dlpMinFileAgeMins' AND modified = 0), 5)
		--Req 2i.
		SELECT @dlpEnableAutomaticDecryption = @dlpEnableAutomaticDecryption | CAST(ISNULL(attrVal, 0) AS INT) FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN (( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableDLP'
																								 AND attrVal = '1' )) AND attrName = 'dlpEnableAutomaticDecryption' AND modified = 0
		DECLARE @dlpGroupID INT = 0
		DECLARE dlpGroupPropCur CURSOR FOR ( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableDLP'
																								 AND attrVal = '1' )
		DECLARE @tempdlpUnlockMethod INT = 0
		OPEN dlpGroupPropCur
			FETCH NEXT FROM dlpGroupPropCur INTO @dlpGroupID
			WHILE @@FETCH_STATUS = 0
			BEGIN
					--Req 2h START--
					SET @tempdlpUnlockMethod = ISNULL((SELECT CAST(ISNULL(attrVal, 0) AS INT) FROM DlpGroupProp WITH(NOLOCK) WHERE groupId = @dlpGroupID AND attrName = 'dlpUnlockMethod' AND modified = 0), 0)
					IF @tempdlpUnlockMethod > 0
					BEGIN
						IF @dlpUnlockMethod = 0 OR @dlpUnlockMethod > @tempdlpUnlockMethod
							SET @dlpUnlockMethod = @tempdlpUnlockMethod
					END
					--Req 2h END--
					FETCH NEXT FROM dlpGroupPropCur INTO @dlpGroupID
			END--END cursor fetch loop
		CLOSE dlpGroupPropCur
		DEALLOCATE dlpGroupPropCur
			--client is not associated to any group.
			IF NOT EXISTS ( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
										WHERE CGA.clientId = @clientId
										AND CGA.clientGroupId = CG.id )
				SET @dlpEnableClientKeys = 0
			--client is associated to groups but group do not have enableDLP = 1.
			IF NOT EXISTS ( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																											WHERE CGA.clientId = @clientId
																												AND CGA.clientGroupId = CG.id )
																									 AND attrName = 'enableDLP'
																									 AND attrVal = '1' )
				SET @dlpEnableClientKeys = 0
		END
	END
	ELSE
	BEGIN
	  -- if DLP client group number is large, use function createclientGroupString (from Jun Lu)
	  DECLARE @clOpt			integer
	  DECLARE @tblClients		TABLE (t_clId int)
	  -- get clients selected by the user
	  INSERT INTO @tblClients EXEC rptOptGetClients @jobId, @clOpt OUTPUT
	  -- if user makes no selection, all clients are selected
	  IF @clOpt=0 INSERT INTO @tblClients SELECT id FROM APP_Client
	  -- create a table of all selected clients in all DLP groups
	  IF object_id('tempdb.dbo.#DLPGroupClientMap') IS NOT null DROP TABLE #DLPGroupClientMap
	  CREATE TABLE #DLPGroupClientMap
	  (
	        clientId int not null,
			groupId int not null
		)
	  INSERT INTO #DLPGroupClientMap
		SELECT CGA.clientId, DLPGP.groupid
		FROM DlpGroupProp DLPGP WITH(NOLOCK),
		     APP_ClientGroup CG WITH(NOLOCK),
		     APP_ClientGroupAssoc CGA WITH(NOLOCK)
		WHERE
		  DLPGP.groupid=CG.id AND
		  CGA.clientGroupId = CG.id AND
		  DLPGP.attrName = 'enableDLP' AND
		  DLPGP.attrVal = '1' AND
		  DLPGP.modified = 0 AND
		  (CGA.clientId in (select t_clId from @tblClients))
    -- user security.  get user, and delete clients AND groups from DLPGroupClientMap and delete clients from the clients table.
	DECLARE @userId			integer
SET @userId			= dbo.GetOptionInt(140019, @jobId, 0, 0)
	--got all qualified entries, do the security check before more details and summary
	IF @userId > 0
	BEGIN
		IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @userId, 2009, 0, '#rptUserObjects'	-- 2009 = CLIENT_ITEM
		-- delete all unnecessary rows from #rptUserObjects
		delete #rptUserObjects
		WHERE mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
		OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
		OR taskId <> 0
		-- delete clients AND groups from DLPGroupClientMap
		delete #DLPGroupClientMap
		WHERE 0 = (	select	count(1) from #rptUserObjects U where U.clientId in (0, clientId) AND U.clientGroupId in (0,groupId))
		delete #rptUserObjects
		WHERE clientGroupId <> 0
	  	delete @tblClients
		WHERE 0 = (	select	count(1) from #rptUserObjects
			where	clientId in (0, t_clId))
	END
      -- retrieve all DLP properties from all groups in the DLPGroupClientMap merging them as per rules commented at the beginning of this stored procedure.
	  IF object_id('tempdb.dbo.#DLPGroupClientResults') IS NOT null DROP TABLE #DLPGroupClientResults
	  CREATE TABLE #DLPGroupClientResults
	  (
	        clientId                        INT NOT NULL,
			dlpStolen			            INT,
			dlpScanIntervalMins	            INT,
			dlpMinFileAgeMins	            INT,
			dlpContents			            NVARCHAR(MAX),
			dlpFilters			            NVARCHAR(MAX),
			clientName			            NVARCHAR(MAX),
			dlpEnableAutomaticDecryption	INT,
			dlpUnlockMethod			        INT,
            clientDisplayName               NVARCHAR(MAX)
		)
      INSERT INTO #DLPGroupClientResults (clientId, dlpStolen,dlpScanIntervalMins,dlpMinFileAgeMins,dlpContents,dlpFilters,clientName,dlpEnableAutomaticDecryption,dlpUnlockMethod, clientDisplayName)
	  select DISTINCT
		  ac.id,
		  (SELECT MAX(attrVal) FROM DlpGroupProp as DLPGP, #DLPGroupClientMap as DLPGCM  WHERE DLPGP.groupid = DLPGCM.groupId AND DLPGCM.clientId=ac.id and DLPGP.attrName = 'dlpStolen' AND DLPGP.modified = 0) as dlpStolen,
		  (SELECT MAX(attrVal) FROM DlpGroupProp as DLPGP, #DLPGroupClientMap as DLPGCM  WHERE DLPGP.groupid = DLPGCM.groupId AND DLPGCM.clientId=ac.id and DLPGP.attrName = 'dlpScanIntervalMins' AND DLPGP.modified = 0) as dlpScanIntervalMins,
		  (SELECT MAX(attrVal) FROM DlpGroupProp as DLPGP, #DLPGroupClientMap as DLPGCM  WHERE DLPGP.groupid = DLPGCM.groupId AND DLPGCM.clientId=ac.id and DLPGP.attrName = 'dlpMinFileAgeMins' AND DLPGP.modified = 0) as dlpMinFileAgeMins,
		  STUFF((SELECT ';' + attrVal FROM DlpGroupProp as DLPGP, #DLPGroupClientMap as DLPGCM  WHERE DLPGP.groupid = DLPGCM.groupId AND DLPGCM.clientId=ac.id and DLPGP.attrName = 'dlpContents' AND DLPGP.modified = 0  FOR XML PATH('')),1,1,'') as dlpContents,
		  STUFF((SELECT ';' + attrVal FROM DlpGroupProp as DLPGP, #DLPGroupClientMap as DLPGCM  WHERE DLPGP.groupid = DLPGCM.groupId AND DLPGCM.clientId=ac.id and DLPGP.attrName = 'dlpFilters' AND DLPGP.modified = 0  FOR XML PATH('')),1,1,'') as dlpFilters,
		  ac.name,
		  (SELECT MAX(attrVal) FROM DlpGroupProp as DLPGP, #DLPGroupClientMap as DLPGCM  WHERE DLPGP.groupid = DLPGCM.groupId AND DLPGCM.clientId=ac.id and DLPGP.attrName = 'dlpEnableAutomaticDecryption' AND DLPGP.modified = 0) as dlpEnableAutomaticDecryption,
		  (SELECT MAX(attrVal) FROM DlpGroupProp as DLPGP, #DLPGroupClientMap as DLPGCM  WHERE DLPGP.groupid = DLPGCM.groupId AND DLPGCM.clientId=ac.id and DLPGP.attrName = 'dlpUnlockMethod' AND DLPGP.modified = 0) as dlpUnlockMethod,
          ac.displayname
	  from
		  APP_Client ac, #DLPGroupClientMap DLPGCM WITH (NOLOCK)
	  where ac.id=DLPGCM.clientId AND
		(ac.status & 4096)=4096 AND
ac.simOperatingSystemId in (2,3,
21, 94,
24, 34 ,
62, 65 ,
93, 200,
208, 209,
48, 46, 64,
67, 210, 211)
      -- merge results from DLP groups and DLP clients, taking care that if a client is a DLP client in a DLP group, the DLP client's settings will completely overwrite the DLP group settings.
	  IF object_id('tempdb.dbo.#DLPMergedResults') IS NOT null DROP TABLE #DLPMergedResults
	  CREATE TABLE #DLPMergedResults
	  (
	        clientId                        INT NOT NULL,
			dlpStolen			            INT,
			dlpScanIntervalMins	            INT,
			dlpMinFileAgeMins	            INT,
			dlpContents			            NVARCHAR(MAX),
			dlpFilters			            NVARCHAR(MAX),
			clientName			            NVARCHAR(MAX),
			dlpEnableAutomaticDecryption	INT,
			dlpUnlockMethod			        INT,
            clientDisplayName               NVARCHAR(MAX)
		)
	  INSERT INTO #DLPMergedResults (clientId, dlpStolen,dlpScanIntervalMins,dlpMinFileAgeMins,dlpContents,
                                     dlpFilters,clientName,dlpEnableAutomaticDecryption,dlpUnlockMethod, clientDisplayName)
			select DISTINCT
			  ac.id,
			  apStolen.attrVal as dlpStolen,
			  apScanIntervalMins.attrVal as dlpScanIntervalMins,
			  apMinFileAgeMins.attrVal as dlpMinFileAgeMins,
			  apContents.attrVal as dlpContents,
			  apFilters.attrVal as dlpFilters,
			  ac.name,
			  apEnableAutomaticDecryption.attrVal as dlpEnableAutomaticDecryption,
			  apUnlockMethod.attrVal as dlpUnlockMethod,
              ac.displayname as clientDisplayName
			 from
			   APP_Client ac,
			   APP_ClientProp apEnabled WITH (NOLOCK),
			   APP_ClientProp apStolen WITH (NOLOCK),
			   APP_ClientProp apScanIntervalMins WITH (NOLOCK),
			   APP_ClientProp apMinFileAgeMins WITH (NOLOCK),
			   APP_ClientProp apContents WITH (NOLOCK),
			   APP_ClientProp apFilters WITH (NOLOCK),
			   APP_ClientProp apEnableAutomaticDecryption WITH (NOLOCK),
			   APP_ClientProp apUnlockMethod WITH (NOLOCK)
			where apContents.componentNameId=ac.id AND
			       apContents.attrName='dlpContents' AND
			       apFilters.componentNameId=ac.id AND
			       apFilters.attrName='dlpFilters' AND
			       apStolen.componentNameId=ac.id AND
			       apStolen.attrName='dlpStolen' AND
			       apEnableAutomaticDecryption.componentNameId=ac.id AND
			       apEnableAutomaticDecryption.attrName='dlpEnableAutomaticDecryption' AND
			       apUnlockMethod.componentNameId=ac.id AND
			       apUnlockMethod.attrName='dlpUnlockMethod' AND
			       apScanIntervalMins.componentNameId=ac.id AND
			       apScanIntervalMins.attrName='dlpScanIntervalMins' AND
			       apMinFileAgeMins.componentNameId=ac.id AND
			       apMinFileAgeMins.attrName='dlpMinFileAgeMins' AND
			       apEnabled.componentNameId=ac.id AND
				   apEnabled.attrName = 'enableDLP' AND
				   apEnabled.attrVal = '1' AND
			       (ac.status & 4096)=4096 AND
				   (ac.id in (select t_clId from @tblClients) OR @userId<=0)
	  -- insert results from #DLPGroupClientResults ONLY if the client is not already in the table
      INSERT INTO #DLPMergedResults (clientId, dlpStolen,dlpScanIntervalMins,dlpMinFileAgeMins,dlpContents,dlpFilters,clientName,dlpEnableAutomaticDecryption,dlpUnlockMethod, clientDisplayName)
        select clientId, dlpStolen,dlpScanIntervalMins,dlpMinFileAgeMins,dlpContents,dlpFilters,clientName,dlpEnableAutomaticDecryption,dlpUnlockMethod, clientDisplayName
                from #DLPGroupClientResults dgcr
	    where dgcr.clientId not in (select clientId from #DLPMergedResults) AND
				   (dgcr.clientId in (select t_clId from @tblClients) OR @userId<=0)
	  select clientId, 0, 1, 0, dlpStolen, dlpScanIntervalMins, dlpMinFileAgeMins, dlpEnableAutomaticDecryption, dlpUnlockMethod,
             dlpContents, dlpFilters, '', clientName, clientDisplayName from #DLPMergedResults
		IF @userId > 0
		BEGIN
   			DROP TABLE #rptUserObjects
		END
	  IF object_id('tempdb.dbo.#DLPGroupClientResults') IS NOT null DROP TABLE #DLPGroupClientResults
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
IF @clientId>0
	SELECT @clientId,@errorCode, @enableDLP, @dlpEnableClientKeys, @dlpStolen, @dlpScanIntervalMins, @dlpMinFileAgeMins, @dlpEnableAutomaticDecryption, @dlpUnlockMethod, @dlpContents, @dlpFilters, @errorString, '', @clientDisplayName
GO

IF EXISTS (select * from GxQscripts where name = 'GetDLPProp')
	delete from GxQscripts where name = 'GetDLPProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDLPProp')
	delete from GXDBVersions where aliasname = 'GetDLPProp'
GO

insert into GXDBVersions values(2, 'GetDLPProp',  '00000000000000000000', 'GetDLPProp', '00000000000000000000')
GO

