

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDIPInfoForFWGeneration.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetDIPInfoForFWGeneration')
BEGIN
	print '>>> Drop Stored Procedure: GetDIPInfoForFWGeneration <<<'
	drop procedure GetDIPInfoForFWGeneration
END
IF EXISTS (select * from GxQscripts where name='GetDIPInfoForFWGeneration')
	delete from GxQscripts where name = 'GetDIPInfoForFWGeneration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDIPInfoForFWGeneration')
	delete from GXDBVersions where aliasname = 'GetDIPInfoForFWGeneration'
GO
print '... Creating Procedure: GetDIPInfoForFWGeneration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetDIPInfoForFWGeneration
/*
*	This SP retrieves DIP information for the given client.
*	Parameters: i_clientId Client ID whose DIP information has to be retreived
*/
  @i_clientId INTEGER
AS
  DECLARE @srcClientName NVARCHAR (255)
  DECLARE @srcInterface NVARCHAR (255)
  DECLARE @destClientName NVARCHAR (255)
  DECLARE @destInterface NVARCHAR (255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @i_clientId < 1
	RETURN
SELECT CASE
			WHEN APL.srcClientId=@i_clientId
			THEN
				SrcAC.name
			ELSE
				DestAC.name
			END
			AS srcClientName,
		CASE
			WHEN APL.srcClientId=@i_clientId
			THEN
				APL.srcInterface
			ELSE
				APL.destInterface
			END
			AS srcInterface,
		CASE
			WHEN APL.srcClientId=@i_clientId
			THEN
				DestAC.name
			ELSE
				SrcAC.name
			END
			AS destClientName,
		CASE
			WHEN APL.srcClientId=@i_clientId
			THEN
				APL.destInterface
			ELSE
				APL.srcInterface
			END
			AS destInterface
FROM archPipelineFirewall APL
INNER JOIN App_Client SrcAC
ON APL.srcClientId=SrcAC.id
INNER JOIN APP_Client DestAC
ON APL.destClientId=DestAC.id
WHERE APL.srcClientId=@i_clientId OR APL.destClientId=@i_clientId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetDIPInfoForFWGeneration')
	delete from GxQscripts where name = 'GetDIPInfoForFWGeneration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDIPInfoForFWGeneration')
	delete from GXDBVersions where aliasname = 'GetDIPInfoForFWGeneration'
GO

insert into GXDBVersions values(2, 'GetDIPInfoForFWGeneration',  '00000000000000000000', 'GetDIPInfoForFWGeneration', '00000000000000000000')
GO

