

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDAHoldClientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetDAHoldClientList.sp,v $ $Id: GetDAHoldClientList.sp,v 1.7.2.4 2020/09/17 01:59:03 bzhu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "GetDAHoldClientList"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetDAHoldClientList')
BEGIN
	print '>>> Drop Stored Procedure: GetDAHoldClientList <<<'
	drop procedure GetDAHoldClientList
END
IF EXISTS (select * from GxQscripts where name='GetDAHoldClientList')
	delete from GxQscripts where name = 'GetDAHoldClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDAHoldClientList')
	delete from GXDBVersions where aliasname = 'GetDAHoldClientList'
GO
print '... Creating Procedure: GetDAHoldClientList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetDAHoldClientList
  @inClientId INTEGER
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
AS
  DECLARE @o_clientId integer
  DECLARE @o_reasonId integer
BEGIN TRY
	SET NOCOUNT ON
	DECLARE @clientTable TABLE ( id integer, reasonId integer)
	DECLARE @usersOnHoldTbl TABLE ( userId integer)
	IF( @inClientId > 0)
	BEGIN
		-- Clients hold from client group level
		INSERT INTO @clientTable
		select DISTINCT clientId, 2
		From APP_ClientGroupAssoc(NOLOCK) A, App_Client(NOLOCK) B
		where
		B.id = @inClientId And
		A.clientId = B.id And
		A. clientGroupId in (
		select clientGroupId From JMJobAction
		where opType = 10/*PRUNE*/ and clientGroupId <> 0 and clientId = 1 and mediaAgentID = 1 and appId = 1 and appType = 0 and action = 1/*DISABLEACTIVITY*/
		) and clientId NOT In (select id from @clientTable)
		-- Clients on hold
		INSERT INTO @clientTable
		select distinct clientId, 3 From JMJobAction
		where opType = 10/*PRUNE*/ and clientId = @inClientId and mediaAgentID = 1 and appId = 1 and appType = 0 and clientGroupId = 0 and instanceID = 1 and action = 1/*DISABLEACTIVITY*/
		and clientId NOT In (select id from @clientTable)
		IF OBJECT_ID('tempdb.dbo.#tmpGetDAHoldClientListOutputTbl') IS NOT NULL
		BEGIN
			-- clean up data
			DELETE FROM #tmpGetDAHoldClientListOutputTbl
			-- dump into external inputted table
			IF EXISTS (SELECT * FROM @clientTable)
				INSERT INTO #tmpGetDAHoldClientListOutputTbl
				SELECT id, reasonId FROM @clientTable
			ELSE
				INSERT INTO #tmpGetDAHoldClientListOutputTbl
				SELECT @inClientId, 0
		END
		ELSE
		BEGIN
			IF EXISTS (SELECT * FROM @clientTable)
				SELECT id, reasonId FROM @clientTable
			ELSE
				SELECT @inClientId, 0
		END
	END
	ELSE
	BEGIN
		-- Fetch the clients that are on hold from CaseManager
		IF object_id('tempdb.dbo.#userClientIdTbl') IS NOT NULL
			DROP TABLE #userClientIdTbl
		DECLARE @refClientId integer
		DECLARE @caseInfo XML
		CREATE TABLE #userClientIdTbl ( id integer, appId integer, holdType integer)
		Declare caseCur CURSOR FOR
		select RefCopyClientId, caseXml from DM2CaseInfo where ISNull(RefCopyClientId, 0) > 0 And Exists(select 1 From APP_ClientProp where componentNameId = RefCopyClientId And attrName = 'ReferenceCopyClientType' And modified = 0 And CAST(attrVal as int) = 1)
		And status = 1/*OPEN*/
		Open caseCur;
		Fetch Next From caseCur Into @refClientId, @caseInfo
		While @@FETCH_STATUS = 0
		BEGIN
			Exec DM2GetAllCaseClients @caseInfo
			--Exec PopulateCaseManagerAssociations @refClientId, @caseInfo
			Fetch Next From caseCur Into @refClientId, @caseInfo
		END
		CLOSE caseCur
		DEALLOCATE caseCur
		Insert into @clientTable
		Select id, 1 from #userClientIdTbl
		DROP TABLE #userClientIdTbl
		-- Clients hold from client group level
		INSERT INTO @clientTable
		select DISTINCT clientId, 2 From APP_ClientGroupAssoc(NOLOCK)
		where clientGroupId in (
		select clientGroupId From JMJobAction
		where opType = 10/*PRUNE*/ and clientGroupId <> 0 and clientId = 1 and mediaAgentID = 1 and appId = 1 and appType = 0 and action = 1/*DISABLEACTIVITY*/
		) and clientId NOT In (select id from @clientTable)
		-- Clients on hold
		INSERT INTO @clientTable
		select distinct clientId, 3 From JMJobAction
		where opType = 10/*PRUNE*/ and clientId <> 1 and mediaAgentID = 1 and appId = 1 and appType = 0 and clientGroupId = 0 and instanceID = 1 and action = 1/*DISABLEACTIVITY*/
		and clientId NOT In (select id from @clientTable)
		IF OBJECT_ID('tempdb.dbo.#tmpGetDAHoldClientListOutputTbl') IS NOT NULL
		BEGIN
			-- clean up data
			DELETE FROM #tmpGetDAHoldClientListOutputTbl
			-- dump into external inputted table
			INSERT INTO #tmpGetDAHoldClientListOutputTbl
			SELECT distinct * From @clientTable
		END
		ELSE
		BEGIN
			SELECT distinct * From @clientTable
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT -1, -1
   ;THROW -- Re-Throw the execption to the caller
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetDAHoldClientList')
	delete from GxQscripts where name = 'GetDAHoldClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDAHoldClientList')
	delete from GXDBVersions where aliasname = 'GetDAHoldClientList'
GO

insert into GXDBVersions values(2, 'GetDAHoldClientList',  '00010007000200040000', 'GetDAHoldClientList', '00010007000200040000')
GO

