

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetDAHoldAppIdList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetDAHoldAppIdList.sp,v $ $Id: GetDAHoldAppIdList.sp,v 1.1.2.6 2020/09/17 01:58:59 bzhu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "GetDAHoldAppIdList"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetDAHoldAppIdList')
BEGIN
	print '>>> Drop Stored Procedure: GetDAHoldAppIdList <<<'
	drop procedure GetDAHoldAppIdList
END
IF EXISTS (select * from GxQscripts where name='GetDAHoldAppIdList')
	delete from GxQscripts where name = 'GetDAHoldAppIdList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDAHoldAppIdList')
	delete from GXDBVersions where aliasname = 'GetDAHoldAppIdList'
GO
print '... Creating Procedure: GetDAHoldAppIdList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetDAHoldAppIdList
-- ----------------------------------------------------------------------
-- This SP returns list of subclients with DataAging activity disabled
-- ----------------------------------------------------------------------
AS
  DECLARE @o_appId integer
BEGIN TRY
	SET NOCOUNT ON
DECLARE @drInstanceID       INT =  ISNULL((SELECT TOP 1 instance FROM APP_Application (NOLOCK) WHERE appTypeId= 1000) , 1)
	CREATE TABLE #SubClientIdList (id INT PRIMARY KEY)
	INSERT INTO #SubClientIdList
	SELECT	DISTINCT A.id
	FROM	APP_Application A WITH (NOLOCK), JMJobAction JA WITH (NOLOCK)
	WHERE	A.id = JA.appId
	AND		JA.opType = 10 /*PRUNE*/
	AND 	JA.action = 1  /*DISABLEACTIVITY*/
	AND 	JA.clientId = 1
	AND 	JA.appType = 0
	AND 	JA.mediaAgentId = 1
	AND 	JA.clientGroupId=0
	AND 	JA.instanceID = @drInstanceID
	if object_id('tempdb.dbo.#tmpGetDAHoldClientListOutputTbl') is not null
		DROP TABLE #tmpGetDAHoldClientListOutputTbl
	CREATE	TABLE #tmpGetDAHoldClientListOutputTbl(clientId INTEGER, reasonId INTEGER)
	CREATE INDEX Idx_tmpGetDAHoldClientListOutputTbl_1 ON #tmpGetDAHoldClientListOutputTbl(clientId)
	-- clients with Data aging disabled
	EXEC GetDAHoldClientList 0
	-- for VSA V2 clients, need to get VM subclients backed up by these VSA clients
	INSERT INTO #SubClientIdList
	SELECT DISTINCT vmAppl.id FROM app_vmbackupset vmb
	INNER JOIN App_ClientProp clProp ON clProp.componentNameId = vmb.VMClientId AND clProp.attrName = N'VSA Discover Subclient ID'/*VSA_DISCOVER_CLIENT_PROP_SQL*/ AND clProp.modified = 0
	INNER JOIN APP_Application appl ON appl.backupSet = vmb.ParentBackupSetId AND CAST(Appl.id AS NVARCHAR(12)) = clProp.attrVal
	INNER JOIN APP_Application vmAppl ON vmAppl.backupSet=vmb.ChildBackupSetId AND (vmAppl.subclientStatus & 0x00008 = 0x00008)
	INNER JOIN JMJobDataLink LNK ON LNK.parentAppid = appl.id AND LNK.childAppid = vmAppl.id
	WHERE appl.clientId IN (SELECT DISTINCT clientId FROM #tmpGetDAHoldClientListOutputTbl)
	SELECT * FROM #SubClientIdList
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT -1
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetDAHoldAppIdList')
	delete from GxQscripts where name = 'GetDAHoldAppIdList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetDAHoldAppIdList')
	delete from GXDBVersions where aliasname = 'GetDAHoldAppIdList'
GO

insert into GXDBVersions values(2, 'GetDAHoldAppIdList',  '00010001000200060000', 'GetDAHoldAppIdList', '00010001000200060000')
GO

