

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetCredentialsFromCredentialAssocIds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetCredentialsFromCredentialAssocIds.sp,v $ $Id: GetCredentialsFromCredentialAssocIds.sp,v 1.1.2.1 2020/02/11 10:59:13 scheppuri Exp $";
--  +===============================================================================================================================================+
--  | GetCredentialsFromCredentialAssocIds.sp - Update #tmpCredentials with the right credentials from credential association Id			|
--  +===============================================================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetCredentialsFromCredentialAssocIds')
BEGIN
	print '>>> Drop Stored Procedure: GetCredentialsFromCredentialAssocIds <<<'
	drop procedure GetCredentialsFromCredentialAssocIds
END
IF EXISTS (select * from GxQscripts where name='GetCredentialsFromCredentialAssocIds')
	delete from GxQscripts where name = 'GetCredentialsFromCredentialAssocIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCredentialsFromCredentialAssocIds')
	delete from GXDBVersions where aliasname = 'GetCredentialsFromCredentialAssocIds'
GO
print '... Creating Procedure: GetCredentialsFromCredentialAssocIds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetCredentialsFromCredentialAssocIds
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
-----------------------------------------------------------
  @i_credentialAssocId INT,
  @o_userName NVARCHAR(512)  OUTPUT,
  @o_userPassword NVARCHAR(1024) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Table to hold v3 password
CREATE TABLE #tmpV3PasswordCred
( credentialId INT NOT NULL PRIMARY KEY,
	userName VARCHAR(1024),
	userPassword VARCHAR(2048) )
IF OBJECT_ID('tempdb.dbo.#tmpCredentials') IS NOT NULL
	-- Insert distinct credential Ids
	INSERT INTO #tmpV3PasswordCred
		SELECT DISTINCT ASSOC.credentialId AS credentialId, '' AS userName, '' AS userPassword
		FROM #tmpCredentials TMP
		INNER JOIN APP_CredentialAssoc ASSOC
		ON TMP.credentialAssocId = ASSOC.assocId
		WHERE TMP.credentialAssocId > 0
ELSE IF (@i_credentialAssocId <> 0)
	INSERT INTO #tmpV3PasswordCred
		SELECT DISTINCT ASSOC.credentialId AS credentialId, '' AS userName, '' AS userPassword
		FROM APP_CredentialAssoc ASSOC
		WHERE ASSOC.assocId = @i_credentialAssocId
IF @@ROWCOUNT > 0
BEGIN
	-- Update user name and convert to V3 password
	UPDATE 	V3
	SET 	V3.userName = CRED.userName,
			V3.userPassword = dbo.pswConvertV5ToV3(CRED.password)
	FROM 	#tmpV3PasswordCred V3
			INNER JOIN APP_Credentials CRED ON V3.credentialId = CRED.credentialId
	-- Update the main temp table
	IF OBJECT_ID('tempdb.dbo.#tmpCredentials') IS NOT NULL
		UPDATE 	TMP
		SET		TMP.userName =  V3.userName,
				TMP.userPassword = V3.userPassword
		FROM 	#tmpCredentials  TMP
				INNER JOIN APP_CredentialAssoc ASSOC ON TMP.credentialAssocId = ASSOC.assocId
				INNER JOIN #tmpV3PasswordCred V3 ON ASSOC.credentialID = V3.credentialId
		WHERE 	TMP.credentialAssocId > 0
	ELSE IF (@i_credentialAssocId <> 0)
	BEGIN
		SELECT @o_userPassword  = (SELECT userPassword FROM #tmpV3PasswordCred)
		SELECT @o_userName      = (SELECT userName FROM #tmpV3PasswordCred)
	END
END
IF OBJECT_ID('tempdb.dbo.#tmpV3PasswordCred') IS NOT NULL
DROP TABLE #tmpV3PasswordCred
GO

IF EXISTS (select * from GxQscripts where name = 'GetCredentialsFromCredentialAssocIds')
	delete from GxQscripts where name = 'GetCredentialsFromCredentialAssocIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCredentialsFromCredentialAssocIds')
	delete from GXDBVersions where aliasname = 'GetCredentialsFromCredentialAssocIds'
GO

insert into GXDBVersions values(2, 'GetCredentialsFromCredentialAssocIds',  '00010001000200010000', 'GetCredentialsFromCredentialAssocIds', '00010001000200010000')
GO

