

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetCostCategories.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetCostCategories.sp,v $ $Id: GetCostCategories.sp,v 1.7 2010/04/21 12:46:29 dnavaneethan Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetCostCategories <<<'

IF EXISTS (select * from sysobjects where name='GetCostCategories')
	drop procedure GetCostCategories
IF EXISTS (select * from GxQscripts where name='GetCostCategories')
	delete from GxQscripts where name = 'GetCostCategories'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCostCategories')
	delete from GXDBVersions where aliasname = 'GetCostCategories'
GO
print '... Creating Procedure: GetCostCategories'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetCostCategories
-- Input
  @CategoryType int
AS
SELECT	1			as TAG,
	NULL			as Parent,
	NULL			as [QSMGui_SRMGetAllCostCategoryResp!1!],
	NULL			as [costCategories!2!id],
	NULL			as [costCategories!2!categoryGUID],
	NULL			as [costCategories!2!categoryName],
	NULL			as [costCategories!2!description],
	NULL			as [costCategories!2!costperMB],
	NULL			as [costCategories!2!dataSizeUnit]
UNION ALL
SELECT	2,
		1,
		NULL,
		BCC.CostCategoryID,
		BCC.CatGUID,
		BCC.DisplayName,
		BCC.Description,
		CAST(CONVERT(MONEY, (CAST(BCC.UnitCost AS FLOAT) / 10000), 0) AS FLOAT),
		BCC.UnitType
FROM BLCostCategory AS BCC
WHERE (
	--(@CategoryType = 0 OR (@CategoryType = 1 AND BCC.CategoryType = 1))
	BCC.CategoryType  = @CategoryType
	)
ORDER BY [costCategories!2!categoryName]
FOR XML EXPLICIT
-- The XML output string will look like:
--
-- <QSMGui_SRMGetAllCostCategoryResp>
--	 <costCategories categoryGUID="ABCD-EFGH-IJKL-MNOP" categoryName="Test" description="Test testing the cost Category" cost= 100 />
--     ....
-- </QSMGui_SRMGetAllCostCategoryResp>
GO

IF EXISTS (select * from GxQscripts where name = 'GetCostCategories')
	delete from GxQscripts where name = 'GetCostCategories'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCostCategories')
	delete from GXDBVersions where aliasname = 'GetCostCategories'
GO

insert into GXDBVersions values(2, 'GetCostCategories',  '00010007000000000000', 'GetCostCategories', '00010007000000000000')
GO

