

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetCopyForRegularOrBCDIndexMA.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  GetCopyForRegularOrBCDIndexMA.sp                           */
/*                                                                            */
/*  Description :  Get the preferred copyId based on Index availability		  */
/*                 This is a part of code moved from 						  */
/*		   		   int ArchiveManagerCS::getRegularOrBCDIndexMediaAgent		  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetCopyForRegularOrBCDIndexMA.sp,v $ $Id: GetCopyForRegularOrBCDIndexMA.sp,v 1.3.32.6 2018/07/02 02:25:34 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetCopyForRegularOrBCDIndexMA <<<'

IF EXISTS (select * from sysobjects where name='GetCopyForRegularOrBCDIndexMA')
	drop procedure GetCopyForRegularOrBCDIndexMA
IF EXISTS (select * from GxQscripts where name='GetCopyForRegularOrBCDIndexMA')
	delete from GxQscripts where name = 'GetCopyForRegularOrBCDIndexMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCopyForRegularOrBCDIndexMA')
	delete from GXDBVersions where aliasname = 'GetCopyForRegularOrBCDIndexMA'
GO
print '... Creating Procedure: GetCopyForRegularOrBCDIndexMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetCopyForRegularOrBCDIndexMA
  @i_appId INTEGER,
  @i_copyPrecedence INTEGER
AS
  DECLARE @o_retCode integer = 0;
  DECLARE @o_archGrpId integer = 0;
  DECLARE @o_copyId integer = 0;
  DECLARE @o_clientId integer = 0;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @tempCTime int = 0
	DECLARE @fileType int = 0
	DECLARE @indexStatus int = 0
	/*
		We find the latest index AF's cTime available(regular(2) or BCD(6)) for the subclient and see if we have both regular and BCD index in the same cTime to decide
		which copies to consider.
		@indexStatus - 1 --get only non snap copy
		@indexStatus - 2 --get only snap copy
		@indexStatus - 0 --don't bother
	*/
	IF @i_copyPrecedence > 0
	BEGIN
		SELECT top 1 @tempCTime = AF.cTime, @o_archGrpId = AF.archGroupId, @fileType = AF.fileType
		FROM ArchFile AF WITH(NOLOCK) INNER JOIN ArchGroup AG WITH(NOLOCK) ON AF.archGroupId = AG.id INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON AG.id = AGC.archGroupId
WHERE AF.appId = @i_appId AND AF.isValid = 1 AND AF.fileType IN (2, 6)
AND AGC.copy = @i_copyPrecedence AND AGC.type <> 5
		ORDER BY AF.cTime DESC, AF.fileType DESC
		SET @o_retCode = @@ERROR
		IF @o_retCode <> 0
			GOTO CX_EXIT
	 END
	/*If archGrpId is 0 here it's either that @i_copyPrecedence <= 0 or we did not find a storage policy in first query. Let's fallback to second query.*/
	If @o_archGrpId = 0
	BEGIN
		SELECT top 1 @tempCTime = cTime, @o_archGrpId = archGroupId, @fileType = fileType
		FROM ArchFile WITH(NOLOCK)
WHERE appId = @i_appId AND isValid = 1 AND fileType IN (2, 6)
		ORDER BY cTime DESC, fileType DESC
		SET @o_retCode = @@ERROR
		IF @o_retCode <> 0
			GOTO CX_EXIT
	END
/*If the 1st AF is of fileType - 2 then we won't have an AF of fileType - 6 (see orderBy) so set the status 1 and go ahead*/
IF @fileType = 2
	BEGIN
		SET @indexStatus = 1 --get only non snap copy
	END
ELSE IF @fileType = 6
	BEGIN
/*If the 1st AF is of fileType - 6 then check if we have an AF of fileType 2 with same cTime and set status accordingly*/
		SET @indexStatus = 2 --get only snap copy
IF EXISTS(SELECT 1 FROM ArchFile WITH(NOLOCK) WHERE appId = @i_appId AND isValid = 1 AND fileType = 2 AND archGroupId = @o_archGrpId AND cTime = @tempCTime)
			SET @indexStatus = 0 --can be snap or non-snap copy
	END
	SELECT @o_archGrpId = CASE WHEN @o_archGrpId = 0 THEN dataArchGrpId ELSE @o_archGrpId END, @o_clientId = clientId
	FROM App_Application WITH(NOLOCK) WHERE id = @i_appId
	SET @o_retCode = @@ERROR
	IF @o_retCode <> 0
		GOTO CX_EXIT
	--ArchGroup of id 1 is CV_DEFAULT
	IF(@o_archGrpId <= 1)
	BEGIN
SET @o_retCode = 3
		GOTO CX_EXIT
	END
	IF @i_copyPrecedence = 0
	BEGIN
		IF EXISTS(SELECT 1 FROM archGroupCopy WITH(NOLOCK) WHERE siloAppId = @i_appId)
		BEGIN
			/*If it is siloAppId let us consider only silo copy and secondary silo copies*/
			DECLARE @primarySiloCopy int
SELECT @primarySiloCopy = id FROM archGroupCopy WITH(NOLOCK) WHERE siloAppId = @i_appId and flags & 524288 > 0
			SET @o_retCode = @@ERROR
			IF @o_retCode <> 0
				GOTO CX_EXIT
			SELECT top 1 @o_copyId = id FROM archGroupCopy WITH(NOLOCK)
WHERE archGroupId = @o_archGrpId AND (id = @primarySiloCopy OR (sourceCopyId = @primarySiloCopy AND extendedFlags & 8 > 0))
AND type <> 5
			ORDER BY Copy
			SET @o_retCode = @@ERROR
			IF @o_retCode <> 0
				GOTO CX_EXIT
		END
		ELSE
		BEGIN
			/*
			@indexStatus - 1 --get only non snap copy
			@indexStatus - 2 --get only snap copy
			@indexStatus - 0 --don't bother
			*/
			SELECT top 1 @o_copyId = id FROM archGroupCopy WITH(NOLOCK)
WHERE archGroupId = @o_archGrpId AND flags & 524288 = 0 AND extendedFlags & 8 = 0
			AND (@indexStatus = 0 OR (@indexStatus = 1 AND isSnapCopy = 0) OR (@indexStatus = 2 AND isSnapCopy = 1))
AND type <> 5
			ORDER BY Copy
			SET @o_retCode = @@ERROR
			IF @o_retCode <> 0
				GOTO CX_EXIT
		END
	END
	ELSE
	BEGIN
		SELECT top 1 @o_copyId = AGC.id FROM archGroupCopy AGC WITH(NOLOCK) INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
WHERE AGC.archGroupId = @o_archGrpId AND (AGC.copy = @i_copyPrecedence OR (AGC.id = AG.defaultCopy AND @i_copyPrecedence = -1) OR
(@i_copyPrecedence = -4 AND AGC.isSnapCopy = 0) OR
(@i_copyPrecedence = -5 AND AGC.id = AG.defaultSnapCopy AND AGC.isSnapCopy = 1))
AND AGC.type <> 5
		ORDER BY AGC.copy
		SET @o_retCode = @@ERROR
		IF @o_retCode <> 0
			GOTO CX_EXIT
		IF @o_copyId = 0
		BEGIN
SET @o_retCode = 56
			GOTO CX_EXIT
		END
	END
SET @o_retCode = 0
CX_EXIT:
SELECT @o_retCode, @o_archGrpId, @o_copyId, @o_clientId
GO

IF EXISTS (select * from GxQscripts where name = 'GetCopyForRegularOrBCDIndexMA')
	delete from GxQscripts where name = 'GetCopyForRegularOrBCDIndexMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetCopyForRegularOrBCDIndexMA')
	delete from GXDBVersions where aliasname = 'GetCopyForRegularOrBCDIndexMA'
GO

insert into GXDBVersions values(2, 'GetCopyForRegularOrBCDIndexMA',  '00010003003200060000', 'GetCopyForRegularOrBCDIndexMA', '00010003003200060000')
GO

