

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientsForPackageForUser.sp] ---------- 

--  +==================================================================================================================================================+
--  | Stored Procedure: List all clients which have this package/apptype installed and visible to the specified user. It includes restore only agents. |
--  +==================================================================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetClientsForPackageForUser')
BEGIN
	print '>>> Drop Stored Procedure: GetClientsForPackageForUser <<<'
	drop procedure GetClientsForPackageForUser
END
IF EXISTS (select * from GxQscripts where name='GetClientsForPackageForUser')
	delete from GxQscripts where name = 'GetClientsForPackageForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientsForPackageForUser')
	delete from GXDBVersions where aliasname = 'GetClientsForPackageForUser'
GO
print '... Creating Procedure: GetClientsForPackageForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientsForPackageForUser
  @inputxml XML,
  @userId INT = NULL
AS
    SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Clients') IS NOT NULL DROP TABLE #ClientsForPackage_tmp__Clients
    IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Visible') IS NOT NULL DROP TABLE #ClientsForPackage_tmp__Visible
    CREATE TABLE #ClientsForPackage_tmp__Clients (clientId INT PRIMARY KEY, clientName NVARCHAR (510))
    CREATE TABLE #ClientsForPackage_tmp__Visible (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
    DECLARE @vendor INT = ISNULL((SELECT ref.value('@vendor', 'INT') FROM @inputxml.nodes('TMMsg_GetClientsForPackage') R(ref)), 0)
    -- get list of clients according to the request
    EXEC GetClientsForPackage @inputxml
	DECLARE @disableUseProxyCheck INT = 0
SET @disableUseProxyCheck = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DisableUseProxyCheck'),0)
    -- get list of clients visible to the user
	IF @disableUseProxyCheck = 1
	BEGIN
		-- This is replaced by the "Use Proxy" check below
		EXEC sec_getIdaObjectsForUser @userId, 3, 0, 0, '#ClientsForPackage_tmp__Visible'
	END
	IF @disableUseProxyCheck = 0
	BEGIN
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable CREATE TABLE #getPermissionsOnEntities_InputTable ( entityId1 INT, entityId2 INT DEFAULT 0, entityId3 INT DEFAULT 0, entityId4 INT DEFAULT 0, entityId5 INT DEFAULT 0 ) IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable CREATE TABLE #getPermissionsOnEntities_OutputTable ( entityId1 INT, entityId2 INT, entityId3 INT, entityId4 INT, entityId5 INT, permissionsString VARCHAR(512), isChildRow BIT DEFAULT 0	        )
		INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
		SELECT clientId, 0, 0, 0,0 FROM #ClientsForPackage_tmp__Clients
EXEC sec_getPermissionsOnEntities @userId, 3
		DELETE FROM #getPermissionsOnEntities_OutputTable
WHERE (SUBSTRING(permissionsString,252,1) != CAST(1 AS NVARCHAR(1))) AND
(SUBSTRING(permissionsString,2,1) != CAST(1 AS NVARCHAR(1)))
		INSERT INTO #ClientsForPackage_tmp__Visible
		SELECT entityId1,entityId2,entityId3,entityId4,entityId5 FROM #getPermissionsOnEntities_OutputTable
	END
	IF OBJECT_ID('tempdb.dbo.#ClientList') IS NOT NULL DROP TABLE #ClientList
	CREATE TABLE #ClientList (clientId INT PRIMARY KEY, clientName nvarchar(510), entityType int, hostName nvarchar(510), csGUID uniqueidentifier, displayName nvarchar(510))
	INSERT INTO #ClientList
	SELECT DISTINCT C.id,C.name,3,C.net_hostname,C.[GUID],c.[displayName]
    FROM    #ClientsForPackage_tmp__Clients S INNER JOIN #ClientsForPackage_tmp__Visible V ON V.clientId = S.clientId
	INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = S.clientId AND c.status & 0x00002 = 0
	IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Clients') IS NOT NULL DROP TABLE #ClientsForPackage_tmp__Clients
    IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Visible') IS NOT NULL DROP TABLE #ClientsForPackage_tmp__Visible
--
    -- create XML response including only clients present in both tables
       DECLARE @rv XML = (SELECT @vendor  AS '@vendor',
                            (SELECT DISTINCT CL.clientId                 AS '@clientId',
	                                            CL.clientName            AS '@clientName',
												 CL.entityType AS '@_type_',
                                                CL.hostName    AS '@hostName',
                                                CL.csGUID          AS '@csGUID',
												CL.displayName AS '@displayName'
												FROM #ClientList CL
			                    ORDER BY CL.clientName
                                FOR     XML PATH('clients'), TYPE)
                        FOR  XML PATH('TMMsg_GetClientsForPackage'))
    IF OBJECT_ID('tempdb.dbo.#ClientList') IS NOT NULL DROP TABLE #ClientList
    SELECT @rv
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientsForPackageForUser')
	delete from GxQscripts where name = 'GetClientsForPackageForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientsForPackageForUser')
	delete from GXDBVersions where aliasname = 'GetClientsForPackageForUser'
GO

insert into GXDBVersions values(2, 'GetClientsForPackageForUser',  '00000000000000000000', 'GetClientsForPackageForUser', '00000000000000000000')
GO

