

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientsForPackageForHealthCare.sp] ---------- 

--  +================================================================================================================+
--  | Stored Precedure: List all clients which have this packageinstalled. It includes restore only agents. |
--  +================================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetClientsForPackageForHealthCare')
BEGIN
	print '>>> Drop Stored Procedure: GetClientsForPackageForHealthCare <<<'
	drop procedure GetClientsForPackageForHealthCare
END
IF EXISTS (select * from GxQscripts where name='GetClientsForPackageForHealthCare')
	delete from GxQscripts where name = 'GetClientsForPackageForHealthCare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientsForPackageForHealthCare')
	delete from GXDBVersions where aliasname = 'GetClientsForPackageForHealthCare'
GO
print '... Creating Procedure: GetClientsForPackageForHealthCare'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientsForPackageForHealthCare
  @inputxml XML,
  @userId INT = NULL
AS
    DECLARE @packageId  INT = NULL
    DECLARE @debug      INT = 0
    DECLARE @clientsList AS TABLE
    (
        ClientId            INT                                        PRIMARY KEY,
        ClientName          NVARCHAR(510)                 DEFAULT(''),
        ClientHostName      NVARCHAR(510)                 DEFAULT(''),
        ClientGUID          UNIQUEIDENTIFIER    NOT null,
        ClinicalArchivingPort     INT
    )
    SET NOCOUNT ON
    IF OBJECT_ID('tempdb.dbo.#PseudoClientList_tmp__AssociatedObjects') IS NOT null DROP TABLE #PseudoClientList_tmp__AssociatedObjects
    --  temporary table taht will hold objects available for curent user.
create table  #PseudoClientList_tmp__AssociatedObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
    SET @packageId = ISNULL((SELECT ref.value('@packageId', 'INTEGER')
                                    FROM @inputxml.nodes('Api_GetClientsForPackageRequest') R(ref)), 0)
    IF @debug = 1 BEGIN
        SELECT '@packageId', @packageId
    END
    IF @packageId <> 0 BEGIN
        INSERT INTO @clientsList (ClientId, ClientName, ClientHostName, ClientGUID, ClinicalArchivingPort)
            SELECT  DISTINCT CL.id,    CL.name, CL.net_hostname, CL.GUID, CLPROP.attrVal
            FROM    simInstalledPackages SIP WITH(NOLOCK) INNER JOIN APP_Client          CL      WITH(NOLOCK) ON (CL.id = SIP.ClientId)
                                                          LEFT OUTER JOIN APP_ClientProp CLPROP  WITH(NOLOCK) ON (CLPROP.componentNameId = CL.id AND CLPROP.attrName = 'ClinicalArchivingPort')
            WHERE       SIP.simPackageID = @packageId
                    AND (CL.status & 0x8) = 0
    END
    IF @debug = 1 BEGIN
        SELECT 'client', * FROM @clientsList
    END
    IF @userId IS NOT NULL BEGIN
        EXEC sec_getUserObjects @userId, 0, 0, '#PseudoClientList_tmp__AssociatedObjects'
        IF @debug = 1 BEGIN
            SELECT 'association', * FROM #PseudoClientList_tmp__AssociatedObjects
        END
        IF NOT EXISTS(SELECT    1
                      FROM      #PseudoClientList_tmp__AssociatedObjects AO
                      WHERE     AO.commCellId = 2         AND AO.clientGroupId = 0 AND AO.clientId = 0      AND AO.appTypeId = 0             AND AO.instanceId = 0  AND
                                AO.backupsetId = 0        AND AO.subClientId = 0   AND AO.mediaAgentId = 0  AND AO.libraryId = 0             AND AO.archGroupId = 0 AND
                                AO.vtContainerId = 0      AND AO.vtPolicyId = 0    AND AO.vtShelfId = 0     AND AO.reviewSetId = 0           AND AO.querySetId = 0  AND
                                AO.downloadSetId = 0      AND AO.ermId = 0         AND AO.legalHoldId = 0   AND AO.tagId = 0                 AND AO.cdPolicyId = 0  AND
                                AO.complianceReportId = 0 AND AO.taskId = 0        AND AO.workflowId = 0    AND AO.logMonitoringPolicyId = 0 AND AO.arrayId = 0     AND
                                AO.cloudId = 0            AND AO.userGroupId = 0   AND AO.providerId = 0    AND AO.entityId1 = 0             AND AO.entityId2 = 0   AND
                                AO.entityId3 = 0          AND AO.entityId4 = 0     AND AO.entityId5 = 0     AND AO.entityId6 = 0             AND AO.entityId7 = 0   AND
                                AO.entityId8 = 0          AND AO.entityId9 = 0) BEGIN
            DELETE FROM @clientsList
            WHERE       ClientId NOT IN (SELECT CL.ClientId
                                         FROM   #PseudoClientList_tmp__AssociatedObjects AO INNER JOIN @clientsList CL ON AO.clientId = CL.ClientId)
        END
        IF @debug = 1 BEGIN
            SELECT 'filtered client', * FROM @clientsList
        END
    END
    DECLARE @rv XML = (SELECT
                            (SELECT
                               C.ClinicalArchivingPort   AS  '@clinicalArchivingPort',
                              (SELECT DISTINCT C.ClientId          AS '@clientId',
                                               C.ClientName        AS '@clientName',
                                               'CLIENT_ENTITY'     AS '@_type_',
                                               C.ClientHostName    AS '@hostName',
                                               C.ClientGUID        AS '@csGUID'
                               FOR     XML PATH('client'), TYPE)
                                    FROM    @clientsList C
                                ORDER BY C.ClientName
                       FOR XML PATH('clients'), TYPE)
                       FOR  XML PATH('Api_GetClientsForPackageResponse'))
    IF OBJECT_ID('tempdb.dbo.#PseudoClientList_tmp__AssociatedObjects') IS NOT null DROP TABLE #PseudoClientList_tmp__AssociatedObjects
    SELECT @rv
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientsForPackageForHealthCare')
	delete from GxQscripts where name = 'GetClientsForPackageForHealthCare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientsForPackageForHealthCare')
	delete from GXDBVersions where aliasname = 'GetClientsForPackageForHealthCare'
GO

insert into GXDBVersions values(2, 'GetClientsForPackageForHealthCare',  '00000000000000000000', 'GetClientsForPackageForHealthCare', '00000000000000000000')
GO

