

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientsForPackage.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: List all clients which have this package/apptype installed. It includes deconfigured and restire only agents.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetClientsForPackage')
BEGIN
	print '>>> Drop Stored Procedure: GetClientsForPackage <<<'
	drop procedure GetClientsForPackage
END
IF EXISTS (select * from GxQscripts where name='GetClientsForPackage')
	delete from GxQscripts where name = 'GetClientsForPackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientsForPackage')
	delete from GXDBVersions where aliasname = 'GetClientsForPackage'
GO
print '... Creating Procedure: GetClientsForPackage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientsForPackage
  @inputxml XML
AS
SET NOCOUNT ON
DECLARE @dropTempTable INT = 0
IF OBJECT_ID('tempdb.dbo.#ClientsForPackage_tmp__Clients') IS NULL
BEGIN
    -- temporary table does not exist in execution context. create one
    CREATE TABLE #ClientsForPackage_tmp__Clients (clientId INT PRIMARY KEY, clientName NVARCHAR (510))
    -- and set flag that indicates that it should be dropped
    SET @dropTempTable = 1
END
DECLARE @apptype    INT = ISNULL((SELECT ref.value('@applicationId', 'INT') FROM @inputxml.nodes('TMMsg_GetClientsForPackage/appType')     R(ref)), 0)
DECLARE @packageId  INT = ISNULL((SELECT ref.value('@packageId', 'INT')     FROM @inputxml.nodes('TMMsg_GetClientsForPackage/packageInfo') R(ref)), 0)
DECLARE @vendor     INT = ISNULL((SELECT ref.value('@vendor', 'INT')        FROM @inputxml.nodes('TMMsg_GetClientsForPackage')             R(ref)), 0)
DECLARE @vendorFlag int = 1
IF @vendor > 0 AND @apptype = 106
BEGIN
	--Set vendor flag based on the vendor Id in input xml
	IF @vendor = 2
		SET @vendorFlag = 65536  -- Hyper-V
	ELSE IF @vendor = 3
		SET @vendorFlag = 4		 -- Xen
	ELSE IF @vendor = 6
		SET @vendorFlag = 8		 -- Redhat
	ELSE IF @vendor = 4
		SET @vendorFlag = 16 	 -- Amazon
	ELSE IF @vendor = 10
		SET @vendorFlag = 4 	 -- Oracle VM on Xen
	ELSE IF @vendor = 16
		SET @vendorFlag = 64 	 -- Google Cloud
	ELSE IF @vendor = 19
		SET @vendorFlag = 128 	 -- Oracle Cloud Infrastructure
	ELSE IF @vendor = 18
		SET @vendorFlag = 256 	 -- Alibaba Cloud
	ELSE IF @vendor = 9  -- Nutanix AHV
	BEGIN
		SET @vendorFlag = 0  -- Reset flag if no check is required for this vendor
		SET @vendor = 0   -- Reset vendor type
	END
END
IF @packageId <> 0
BEGIN
	--Filter client list based on VSA vendor if vendor id is passed in XML and package Id is VSA package (713, 1136)
	IF @packageId in (713,1136)  AND @vendor > 0
	BEGIN
        INSERT INTO #ClientsForPackage_tmp__Clients
		    SELECT DISTINCT C.id, C.name
		    FROM APP_Client C WITH(NOLOCK) INNER JOIN simInstalledPackages SIM WITH(NOLOCK) ON C.id = SIM.ClientId
                                           INNER JOIN (SELECT  DISTINCT prop.componentNameId AS clientId
			                                           FROM    APP_ClientProp PROP WITH(NOLOCK)
			                                           WHERE       PROP.attrName = 'VSA HyperVisor Type'
                                                               AND (CAST(ISNULL(PROP.attrVal, '0') AS INT) & @vendorFlag) = @vendorFlag) VSA ON VSA.clientId = C.id
		    WHERE sim.simPackageID  = @packageId
		    ORDER BY C.name
	END
	ELSE
	BEGIN
        INSERT INTO #ClientsForPackage_tmp__Clients
		    SELECT  DISTINCT C.id, C.name
		    FROM    simInstalledPackages SIP WITH(NOLOCK) INNER JOIN APP_Client C WITH(NOLOCK) ON SIP.ClientId = C.id
		    WHERE   SIP.simPackageID = @packageId
		    ORDER   BY C.name
	END
END
ELSE
BEGIN
	IF @apptype = 106 and @vendor = 1
	BEGIN
		--Fetch VMware clients where MediaAgentApplianceType is set to indicate Unix proxies
		SET @vendor = CASE ISNULL((SELECT   TOP 1 CAST(value AS NVARCHAR(MAX))
                                   FROM     APP_AdvanceSettings
                                   WHERE        keyName='bEnableUnixProxyForVMWare'
                                            AND [enabled] = 1 AND relativePath = 'CommServDB.Console'), 'false') WHEN 'true' THEN 0 ELSE 1 END
	END
	IF @apptype = 106 AND @vendor > 0
	BEGIN
		IF @vendor = 1 or @vendor = 7 or @vendor = 5
		BEGIN
            INSERT INTO #ClientsForPackage_tmp__Clients
			    SELECT  DISTINCT C.id, C.name
			    FROM    simInstalledPackages SIP WITH(NOLOCK) INNER JOIN simPackageMap SP WITH(NOLOCK) ON SP.simPackageId = SIP.simPackageID
                                                              INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = SIP.ClientId
			    WHERE       SP.apptype = @apptype
                        AND (SIP.simPackageID = 713
						     OR C.id IN (SELECT SIM.clientId FROM simInstalledPackages SIM(nolock) WHERE SIM.simPackageID = 1136
													AND ((exists (SELECT componentNameId from APP_ClientProp prop (nolock) where
															    	prop.componentnameId = SIM.clientId and attrName = 'Mono Framework Installed' and attrVal = 1))	OR
																    (exists (SELECT prop.EntityId from MMEntityProp prop (nolock) where SIM.clientId = prop.EntityId
													      	          AND prop.propertyName = 'MediaAgentApplianceType' AND prop.intVal > 0)))))
		END
		ELSE
		BEGIN
            INSERT INTO #ClientsForPackage_tmp__Clients
			    SELECT  DISTINCT C.id, C.name
			    FROM    simInstalledPackages SIP WITH(NOLOCK)   INNER JOIN simPackageMap SP WITH(NOLOCK) ON SP.simPackageId = SIP.simPackageID
			                                                    INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = SIP.ClientId
                                                                INNER JOIN (SELECT  DISTINCT prop.componentNameId AS clientId
				                                                            FROM    APP_ClientProp PROP WITH(NOLOCK)
				                                                            WHERE       PROP.attrName = 'VSA HyperVisor Type'
                                                                                    AND (CAST(ISNULL(PROP.attrVal, '0') AS INT) & @vendorFlag) = @vendorFlag) VSA ON VSA.clientId = C.id
			    WHERE SP.apptype = @apptype
		END
	END
	ELSE IF @appType = 134 AND @packageID = 0
	BEGIN
		INSERT INTO #ClientsForPackage_tmp__Clients
		    SELECT  DISTINCT C.id, C.name
		    FROM    simInstalledPackages SIP WITH(NOLOCK) INNER JOIN APP_Client C WITH(NOLOCK) ON SIP.ClientId = C.id
		    WHERE   SIP.simPackageID IN (730, 1140) --	N_UNIX_PACKAGE_CLOUD_CONNECTOR, N_WIN_PACKAGE_CLOUD_CONNECTOR
		    ORDER   BY C.name
	END
	ELSE
	BEGIN
        INSERT INTO #ClientsForPackage_tmp__Clients
		    SELECT  DISTINCT C.id, C.name
		    FROM    simInstalledPackages SIP WITH (NOLOCK) INNER JOIN simPackageMap SP WITH(NOLOCK) ON SP.simPackageId = SIP.simPackageID
                                                           INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = SIP.ClientId
		    WHERE   SP.apptype = @apptype
	END
END
-- if there was temporary table it means that this stored proc called from another one which will use whatever is in #ClientsForPackage_tmp__Clients table
-- otherwise build xml message and select result set
IF @dropTempTable = 1
BEGIN
    DECLARE @rv XML = (SELECT DISTINCT clientId             AS '@clientId',
		                               clientName           AS '@clientName',
3    AS '@_type_'
		               FROM #ClientsForPackage_tmp__Clients
		               ORDER BY clientName
		               FOR XML PATH('clients'),ROOT('TMMsg_GetClientsForPackage'))
    DROP TABLE #ClientsForPackage_tmp__Clients
    SELECT @rv
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientsForPackage')
	delete from GxQscripts where name = 'GetClientsForPackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientsForPackage')
	delete from GXDBVersions where aliasname = 'GetClientsForPackage'
GO

insert into GXDBVersions values(2, 'GetClientsForPackage',  '00000000000000000000', 'GetClientsForPackage', '00000000000000000000')
GO

