

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientSummaryList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetClientSummaryList.sp,v $ $Id: GetClientSummaryList.sp,v 1.7.208.3 2019/05/25 14:49:18 raleti Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetClientSummaryList')
BEGIN
	print '>>> Drop Stored Procedure: GetClientSummaryList <<<'
	drop procedure GetClientSummaryList
END
IF EXISTS (select * from GxQscripts where name='GetClientSummaryList')
	delete from GxQscripts where name = 'GetClientSummaryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientSummaryList')
	delete from GXDBVersions where aliasname = 'GetClientSummaryList'
GO
print '... Creating Procedure: GetClientSummaryList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientSummaryList
  @capabilityReqd bigint,
  @locale_in integer,
  @userId integer
AS
SET NOCOUNT ON
BEGIN
DECLARE @xmlText XML
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#entitiesWithCapability') IS NOT null
   DROP TABLE #entitiesWithCapability
EXEC sec_updateUserCredentials @userId
create table  #entitiesWithCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
DECLARE @clientList TABLE
    (
      [localClientId] INT NOT null,
      [clientName] NVARCHAR(510),
      [displayName] NVARCHAR(510),
      [markedForDelete] INT,
      [pseudoRAC] INT,
      [dcInstalled] INT,
      [pseudoDpf] INT,
      [isVirtual] INT,
      [isPreConfigured] INT,
      [noValidIdasPresent] INT,
      [bkpActivityEnabled] INT,
      [rstActivityEnabled] INT,
      [ciActivityEnabled] INT
    )
EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithCapability'
INSERT INTO  @clientList
    SELECT Id ,[name], [displayName], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        FROM     APP_Client
        JOIN    #entitiesWithCapability sec ON
                ( (((capabilities & @capabilityReqd )<>0 ) OR (@capabilityReqd =0))
                  AND((Id = sec.clientId) OR (sec.commcellId = 2 AND sec.clientgroupId = 0 AND sec.clientId = 0 AND
                        sec.apptypeId = 0 AND sec.instanceId = 0 AND sec.subclientId = 0 AND sec.mediaAgentId = 0 AND sec.libraryId = 0 AND sec.archGroupId = 0
						AND sec.reviewSetId = 0 AND sec.querySetId = 0 AND sec.downloadSetId = 0 AND sec.tagId = 0 AND sec.legalHoldId = 0 AND sec.ermId = 0
						AND sec.cdPolicyId = 0 AND sec.complianceReportId = 0 AND sec.taskId = 0)))
        WHERE    Id > 1
   update @clientList set markedForDelete
      = (select attrVal from APP_ClientProp where componentNameId=[localClientId] and attrName='platformdeleted 4' and modified =0)
   update @clientList set pseudoRAC
      = (select [status] from APP_Client where Id = [localClientId] ) & 0x0040
   update @clientList set dcInstalled
      = (select attrVal from APP_ClientProp where componentnameid = [localClientId] and attrName = 'Data Classification Installed on Client' and modified =0)
   update @clientList set pseudoRAC
      = (select [status] from APP_Client where Id = [localClientId] ) & 0x0200
   update @clientList set isVirtual
      = (select attrVal from APP_ClientProp where componentNameId = [localClientId] and attrName='Virtual client'  and modified =0)
   update @clientList set isPreConfigured
      = (select [status] from APP_Client where Id = [localClientId] ) & 0x4000
   update @clientList set noValidIdasPresent
      = 1 WHERE NOT EXISTS (select id from licUsage WHERE optype = 'Install' AND Cid = [localClientId] AND InstallFlag = 0 AND AppType < 1000 )
   UPDATE @clientList SET noValidIdasPresent = 0
      WHERE EXISTS(SELECT id FROM APP_Application WHERE clientId = [localClientId] AND apptypeId IN (80, 103)) -- pseudo clients
   update @clientList set bkpActivityEnabled
      =(select J.action from JMJobAction as J where [clientId] = [localClientId] AND appType=0 AND mediaAgentId=1 AND opType=4)
   update @clientList set rstActivityEnabled
      =(select J.action from JMJobAction as J where [clientId] = [localClientId] AND appType=0 AND mediaAgentId=1 AND opType=5)
   update @clientList set ciActivityEnabled
      =ISNULL((select J.action from JMJobAction as J where [clientId] = [localClientId] AND appType=0 AND mediaAgentId=1 AND opType=57), 1)
----------------------------
--CONSTRUCT THE XML---------
----------------------------
SET @xmlText =
(
    SELECT
      localClientId AS "@clientId", clientName AS "@clientName", displayName AS "@displayName",
         markedForDelete AS "@markedForDelete",
         pseudoRAC AS "@pseudoRAC",
         dcInstalled AS "@DCInstalled",
         pseudoDpf AS "@pseudoDpf",
         isVirtual AS "@isVirtual",
         isPreConfigured AS "@isPreConfigured",
         noValidIdasPresent AS "@noValidIdasPresent",
         bkpActivityEnabled AS "@bkpActivityEnabled",
         rstActivityEnabled AS "@rstActivityEnabled",
         ciActivityEnabled AS "@ciActivityEnabled"
    FROM @clientList
       FOR XML  PATH('clients'), ROOT('EVGui_ClientListResp')
)
IF OBJECT_ID('tempdb.dbo.#entitiesWithCapability') IS NOT null
    DROP TABLE #entitiesWithCapability
SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientSummaryList')
	delete from GxQscripts where name = 'GetClientSummaryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientSummaryList')
	delete from GXDBVersions where aliasname = 'GetClientSummaryList'
GO

insert into GXDBVersions values(2, 'GetClientSummaryList',  '00010007020800030000', 'GetClientSummaryList', '00010007020800030000')
GO

