

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientOwnersList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  GetClientOwners()
--  | Description:  Get user information given username
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetClientOwnersList.sp,v $ $Id: GetClientOwnersList.sp,v 1.3.42.3 2018/08/13 14:27:06 gpattabiraman Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetClientOwnersList <<<'

IF EXISTS (select * from sysobjects where name='GetClientOwnersList')
	drop procedure GetClientOwnersList
IF EXISTS (select * from GxQscripts where name='GetClientOwnersList')
	delete from GxQscripts where name = 'GetClientOwnersList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientOwnersList')
	delete from GXDBVersions where aliasname = 'GetClientOwnersList'
GO
print '... Creating Procedure: GetClientOwnersList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientOwnersList
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML	
BEGIN
SET @o_xmlText = '<EVGui_GetClientOwnersResp />'
DECLARE @i_clientId     INT
SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int') FROM @i_xmlText.nodes('EVGui_GetClientOwners/client') R ( ref ) ), 0)
IF @i_clientId = 0
BEGIN
        SET @o_ErrorCode = 2
        SET @o_ErrorString = 'Client Id Not Found'
        GOTO EXIT_PROC
END
SET @o_xmlText=(SELECT
					(SELECT CASE
								WHEN CHARINDEX('\',U.login) > 0 THEN '1' ELSE '0'
						    END AS '@isExternal',
						    CO.userid AS 'user/@userId',
						    ISNULL(UCM.localUserLogin, U.login) AS 'user/@userName'
					FROM sec_getClientOwnersExpandUG CO
					INNER JOIN UMUsers U ON CO.clientId = @i_clientId AND CO.userId = U.id
LEFT JOIN APP_ClientProp CP ON CP.componentNameId = @i_clientId AND CP.modified = 0 AND CP.attrName = 'User Centric Client' AND CP.attrVal = '1'
					LEFT JOIN UMClientUserMap UCM ON UCM.clientId = CP.componentNameId AND UCM.umUserId = CO.userId
					FOR XML PATH('Owner'), TYPE )
				FOR XML PATH('EVGui_GetClientOwnersResp'), TYPE)
EXIT_PROC:
IF @o_ErrorCode > 0
BEGIN
    SET @o_xmlText =
       (
           SELECT @o_ErrorCode '@errorCode',
                  @o_ErrorString '@errorMessage'
           FOR XML PATH ('error'), ROOT('EVGui_GetClientOwnersResp')
       )
    END
	SELECT @o_xmlText
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetClientOwnersList')
	delete from GxQscripts where name = 'GetClientOwnersList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientOwnersList')
	delete from GXDBVersions where aliasname = 'GetClientOwnersList'
GO

insert into GXDBVersions values(2, 'GetClientOwnersList',  '00010003004200030000', 'GetClientOwnersList', '00010003004200030000')
GO

