

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientListWithCSAsCacheSrc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetClientListWithCSAsCacheSrc.sp,v $ $Id: GetClientListWithCSAsCacheSrc.sp,v 1.1.288.1 2018/03/22 02:58:13 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--      | GetClientListWihtCSAsCacheSrc
--      | Returns the list of valid clients whose update cache source is CS     |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetClientListWithCSAsCacheSrc <<<'

IF EXISTS (select * from sysobjects where name='GetClientListWithCSAsCacheSrc')
	drop procedure GetClientListWithCSAsCacheSrc
IF EXISTS (select * from GxQscripts where name='GetClientListWithCSAsCacheSrc')
	delete from GxQscripts where name = 'GetClientListWithCSAsCacheSrc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientListWithCSAsCacheSrc')
	delete from GXDBVersions where aliasname = 'GetClientListWithCSAsCacheSrc'
GO
print '... Creating Procedure: GetClientListWithCSAsCacheSrc'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetClientListWithCSAsCacheSrc
AS
  DECLARE @out_id integer;
SET NOCOUNT ON
IF object_id('tempdb.dbo.#ClientListNCS') is not null
					DROP TABLE #ClientListNCS
CREATE	TABLE #ClientListNCS (id INT)
INSERT INTO #ClientListNCS
SELECT componentNameId FROM App_ClientProp WHERE attrName='Update Cache Agent ID' AND attrVal IN(
SELECT Id FROM PatchUpdateAgentInfo WHERE isDeleted=0)
INSERT INTO #ClientListNCS
SELECT DISTINCT clientId FROM App_ClientGroupAssoc WHERE clientGroupId IN
(
SELECT  componentId  FROM App_ComponentProp AS ACP, APP_ClientGroupAssoc AS ACGA,
PatchUpdateAgentInfo PUA
WHERE ACP.componentId=ACGA.clientGroupId AND ACP.componentType=8 AND
ACP.propertyTypeId=1300 AND PUA.Id=ACP.longVal AND PUA.isDeleted=0
)
SELECT Id FROM App_Client WHERE Id NOT IN(SELECT Id FROM #ClientListNCS) AND Id <> 1 AND status=0
DROP TABLE #ClientListNCS
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientListWithCSAsCacheSrc')
	delete from GxQscripts where name = 'GetClientListWithCSAsCacheSrc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientListWithCSAsCacheSrc')
	delete from GXDBVersions where aliasname = 'GetClientListWithCSAsCacheSrc'
GO

insert into GXDBVersions values(2, 'GetClientListWithCSAsCacheSrc',  '00010001028800010000', 'GetClientListWithCSAsCacheSrc', '00010001028800010000')
GO

