

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetClientListForUAConfig.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetClientListForUAConfig.sp,v $ $Id: GetClientListForUAConfig.sp,v 1.7.66.3 2020/10/04 00:32:30 kvankadaru Exp $";
--  +========================================================================+
--  | Stored Proc:  GetClientListForUAConfig
--  | An optimized stored procedure to return the list of potential UA faster.
--	| Change: 13 May 2010: We fetch all reqd values in their proper data format within the SP.
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetClientListForUAConfig')
BEGIN
	print '>>> Drop Stored Procedure: GetClientListForUAConfig <<<'
	drop procedure GetClientListForUAConfig
END
IF EXISTS (select * from GxQscripts where name='GetClientListForUAConfig')
	delete from GxQscripts where name = 'GetClientListForUAConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientListForUAConfig')
	delete from GXDBVersions where aliasname = 'GetClientListForUAConfig'
GO
print '... Creating Procedure: GetClientListForUAConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetClientListForUAConfig
  @i_userId integer
AS
  DECLARE @ClientId integer;
  DECLARE @name varchar(255);
  DECLARE @PatchLocalPath varchar(1024);
  DECLARE @NetworkSharePath varchar(1024);
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
IF object_id('tempdb.dbo.#AU_Client') is not null
					DROP TABLE #AU_Client
IF object_id('tempdb.dbo.#AU_ClientProp') is not null
					DROP TABLE #AU_ClientProp
IF object_id('tempdb.dbo.#ClientsWithDeprecatedOSes') is not null
					DROP TABLE #ClientsWithDeprecatedOSes
CREATE	TABLE #AU_Client (id INT, ClientName VARCHAR(255),flag INT,
						CachePath VARCHAR(1024), NetworkCachePath VARCHAR(1024) )
CREATE NONCLUSTERED INDEX AU_UAClients_Idx ON #AU_Client(id)
CREATE	TABLE #AU_ClientProp (componentNameId INT, attrName NVARCHAR(1024), attrVal NVARCHAR(1024))
CREATE NONCLUSTERED INDEX AU_UAClients_Idx ON #AU_ClientProp (componentNameId)
CREATE TABLE #ClientsWithDeprecatedOSes (clientId INT, operatingSystemVersion VARCHAR(64), operatingSystemName VARCHAR(64), typeOfMachine INTEGER)
-- Fetch all non-CS
INSERT	INTO #AU_Client
SELECT	CL.id, CL.name,0,NULL,'\\' + CL.net_hostname + '\SoftwareShare'
FROM	APP_Client AS CL
WHERE	CL.id <> 2 AND CL.releaseId >= 14
	AND (CL.status NOT IN ( 0x0002,0x0004,0x0040,0x0080,0x4000) )
	AND (specialClientFlags & 0x02) <> 0x02
-- visibility check
if (@i_userId <> 0)
BEGIN
	IF object_id('tempdb.dbo.#ClientListForUATmp') is not null DROP TABLE #ClientListForUATmp
create table  #ClientListForUATmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
 	EXEC sec_getUserObjects @i_userId, 2009, 0, '#ClientListForUATmp'
	delete #ClientListForUATmp WHERE clientGroupId <> 0
	delete #AU_Client WHERE NOT EXISTS (SELECT * FROM #ClientListForUATmp WHERE clientId in (0,id))
	DROP TABLE #ClientListForUATmp
END
-- Delete all virtual clients
DELETE FROM #AU_Client
WHERE id IN
(SELECT CLP.componentNameId FROM App_ClientProp as CLP, #AU_Client AS CL WHERE
CLP.componentNameId=CL.Id AND CLP.attrName='Virtual Client' AND CLP.attrVal='1')
-- Fetch client's cache path and binary set ID
INSERT	INTO #AU_ClientProp
SELECT	CLP.componentNameId, CLP.attrName, CLP.attrVal
FROM	App_ClientProp AS CLP, #AU_Client AS CL
WHERE	CLP.componentNameId = CL.id
	AND CLP.attrName IN (N'Patch Local Location',N'Binary Set ID')
-- Delete netware clients and clients whose OS type is un-known.
DELETE FROM #AU_Client
WHERE id IN
(SELECT CLP.componentNameId FROM #AU_ClientProp as CLP, #AU_Client AS CL WHERE
CLP.componentNameId=CL.Id AND CLP.attrName=N'Binary Set ID' AND
( CLP.attrVal=4 OR CLP.attrVal NOT IN (SELECT BinarySetID FROM PatchUpdateOS WITH (NOLOCK)) )
)
-- Delete clients with deprecated oses
INSERT INTO #ClientsWithDeprecatedOSes
EXEC simGetClientsWithDeprecatedOS 0, 1
DELETE FROM #AU_Client
WHERE id IN ( SELECT clientid FROM #ClientsWithDeprecatedOSes )
UPDATE #AU_Client SET flag=1 WHERE Id IN
(SELECT CL.Id from #AU_Client AS CL,#AU_ClientProp as CLP WHERE CLP.componentNameId=CL.Id
AND CLP.attrName='Binary Set ID' AND EXISTS (SELECT * FROM PatchUpdateOS AS PUO WITH (NOLOCK) WHERE PUO.BinarySetID=CLP.attrVal AND PUO.UpdateOSID BETWEEN 6 AND 13)
)
-- Fetch local cache path.
UPDATE #AU_Client SET CachePath =
   (SELECT attrVal FROM #AU_ClientProp WHERE componentNameId = #AU_Client.id AND attrName = N'Patch Local Location')
-- Append 'SoftwareCache' to the cache path (windows clients)
UPDATE #AU_Client SET CachePath =
(CASE (LEFT(REVERSE(LTRIM(RTRIM(CachePath))),1)) WHEN '\' THEN CachePath + 'SoftwareCache'
						ELSE CachePath + '\SoftwareCache' END)
WHERE flag = 0
---- Append 'SoftwareCache' to the cache path (Unix clients)
UPDATE #AU_Client SET CachePath =
(CASE (LEFT(REVERSE(LTRIM(RTRIM(CachePath))),1)) WHEN '/' THEN CachePath + 'SoftwareCache'
						ELSE CachePath + '/SoftwareCache' END)
WHERE flag = 1
SELECT id,ClientName,CachePath,NetworkCachePath FROM #AU_Client
DROP TABLE #AU_Client
DROP TABLE #AU_ClientProp
DROP TABLE #ClientsWithDeprecatedOSes
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientListForUAConfig')
	delete from GxQscripts where name = 'GetClientListForUAConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientListForUAConfig')
	delete from GXDBVersions where aliasname = 'GetClientListForUAConfig'
GO

insert into GXDBVersions values(2, 'GetClientListForUAConfig',  '00010007006600030000', 'GetClientListForUAConfig', '00010007006600030000')
GO

